/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin;

import com.google.common.collect.Sets;
import com.supermartijn642.fusion.extensions.PackResourcesExtension;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.FolderPackResources;
import net.minecraft.server.packs.PackType;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FolderPackResources.class})
public class FolderPackResourcesMixin
implements PackResourcesExtension {
    @Unique
    private File overridesFolder;

    @Override
    public void setFusionOverridesFolder(@NotNull String folder) {
        this.overridesFolder = new File(((FolderPackResources)this).f_10203_, folder);
    }

    @Shadow
    private void m_215333_(File folder, String namespace, List<ResourceLocation> locations, String folderPath, Predicate<ResourceLocation> locationPredicate) {
        throw new AssertionError();
    }

    @Inject(method={"getFile"}, at={@At(value="HEAD")}, cancellable=true)
    private void getFile(String path, CallbackInfoReturnable<File> ci) {
        if (this.overridesFolder == null) {
            return;
        }
        try {
            File file = new File(this.overridesFolder, path);
            if (file.isFile() && FolderPackResources.m_10273_((File)file, (String)path)) {
                ci.setReturnValue((Object)file);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Inject(method={"getNamespaces"}, at={@At(value="RETURN")}, cancellable=true)
    private void getNamespaces(PackType type, CallbackInfoReturnable<Set<String>> ci) {
        if (this.overridesFolder == null) {
            return;
        }
        HashSet namespaces = Sets.newHashSet((Iterable)((Iterable)ci.getReturnValue()));
        File typeFolder = new File(this.overridesFolder, type.m_10305_());
        File[] folders = typeFolder.listFiles((FileFilter)DirectoryFileFilter.DIRECTORY);
        if (folders == null) {
            return;
        }
        for (File folder : folders) {
            String relativePath = FolderPackResources.m_10217_((File)typeFolder, (File)folder);
            if (relativePath.equals(relativePath.toLowerCase(Locale.ROOT))) {
                namespaces.add(relativePath.substring(0, relativePath.length() - 1));
                continue;
            }
            ((FolderPackResources)this).m_10230_(relativePath);
        }
        ci.setReturnValue((Object)namespaces);
    }

    @Inject(method={"getResources"}, at={@At(value="RETURN")}, cancellable=true)
    private void getResources(PackType type, String namespace, String folderName, Predicate<ResourceLocation> predicate, CallbackInfoReturnable<Collection<ResourceLocation>> ci) {
        if (this.overridesFolder == null) {
            return;
        }
        if (ci.getReturnValue() == null) {
            return;
        }
        ArrayList<ResourceLocation> locations = ci.getReturnValue() instanceof ArrayList ? (List)ci.getReturnValue() : new ArrayList((Collection)ci.getReturnValue());
        HashSet locationSet = new HashSet(locations);
        File folder = new File(new File(new File(this.overridesFolder, type.m_10305_()), namespace), folderName);
        this.m_215333_(folder, namespace, locations, folderName + "/", location -> !locationSet.contains(location) && predicate.test((ResourceLocation)location));
        ci.setReturnValue(locations);
    }
}

