/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.entity.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.supermartijn642.fusion.entity.model.DummyModelPart;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.core.Direction;

public class ModelTransformer {
    private static final ModelPart.Vertex[] DUMMY_VERTICES = new ModelPart.Vertex[]{new ModelPart.Vertex(0.0f, 0.0f, 0.0f, 0.0f, 0.0f), new ModelPart.Vertex(0.0f, 0.0f, 0.0f, 0.0f, 0.0f), new ModelPart.Vertex(0.0f, 0.0f, 0.0f, 0.0f, 0.0f), new ModelPart.Vertex(0.0f, 0.0f, 0.0f, 0.0f, 0.0f)};

    public static ModelPart flipX(ModelPart model) {
        return ModelTransformer.transform(model, part -> {
            part.f_104200_ *= -1.0f;
            part.f_104204_ *= -1.0f;
            part.f_104205_ *= -1.0f;
            PartPose pose = part.f_233557_;
            part.f_233557_ = pose = PartPose.m_171423_((float)(-pose.f_171405_), (float)pose.f_171406_, (float)pose.f_171407_, (float)pose.f_171408_, (float)(-pose.f_171409_), (float)(-pose.f_171410_));
        }, cube -> {
            float maxX = cube.f_104338_;
            cube.f_104338_ = -cube.f_104335_;
            cube.f_104335_ = -maxX;
        }, polygon -> polygon.f_104360_.m_122263_(-1.0f, 1.0f, 1.0f), vertex -> vertex.f_104371_.m_122263_(-1.0f, 1.0f, 1.0f));
    }

    public static ModelPart flipY(ModelPart model) {
        return ModelTransformer.transform(model, part -> {
            part.f_104201_ *= -1.0f;
            part.f_104203_ *= -1.0f;
            part.f_104205_ *= -1.0f;
            PartPose pose = part.f_233557_;
            part.f_233557_ = pose = PartPose.m_171423_((float)pose.f_171405_, (float)(-pose.f_171406_), (float)pose.f_171407_, (float)(-pose.f_171408_), (float)pose.f_171409_, (float)(-pose.f_171410_));
        }, cube -> {
            float maxY = cube.f_104339_;
            cube.f_104339_ = -cube.f_104336_;
            cube.f_104336_ = -maxY;
        }, polygon -> polygon.f_104360_.m_122263_(1.0f, -1.0f, 1.0f), vertex -> vertex.f_104371_.m_122263_(1.0f, -1.0f, 1.0f));
    }

    public static ModelPart flipZ(ModelPart model) {
        return ModelTransformer.transform(model, part -> {
            part.f_104202_ *= -1.0f;
            part.f_104203_ *= -1.0f;
            part.f_104204_ *= -1.0f;
            PartPose pose = part.f_233557_;
            part.f_233557_ = pose = PartPose.m_171423_((float)pose.f_171405_, (float)pose.f_171406_, (float)(-pose.f_171407_), (float)(-pose.f_171408_), (float)(-pose.f_171409_), (float)pose.f_171410_);
        }, cube -> {
            float maxZ = cube.f_104340_;
            cube.f_104340_ = -cube.f_104337_;
            cube.f_104337_ = -maxZ;
        }, polygon -> polygon.f_104360_.m_122263_(1.0f, 1.0f, -1.0f), vertex -> vertex.f_104371_.m_122263_(1.0f, 1.0f, -1.0f));
    }

    public static ModelPart translateX(ModelPart model, float translation) {
        ModelPart copy = ModelTransformer.transform(model, part -> {}, cube -> {}, polygon -> {}, vertex -> {});
        copy.f_104202_ += (translation *= 16.0f);
        PartPose pose = copy.f_233557_;
        copy.f_233557_ = pose = PartPose.m_171423_((float)pose.f_171405_, (float)pose.f_171406_, (float)(pose.f_171407_ + translation), (float)pose.f_171408_, (float)pose.f_171409_, (float)pose.f_171410_);
        return copy;
    }

    public static ModelPart translateY(ModelPart model, float translation) {
        ModelPart copy = ModelTransformer.transform(model, part -> {}, cube -> {}, polygon -> {}, vertex -> {});
        copy.f_104201_ += (translation *= 16.0f);
        PartPose pose = copy.f_233557_;
        copy.f_233557_ = pose = PartPose.m_171423_((float)pose.f_171405_, (float)(pose.f_171406_ + translation), (float)pose.f_171407_, (float)pose.f_171408_, (float)pose.f_171409_, (float)pose.f_171410_);
        return copy;
    }

    public static ModelPart translateZ(ModelPart model, float translation) {
        ModelPart copy = ModelTransformer.transform(model, part -> {}, cube -> {}, polygon -> {}, vertex -> {});
        copy.f_104200_ += (translation *= 16.0f);
        PartPose pose = copy.f_233557_;
        copy.f_233557_ = pose = PartPose.m_171423_((float)(pose.f_171405_ + translation), (float)pose.f_171406_, (float)pose.f_171407_, (float)pose.f_171408_, (float)pose.f_171409_, (float)pose.f_171410_);
        return copy;
    }

    private static ModelPart transform(ModelPart part, Consumer<ModelPart> partTransform, Consumer<ModelPart.Cube> cubeTransform, Consumer<ModelPart.Polygon> polygonTransform, Consumer<ModelPart.Vertex> vertexTransform) {
        DummyModelPart copy;
        if (part instanceof DummyModelPart) {
            copy = new DummyModelPart(ModelTransformer.transform(((DummyModelPart)part).getDummyChild(), partTransform, cubeTransform, polygonTransform, vertexTransform));
        } else {
            ImmutableList.Builder cubes = ImmutableList.builderWithExpectedSize((int)part.f_104212_.size());
            for (ModelPart.Cube cube : part.f_104212_) {
                cubes.add((Object)ModelTransformer.transform(cube, cubeTransform, polygonTransform, vertexTransform));
            }
            ImmutableMap.Builder children = ImmutableMap.builderWithExpectedSize((int)part.f_104213_.size());
            for (Map.Entry entry : part.f_104213_.entrySet()) {
                children.put((Object)((String)entry.getKey()), (Object)ModelTransformer.transform((ModelPart)entry.getValue(), partTransform, cubeTransform, polygonTransform, vertexTransform));
            }
            copy = new ModelPart((List)cubes.build(), (Map)children.build());
        }
        copy.f_104200_ = part.f_104200_;
        copy.f_104201_ = part.f_104201_;
        copy.f_104202_ = part.f_104202_;
        copy.f_104203_ = part.f_104203_;
        copy.f_104204_ = part.f_104204_;
        copy.f_104205_ = part.f_104205_;
        copy.f_233553_ = part.f_233553_;
        copy.f_233554_ = part.f_233554_;
        copy.f_233555_ = part.f_233555_;
        copy.f_104207_ = part.f_104207_;
        copy.f_233556_ = part.f_233556_;
        copy.f_233557_ = part.f_233557_;
        partTransform.accept(copy);
        return copy;
    }

    private static ModelPart.Cube transform(ModelPart.Cube cube, Consumer<ModelPart.Cube> cubeTransform, Consumer<ModelPart.Polygon> polygonTransform, Consumer<ModelPart.Vertex> vertexTransform) {
        ModelPart.Cube copy = new ModelPart.Cube(0, 0, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, false, 0.0f, 0.0f);
        copy.f_104341_ = (ModelPart.Polygon[])Arrays.stream(cube.f_104341_).map(p -> ModelTransformer.transform(p, polygonTransform, vertexTransform)).toArray(ModelPart.Polygon[]::new);
        copy.f_104335_ = cube.f_104335_;
        copy.f_104336_ = cube.f_104336_;
        copy.f_104337_ = cube.f_104337_;
        copy.f_104338_ = cube.f_104338_;
        copy.f_104339_ = cube.f_104339_;
        copy.f_104340_ = cube.f_104340_;
        return copy;
    }

    private static ModelPart.Polygon transform(ModelPart.Polygon polygon, Consumer<ModelPart.Polygon> polygonTransform, Consumer<ModelPart.Vertex> vertexTransform) {
        ModelPart.Polygon copy = new ModelPart.Polygon(DUMMY_VERTICES, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, false, Direction.UP);
        copy.f_104359_ = (ModelPart.Vertex[])Arrays.stream(polygon.f_104359_).map(v -> ModelTransformer.transform(v, vertexTransform)).toArray(ModelPart.Vertex[]::new);
        copy.f_104360_ = polygon.f_104360_;
        return copy;
    }

    private static ModelPart.Vertex transform(ModelPart.Vertex vertex, Consumer<ModelPart.Vertex> vertexTransform) {
        ModelPart.Vertex copy = new ModelPart.Vertex(vertex.f_104371_.m_122281_(), vertex.f_104372_, vertex.f_104373_);
        vertexTransform.accept(copy);
        return copy;
    }
}

