/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.supermartijn642.fusion.entity.model.DummyModelPart;
import com.supermartijn642.fusion.entity.model.FusionModelPart;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import net.minecraft.client.model.geom.ModelPart;

public class SubModelPart
extends ModelPart {
    protected FusionModelPart mainPart;
    private Map<String, SubModelPart> importantChildren = new HashMap<String, SubModelPart>();
    private boolean finished = false;
    private boolean isMirroringDummy = false;
    private SubModelPart dummyChild;

    public SubModelPart(FusionModelPart mainPart) {
        super(null, new HashMap());
        this.mainPart = mainPart;
    }

    public void validateModelHasImportantChildren(ModelPart model, Consumer<String> missingPartOutput) {
        if (!this.finished) {
            throw new IllegalStateException("Model must be finished before validation!");
        }
        for (String importantChild : this.importantChildren.keySet()) {
            if (!model.m_233562_(importantChild)) {
                missingPartOutput.accept(importantChild);
                continue;
            }
            this.importantChildren.get(importantChild).validateModelHasImportantChildren(model.m_171324_(importantChild), missingPartOutput);
        }
    }

    public void finish() {
        this.finished = true;
        this.importantChildren = Map.copyOf(this.importantChildren);
        for (SubModelPart part : this.importantChildren.values()) {
            part.finish();
        }
    }

    public void mirror(ModelPart target) {
        this.f_104200_ = target.f_104200_;
        this.f_104201_ = target.f_104201_;
        this.f_104202_ = target.f_104202_;
        this.f_104203_ = target.f_104203_;
        this.f_104204_ = target.f_104204_;
        this.f_104205_ = target.f_104205_;
        this.f_233553_ = target.f_233553_;
        this.f_233554_ = target.f_233554_;
        this.f_233555_ = target.f_233555_;
        this.f_104207_ = target.f_104207_;
        this.f_233556_ = target.f_233556_;
        this.f_104212_ = target.f_104212_;
        this.f_233557_ = target.f_233557_;
        this.f_104213_.clear();
        if (target instanceof DummyModelPart) {
            if (this.dummyChild == null) {
                this.dummyChild = new SubModelPart(this.mainPart);
                this.dummyChild.finished = true;
                this.dummyChild.importantChildren = this.importantChildren;
            }
            this.isMirroringDummy = true;
            this.dummyChild.mirror(((DummyModelPart)target).getDummyChild());
            this.f_104213_.put("dummy", this.dummyChild);
            return;
        }
        this.isMirroringDummy = false;
        for (String key : target.f_104213_.keySet()) {
            if (!this.importantChildren.containsKey(key)) {
                this.f_104213_.put(key, target.m_171324_(key));
                continue;
            }
            SubModelPart importantChild = this.importantChildren.get(key);
            this.f_104213_.put(key, importantChild);
            importantChild.mirror((ModelPart)target.f_104213_.get(key));
        }
    }

    public boolean m_233562_(String name) {
        if (this.isMirroringDummy) {
            this.dummyChild.m_233562_(name);
        }
        return !this.finished || this.importantChildren.containsKey(name);
    }

    public ModelPart m_171324_(String name) {
        if (this.isMirroringDummy) {
            this.dummyChild.m_171324_(name);
        }
        if (this.importantChildren.containsKey(name)) {
            return this.finished ? (ModelPart)this.f_104213_.get(name) : (ModelPart)this.importantChildren.get(name);
        }
        if (!this.finished) {
            SubModelPart part = new SubModelPart(this.mainPart);
            this.importantChildren.put(name, part);
            return part;
        }
        throw new NoSuchElementException("Can't find part " + name);
    }

    public void m_104306_(PoseStack poseStack, VertexConsumer vertexConsumer, int i, int j, float f, float g, float h, float k) {
        this.mainPart.renderPart(this, poseStack, vertexConsumer, i, j, f, g, h, k);
    }

    protected void renderInternal(PoseStack poseStack, VertexConsumer vertexConsumer, int i, int j, float f, float g, float h, float k) {
        if (!(!this.f_104207_ || this.f_104212_.isEmpty() && this.f_104213_.isEmpty())) {
            poseStack.m_85836_();
            this.m_104299_(poseStack);
            if (!this.f_233556_) {
                for (ModelPart.Cube cube : this.f_104212_) {
                    cube.m_171332_(poseStack.m_85850_(), vertexConsumer, i, j, f, g, h, k);
                }
            }
            for (ModelPart child : this.f_104213_.values()) {
                if (child instanceof SubModelPart) {
                    ((SubModelPart)child).renderInternal(poseStack, vertexConsumer, i, j, f, g, h, k);
                    continue;
                }
                child.m_104306_(poseStack, vertexConsumer, i, j, f, g, h, k);
            }
            poseStack.m_85849_();
        }
    }
}

