/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.api.provider;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.ResourceGenerator;
import com.supermartijn642.core.generator.ResourceType;
import com.supermartijn642.fusion.api.model.FusionModelTypeRegistry;
import com.supermartijn642.fusion.api.model.ModelInstance;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;

public abstract class FusionModelProvider
extends ResourceGenerator {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
    private final Map<ResourceLocation, ModelInstance<?>> models = new HashMap();

    public FusionModelProvider(String modid, ResourceCache cache) {
        super(modid, cache);
    }

    public void save() {
        for (Map.Entry<ResourceLocation, ModelInstance<?>> entry : this.models.entrySet()) {
            ResourceLocation location = entry.getKey();
            ModelInstance<?> model = entry.getValue();
            this.cache.saveJsonResource(ResourceType.ASSET, FusionModelTypeRegistry.serializeModelData(model), location.func_110624_b(), "models", location.func_110623_a());
        }
    }

    public abstract void generate();

    public final void addModel(ResourceLocation location, ModelInstance<?> model) {
        ModelInstance<?> previousValue = this.models.put(location, model);
        if (previousValue != null) {
            throw new RuntimeException("Duplicate model for '" + location + "'!");
        }
    }

    public String getName() {
        return "Fusion Model Provider: " + this.modName;
    }
}

