/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin.forge;

import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.extensions.ResourcePackExtension;
import com.supermartijn642.fusion.resources.FusionPackMetadataSection;
import java.io.FileNotFoundException;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.data.IMetadataSectionSerializer;
import net.minecraft.client.resources.data.MetadataSerializer;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.ModContainer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FMLClientHandler.class}, remap=false)
public class FMLClientHandlerMixin {
    @Unique
    private static final MetadataSerializer METADATA_SERIALIZER = new MetadataSerializer();

    @Inject(method={"addModAsResource"}, at={@At(value="INVOKE", target="Ljava/util/Map;put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", shift=At.Shift.AFTER)})
    private void addModAsResource(ModContainer container, CallbackInfo ci) {
        IResourcePack resources = ((FMLClientHandler)this).getResourcePackFor(container.getModId());
        if (resources instanceof ResourcePackExtension) {
            String overridesFolder;
            try {
                FusionPackMetadataSection.Data data = (FusionPackMetadataSection.Data)resources.func_135058_a(METADATA_SERIALIZER, FusionPackMetadataSection.INSTANCE.func_110483_a());
                overridesFolder = data == null ? null : data.metadata.getOverridesFolder();
            }
            catch (FileNotFoundException ignore) {
                return;
            }
            catch (Exception e) {
                FusionClient.LOGGER.error("Encountered an exception whilst reading fusion metadata for pack '" + resources.func_130077_b() + "':", (Throwable)e);
                return;
            }
            if (overridesFolder != null) {
                ((ResourcePackExtension)resources).setFusionOverridesFolder(overridesFolder);
            }
        }
    }

    static {
        METADATA_SERIALIZER.func_110504_a((IMetadataSectionSerializer)FusionPackMetadataSection.INSTANCE, FusionPackMetadataSection.Data.class);
    }
}

