/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model;

import com.supermartijn642.fusion.api.model.DefaultModelTypes;
import com.supermartijn642.fusion.api.model.GatherTexturesContext;
import com.supermartijn642.fusion.api.model.ModelInstance;
import com.supermartijn642.fusion.api.model.SpriteIdentifier;
import com.supermartijn642.fusion.extensions.BlockModelExtension;
import com.supermartijn642.fusion.model.ModelBakingContextImpl;
import com.supermartijn642.fusion.model.ModelInstanceImpl;
import com.supermartijn642.fusion.model.ModelTypeRegistryImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;

public class FusionBlockModel
extends ModelBlock
implements IModel {
    private final ModelInstance<?> model;
    private final ModelBlock vanillaModel;
    private Collection<ResourceLocation> dependencies;

    public FusionBlockModel(ModelInstance<?> model) {
        super(null, Collections.emptyList(), Collections.emptyMap(), false, false, ItemCameraTransforms.field_178357_a, Collections.emptyList());
        this.model = model;
        this.vanillaModel = model.getAsVanillaModel();
    }

    public IBakedModel bake(IModelState modelTransform, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> spriteGetter) {
        ModelBakingContextImpl context = new ModelBakingContextImpl(spriteGetter, modelTransform, new ResourceLocation(this.field_178317_b));
        return this.model.bake(context);
    }

    public Collection<ResourceLocation> getDependencies() {
        if (this.dependencies != null) {
            return this.dependencies;
        }
        try {
            this.dependencies = this.model.getModelDependencies();
        }
        catch (Exception e) {
            throw new RuntimeException("Encountered an exception whilst requesting dependencies from model type '" + ModelTypeRegistryImpl.getIdentifier(this.model.getModelType()) + "' for  '" + this.field_178317_b + "'!", e);
        }
        if (this.dependencies == null) {
            throw new RuntimeException("Model type '" + ModelTypeRegistryImpl.getIdentifier(this.model.getModelType()) + "' returned null when requesting dependencies '" + this.field_178317_b + "'!");
        }
        return this.dependencies;
    }

    public Collection<ResourceLocation> getTextures() {
        GatherTexturesContext context = FusionBlockModel::getModelInstance;
        Collection materials = null;
        try {
            Collection<SpriteIdentifier> pairs = this.model.getTextureDependencies(context);
            if (pairs != null) {
                materials = pairs.stream().map(SpriteIdentifier::getTexture).collect(Collectors.toSet());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Encountered an exception whilst requesting texture dependencies from model type '" + ModelTypeRegistryImpl.getIdentifier(this.model.getModelType()) + "' for '" + this.field_178317_b + "'!", e);
        }
        if (materials == null) {
            throw new RuntimeException("Model type '" + ModelTypeRegistryImpl.getIdentifier(this.model.getModelType()) + "' returned null when requesting texture dependencies for '" + this.field_178317_b + "'!");
        }
        return materials;
    }

    public Optional<ModelBlock> asVanillaModel() {
        return Optional.ofNullable(this.vanillaModel);
    }

    public static ModelInstance<?> getModelInstance(ResourceLocation location) {
        IModel model = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)location);
        if (model instanceof FusionBlockModel) {
            return ((FusionBlockModel)model).model;
        }
        Optional optional = model.asVanillaModel();
        if (optional.isPresent()) {
            ModelBlock vanillaModel = (ModelBlock)optional.get();
            ModelInstance<?> modelInstance = ((BlockModelExtension)vanillaModel).getFusionModel();
            if (modelInstance == null) {
                modelInstance = new ModelInstanceImpl<ModelBlock>(DefaultModelTypes.VANILLA, vanillaModel);
                ((BlockModelExtension)vanillaModel).setFusionModel(modelInstance);
            }
            return modelInstance;
        }
        return new ModelInstanceImpl<IModel>(DefaultModelTypes.UNKNOWN, model);
    }
}

