/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.texture.types.scrolling;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.texture.SpriteCreationContext;
import com.supermartijn642.fusion.api.texture.SpritePreparationContext;
import com.supermartijn642.fusion.api.texture.TextureType;
import com.supermartijn642.fusion.api.texture.data.BaseTextureData;
import com.supermartijn642.fusion.api.texture.data.ScrollingTextureData;
import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.texture.types.base.BaseTextureSprite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureUtil;

public class ScrollingTextureType
implements TextureType<ScrollingTextureData> {
    @Override
    public ScrollingTextureData deserialize(JsonObject json) throws JsonParseException {
        ScrollingTextureData.Builder builder = ScrollingTextureData.builder();
        if (json.has("from")) {
            ScrollingTextureData.Position from;
            if (!json.get("from").isJsonPrimitive() || !json.getAsJsonPrimitive("from").isString()) {
                throw new JsonParseException("Property 'from' must be a string!");
            }
            String fromString = json.get("from").getAsString();
            try {
                from = ScrollingTextureData.Position.valueOf(fromString.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new JsonParseException("Property 'from' must be one of " + Arrays.toString((Object[])ScrollingTextureData.Position.values()).toLowerCase(Locale.ROOT) + ", not '" + fromString + "'!");
            }
            builder.startPosition(from);
        }
        if (json.has("to")) {
            ScrollingTextureData.Position to;
            if (!json.get("to").isJsonPrimitive() || !json.getAsJsonPrimitive("to").isString()) {
                throw new JsonParseException("Property 'to' must be a string!");
            }
            String toString = json.get("to").getAsString();
            try {
                to = ScrollingTextureData.Position.valueOf(toString.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new JsonParseException("Property 'to' must be one of " + Arrays.toString((Object[])ScrollingTextureData.Position.values()).toLowerCase(Locale.ROOT) + ", not '" + toString + "'!");
            }
            builder.endPosition(to);
        }
        if (json.has("frame_time")) {
            if (!json.get("frame_time").isJsonPrimitive() || !json.getAsJsonPrimitive("frame_time").isNumber()) {
                throw new JsonParseException("Property 'frame_time' must be an integer!");
            }
            int frameTime = json.get("frame_time").getAsNumber().intValue();
            if (frameTime <= 0) {
                throw new JsonParseException("Property 'frame_time' must have a value greater than 0!");
            }
            builder.frameTime(frameTime);
        }
        if (json.has("frame_width")) {
            if (!json.get("frame_width").isJsonPrimitive() || !json.getAsJsonPrimitive("frame_width").isNumber()) {
                throw new JsonParseException("Property 'frame_width' must be an integer!");
            }
            int frameWidth = json.get("frame_width").getAsNumber().intValue();
            if (frameWidth <= 0) {
                throw new JsonParseException("Property 'frame_width' must have a value greater than 0!");
            }
            builder.frameWidth(frameWidth);
        }
        if (json.has("frame_height")) {
            if (!json.get("frame_height").isJsonPrimitive() || !json.getAsJsonPrimitive("frame_height").isNumber()) {
                throw new JsonParseException("Property 'frame_height' must be an integer!");
            }
            int frameHeight = json.get("frame_height").getAsNumber().intValue();
            if (frameHeight <= 0) {
                throw new JsonParseException("Property 'frame_height' must have a value greater than 0!");
            }
            builder.frameHeight(frameHeight);
        }
        if (json.has("loop_type")) {
            ScrollingTextureData.LoopType loopType;
            if (!json.get("loop_type").isJsonPrimitive() || !json.getAsJsonPrimitive("loop_type").isString()) {
                throw new JsonParseException("Property 'loop_type' must be a string!");
            }
            String loopTypeString = json.get("loop_type").getAsString();
            try {
                loopType = ScrollingTextureData.LoopType.valueOf(loopTypeString.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new JsonParseException("Property 'loop_type' must be one of " + Arrays.toString((Object[])ScrollingTextureData.LoopType.values()).toLowerCase(Locale.ROOT) + ", not '" + loopTypeString + "'!");
            }
            builder.loopType(loopType);
        }
        if (json.has("loop_pause")) {
            if (!json.get("loop_pause").isJsonPrimitive() || !json.getAsJsonPrimitive("loop_pause").isNumber()) {
                throw new JsonParseException("Property 'loop_pause' must be an integer!");
            }
            int loopPause = json.get("loop_pause").getAsNumber().intValue();
            if (loopPause < 0) {
                throw new JsonParseException("Property 'loop_pause' must have a positive value!");
            }
            builder.loopPause(loopPause);
        }
        return (ScrollingTextureData)builder.build();
    }

    @Override
    public JsonObject serialize(ScrollingTextureData data) {
        JsonObject json = new JsonObject();
        if (data.getStartPosition() != ScrollingTextureData.Position.TOP_LEFT) {
            json.addProperty("from", data.getStartPosition().name().toLowerCase(Locale.ROOT));
        }
        if (data.getEndPosition() != ScrollingTextureData.Position.BOTTOM_LEFT) {
            json.addProperty("to", data.getEndPosition().name().toLowerCase(Locale.ROOT));
        }
        if (data.getFrameTime() != 10) {
            json.addProperty("frame_time", (Number)data.getFrameTime());
        }
        if (data.getFrameWidth() != 16) {
            json.addProperty("frame_width", (Number)data.getFrameWidth());
        }
        if (data.getFrameHeight() != 16) {
            json.addProperty("frame_height", (Number)data.getFrameHeight());
        }
        if (data.getLoopType() != ScrollingTextureData.LoopType.RESET) {
            json.addProperty("loop_type", data.getLoopType().name().toLowerCase(Locale.ROOT));
        }
        if (data.getLoopPause() != 0) {
            json.addProperty("loop_pause", (Number)data.getLoopPause());
        }
        return json;
    }

    @Override
    public Pair<Integer, Integer> getFrameSize(SpritePreparationContext context, ScrollingTextureData data) {
        if (context.getTextureWidth() < data.getFrameWidth() || context.getTextureHeight() < data.getFrameHeight()) {
            throw new RuntimeException("Frame size must be smaller than the texture size!");
        }
        return Pair.of(data.getFrameWidth(), data.getFrameHeight());
    }

    @Override
    public boolean allowRotation() {
        return false;
    }

    @Override
    public TextureAtlasSprite createSprite(SpriteCreationContext context, ScrollingTextureData data) {
        float percentage;
        int index;
        boolean reverse = data.getLoopType() == ScrollingTextureData.LoopType.REVERSE;
        int startX = data.getStartPosition() == ScrollingTextureData.Position.TOP_LEFT || data.getStartPosition() == ScrollingTextureData.Position.BOTTOM_LEFT ? 0 : context.getTextureWidth() - data.getFrameWidth();
        int startY = data.getStartPosition() == ScrollingTextureData.Position.TOP_LEFT || data.getStartPosition() == ScrollingTextureData.Position.TOP_RIGHT ? 0 : context.getTextureHeight() - data.getFrameHeight();
        int endX = data.getEndPosition() == ScrollingTextureData.Position.TOP_LEFT || data.getEndPosition() == ScrollingTextureData.Position.BOTTOM_LEFT ? 0 : context.getTextureWidth() - data.getFrameWidth();
        int endY = data.getEndPosition() == ScrollingTextureData.Position.TOP_LEFT || data.getEndPosition() == ScrollingTextureData.Position.TOP_RIGHT ? 0 : context.getTextureHeight() - data.getFrameHeight();
        int stepCount = Math.max(Math.abs(endX - startX), Math.abs(endY - startY)) + 1;
        int frameCount = reverse ? Math.max((stepCount - 1) * 2, 1) : stepCount;
        int[] xPositions = new int[frameCount];
        int[] yPositions = new int[frameCount];
        int[] frameTimes = new int[frameCount];
        for (index = 0; index < stepCount; ++index) {
            percentage = stepCount > 1 ? (float)index / (float)(stepCount - 1) : 0.5f;
            xPositions[index] = Math.round((float)startX + (float)(endX - startX) * percentage);
            yPositions[index] = Math.round((float)startY + (float)(endY - startY) * percentage);
            frameTimes[index] = data.getFrameTime();
        }
        int n = stepCount - 1;
        frameTimes[n] = frameTimes[n] + data.getLoopPause();
        if (reverse) {
            for (index = 1; index < stepCount - 1; ++index) {
                percentage = 1.0f - (float)index / (float)(stepCount - 1);
                xPositions[index + stepCount - 1] = Math.round((float)startX + (float)(endX - startX) * percentage);
                yPositions[index + stepCount - 1] = Math.round((float)startY + (float)(endY - startY) * percentage);
                frameTimes[index + stepCount - 1] = data.getFrameTime();
            }
            frameTimes[0] = frameTimes[0] + data.getLoopPause();
        }
        return new ScrollingSprite(context.createOriginalSprite(), context.getTextureWidth(), context.getTextureHeight(), xPositions, yPositions, frameTimes, data);
    }

    private static class ScrollingSprite
    extends BaseTextureSprite {
        private final int[] xPositions;
        private final int[] yPositions;
        private final int[] frameTimes;
        private int frame;
        private int tickCounter;

        protected ScrollingSprite(TextureAtlasSprite original, int imageWidth, int imageHeight, int[] xPositions, int[] yPositions, int[] frameTimes, BaseTextureData data) {
            super(original, data);
            this.xPositions = xPositions;
            this.yPositions = yPositions;
            this.frameTimes = frameTimes;
            this.splitAnimationFrames(imageWidth, imageHeight);
        }

        public void func_110971_a(int inX, int inY, int originInX, int originInY, boolean rotatedIn) {
            super.func_110971_a(inX, inY, originInX, originInY, rotatedIn);
        }

        private void splitAnimationFrames(int imageWidth, int imageHeight) {
            int[] image = ((int[][])this.field_110976_a.get(0))[0];
            int mipmaps = ((int[][])this.field_110976_a.get(0)).length - 1;
            ArrayList<int[][]> frames = new ArrayList<int[][]>();
            for (int frame = 0; frame < this.xPositions.length; ++frame) {
                int[] frameData = new int[this.field_130223_c * this.field_130224_d];
                for (int row = 0; row < this.field_130224_d; ++row) {
                    int position = (this.yPositions[frame] + row) * imageWidth + this.xPositions[frame];
                    System.arraycopy(image, position, frameData, row * this.field_130223_c, this.field_130223_c);
                }
                int[][] frameMipmaps = new int[mipmaps + 1][];
                frameMipmaps[0] = frameData;
                frames.add(frameMipmaps);
            }
            this.field_110976_a = frames;
            if (mipmaps > 0) {
                this.func_147963_d(mipmaps);
            }
        }

        public void func_94219_l() {
            if (++this.tickCounter >= this.frameTimes[this.frame]) {
                this.frame = (this.frame + 1) % this.xPositions.length;
                this.tickCounter = 0;
                this.uploadFrame(this.frame);
            }
        }

        private void uploadFrame(int frame) {
            TextureUtil.func_147955_a((int[][])((int[][])this.field_110976_a.get(frame)), (int)this.field_130223_c, (int)this.field_130224_d, (int)this.field_110975_c, (int)this.field_110974_d, (boolean)false, (boolean)false);
        }

        public boolean func_130098_m() {
            return true;
        }
    }
}

