/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.modifiers.block;

import com.mojang.blaze3d.vertex.PoseStack;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.stream.IntStream;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedOverrides;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.Nullable;

public class BlockModelModifierBakedModel
implements BakedModel {
    private static final Function<SimpleBakedModel, ChunkRenderTypeSet> getBlockRenderTypes;
    private static final Function<SimpleBakedModel, List<RenderType>> getItemRenderTypes;
    private static final Function<SimpleBakedModel, List<RenderType>> getFabulousItemRenderTypes;
    private static final ModelProperty<ModelData[]> DATA_PROPERTY;
    private final BakedModel original;
    private final List<BakedModel> models;
    private final boolean hasNonSimpleModels;
    private final List<BakedModel> nonSimpleModels;
    private final List<BakedQuad> quads;
    private final List<BakedQuad>[] culledQuads = new List[6];
    private final ChunkRenderTypeSet chunkRenderTypes;
    private final List<RenderType> itemRenderTypes;
    private final List<RenderType> fabulousItemRenderTypes;
    private final boolean addNativeBlockRenderTypes;
    private final boolean addNativeItemRenderTypes;
    private final boolean addNativeFabulousItemRenderTypes;

    public BlockModelModifierBakedModel(BakedModel original, List<BakedModel> models) {
        this.original = original;
        this.models = new ArrayList<BakedModel>(models.size() + 1);
        this.models.add(original);
        this.models.addAll(models);
        ArrayList<BakedModel> nonSimpleModels = new ArrayList<BakedModel>();
        ArrayList quads = new ArrayList();
        List[] culledQuads = (List[])IntStream.range(0, 6).mapToObj(i -> new ArrayList()).toArray(List[]::new);
        ChunkRenderTypeSet chunkRenderTypes = ChunkRenderTypeSet.none();
        HashSet<RenderType> itemRenderTypes = new HashSet<RenderType>();
        HashSet<RenderType> fabulousItemRenderTypes = new HashSet<RenderType>();
        boolean addNativeBlockRenderTypes = false;
        boolean addNativeItemRenderTypes = false;
        boolean addNativeFabulousItemRenderTypes = false;
        RandomSource random = RandomSource.create();
        for (BakedModel model : this.models) {
            if (!model.getClass().equals(SimpleBakedModel.class)) {
                nonSimpleModels.add(model);
                continue;
            }
            quads.addAll(model.getQuads(null, null, random));
            for (Direction side : Direction.values()) {
                culledQuads[side.ordinal()].addAll(model.getQuads(null, side, random));
            }
            ChunkRenderTypeSet modelChunkRenderTypes = getBlockRenderTypes.apply((SimpleBakedModel)model);
            if (modelChunkRenderTypes == null) {
                addNativeBlockRenderTypes = true;
            } else {
                chunkRenderTypes = ChunkRenderTypeSet.union((ChunkRenderTypeSet[])new ChunkRenderTypeSet[]{modelChunkRenderTypes, chunkRenderTypes});
            }
            List<RenderType> modelItemRenderTypes = getItemRenderTypes.apply((SimpleBakedModel)model);
            if (modelItemRenderTypes == null) {
                addNativeItemRenderTypes = true;
            } else {
                itemRenderTypes.addAll(modelItemRenderTypes);
            }
            List<RenderType> modelFabulousItemRenderTypes = getFabulousItemRenderTypes.apply((SimpleBakedModel)model);
            if (modelFabulousItemRenderTypes == null) {
                addNativeFabulousItemRenderTypes = true;
                continue;
            }
            fabulousItemRenderTypes.addAll(modelFabulousItemRenderTypes);
        }
        this.hasNonSimpleModels = !nonSimpleModels.isEmpty();
        this.nonSimpleModels = nonSimpleModels.isEmpty() ? null : List.copyOf(nonSimpleModels);
        this.quads = List.copyOf(quads);
        for (Direction side : Direction.values()) {
            this.culledQuads[side.ordinal()] = List.copyOf(culledQuads[side.ordinal()]);
        }
        this.chunkRenderTypes = chunkRenderTypes;
        this.itemRenderTypes = List.copyOf(itemRenderTypes);
        this.fabulousItemRenderTypes = List.copyOf(fabulousItemRenderTypes);
        this.addNativeBlockRenderTypes = addNativeBlockRenderTypes;
        this.addNativeItemRenderTypes = addNativeItemRenderTypes;
        this.addNativeFabulousItemRenderTypes = addNativeFabulousItemRenderTypes;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource random, ModelData data, @Nullable RenderType renderType) {
        if (!this.hasNonSimpleModels) {
            return side == null ? this.quads : this.culledQuads[side.ordinal()];
        }
        ModelData[] arr = (ModelData[])data.get(DATA_PROPERTY);
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(side == null ? this.quads : this.culledQuads[side.ordinal()]);
        for (int i = 0; i < this.nonSimpleModels.size(); ++i) {
            quads.addAll(this.nonSimpleModels.get(i).getQuads(state, side, random, arr == null || arr[i] == null ? ModelData.EMPTY : arr[i], renderType));
        }
        return quads;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource random) {
        if (!this.hasNonSimpleModels) {
            return side == null ? this.quads : this.culledQuads[side.ordinal()];
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(side == null ? this.quads : this.culledQuads[side.ordinal()]);
        for (BakedModel model : this.nonSimpleModels) {
            quads.addAll(model.getQuads(state, side, random));
        }
        return quads;
    }

    public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource random, ModelData data) {
        ChunkRenderTypeSet renderTypes = this.chunkRenderTypes;
        if (this.addNativeBlockRenderTypes) {
            renderTypes = ChunkRenderTypeSet.union((ChunkRenderTypeSet[])new ChunkRenderTypeSet[]{renderTypes, super.getRenderTypes(state, random, data)});
        }
        if (this.hasNonSimpleModels) {
            for (BakedModel model : this.nonSimpleModels) {
                renderTypes = ChunkRenderTypeSet.union((ChunkRenderTypeSet[])new ChunkRenderTypeSet[]{renderTypes, model.getRenderTypes(state, random, data)});
            }
        }
        return renderTypes;
    }

    public List<RenderType> getRenderTypes(ItemStack stack, boolean fabulous) {
        if ((fabulous ? !this.addNativeFabulousItemRenderTypes : !this.addNativeItemRenderTypes) && !this.hasNonSimpleModels) {
            return fabulous ? this.fabulousItemRenderTypes : this.itemRenderTypes;
        }
        HashSet<RenderType> renderTypes = new HashSet<RenderType>(5);
        renderTypes.addAll(this.itemRenderTypes);
        if (fabulous ? this.addNativeFabulousItemRenderTypes : this.addNativeItemRenderTypes) {
            renderTypes.addAll(super.getRenderTypes(stack, true));
        }
        if (this.hasNonSimpleModels) {
            for (BakedModel model : this.nonSimpleModels) {
                renderTypes.addAll(model.getRenderTypes(stack, true));
            }
        }
        return new ArrayList<RenderType>(renderTypes);
    }

    public List<BakedModel> getRenderPasses(ItemStack stack, boolean fabulous) {
        if (!this.hasNonSimpleModels) {
            return this.models;
        }
        ArrayList<BakedModel> passes = new ArrayList<BakedModel>(this.models.size());
        for (BakedModel model : this.models) {
            passes.addAll(model.getRenderPasses(stack, fabulous));
        }
        return passes;
    }

    public ModelData getModelData(BlockAndTintGetter level, BlockPos pos, BlockState state, ModelData data) {
        if (!this.hasNonSimpleModels) {
            return data;
        }
        ModelData[] arr = new ModelData[this.nonSimpleModels.size()];
        for (int i = 0; i < this.nonSimpleModels.size(); ++i) {
            arr[i] = this.nonSimpleModels.get(i).getModelData(level, pos, state, data);
        }
        return ModelData.builder().with(DATA_PROPERTY, (Object)arr).build();
    }

    public ItemTransforms getTransforms() {
        return this.original.getTransforms();
    }

    public boolean useAmbientOcclusion() {
        return this.original.useAmbientOcclusion();
    }

    public boolean isGui3d() {
        return this.original.isGui3d();
    }

    public boolean usesBlockLight() {
        return this.original.usesBlockLight();
    }

    public boolean isCustomRenderer() {
        return this.original.isCustomRenderer();
    }

    public TextureAtlasSprite getParticleIcon() {
        return this.original.getParticleIcon();
    }

    public BakedOverrides overrides() {
        return this.original.overrides();
    }

    public boolean useAmbientOcclusion(BlockState state) {
        return this.original.useAmbientOcclusion(state);
    }

    public boolean useAmbientOcclusion(BlockState state, RenderType renderType) {
        return this.original.useAmbientOcclusion(state, renderType);
    }

    public BakedModel applyTransform(ItemDisplayContext transformType, PoseStack poseStack, boolean applyLeftHandTransform) {
        return this.original.applyTransform(transformType, poseStack, applyLeftHandTransform);
    }

    public TextureAtlasSprite getParticleIcon(ModelData data) {
        return this.original.getParticleIcon(data);
    }

    static {
        try {
            Field blockRenderTypes = SimpleBakedModel.class.getDeclaredField("blockRenderTypes");
            blockRenderTypes.setAccessible(true);
            getBlockRenderTypes = model -> {
                try {
                    return (ChunkRenderTypeSet)blockRenderTypes.get(model);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            };
            Field itemRenderTypes = SimpleBakedModel.class.getDeclaredField("itemRenderTypes");
            itemRenderTypes.setAccessible(true);
            getItemRenderTypes = model -> {
                try {
                    return (List)itemRenderTypes.get(model);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            };
            Field fabulousItemRenderTypes = SimpleBakedModel.class.getDeclaredField("fabulousItemRenderTypes");
            fabulousItemRenderTypes.setAccessible(true);
            getFabulousItemRenderTypes = model -> {
                try {
                    return (List)fabulousItemRenderTypes.get(model);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            };
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Fusion failed to make vanilla model render types accessible!", e);
        }
        DATA_PROPERTY = new ModelProperty();
    }
}

