/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.modifiers.block;

import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.model.MutableQuad;
import com.supermartijn642.fusion.model.WrappedBakedModel;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PaneCullingBakedModel
extends WrappedBakedModel {
    private static final ModelProperty<Pair<BlockState, BlockState>> NEIGHBOR_PROPERTY = new ModelProperty();
    private static final BooleanProperty[] SIDE_PROPERTIES = new BooleanProperty[]{null, null, BlockStateProperties.NORTH, BlockStateProperties.SOUTH, BlockStateProperties.WEST, BlockStateProperties.EAST};
    private final MutableQuad helperMutableQuad = new MutableQuad();

    public PaneCullingBakedModel(BakedModel original) {
        super(original);
    }

    @Override
    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction cullDirection, @NotNull RandomSource random, @NotNull ModelData data, @Nullable RenderType renderType) {
        BlockState stateBelow;
        if (state == null) {
            return super.getQuads(null, cullDirection, random, data, renderType);
        }
        if (!(state.hasProperty((Property)BlockStateProperties.NORTH) || state.hasProperty((Property)BlockStateProperties.SOUTH) || state.hasProperty((Property)BlockStateProperties.WEST) || state.hasProperty((Property)BlockStateProperties.EAST))) {
            return super.getQuads(state, cullDirection, random, data, renderType);
        }
        Pair neighbors = (Pair)data.get(NEIGHBOR_PROPERTY);
        if (neighbors == null) {
            return super.getQuads(state, cullDirection, random, data, renderType);
        }
        BlockState stateAbove = (BlockState)neighbors.left();
        if (stateAbove.getBlock() != state.getBlock()) {
            stateAbove = null;
        }
        if ((stateBelow = (BlockState)neighbors.right()).getBlock() != state.getBlock()) {
            stateBelow = null;
        }
        if (stateAbove == null && stateBelow == null) {
            return super.getQuads(state, cullDirection, random, data, renderType);
        }
        List<BakedQuad> quads = super.getQuads(state, cullDirection, random, data, renderType);
        ArrayList<BakedQuad> culledQuads = new ArrayList<BakedQuad>(quads.size());
        for (BakedQuad quad : quads) {
            if (!this.filterQuad(quad, stateAbove, stateBelow)) continue;
            culledQuads.add(quad);
        }
        return culledQuads;
    }

    @Override
    public ModelData getModelData(BlockAndTintGetter level, BlockPos pos, BlockState state, ModelData data) {
        return super.getModelData(level, pos, state, data).derive().with(NEIGHBOR_PROPERTY, Pair.of(level.getBlockState(pos.above()).getAppearance(level, pos.above(), Direction.DOWN, state, pos), level.getBlockState(pos.below()).getAppearance(level, pos.below(), Direction.UP, state, pos))).build();
    }

    private boolean filterQuad(BakedQuad bakedQuad, BlockState stateAbove, BlockState stateBelow) {
        Direction quadDirection = bakedQuad.getDirection();
        if (quadDirection != Direction.UP && quadDirection != Direction.DOWN) {
            return true;
        }
        MutableQuad quad = this.helperMutableQuad;
        quad.fillFromBakedQuad(bakedQuad);
        float centerX = (quad.x(0) + quad.x(1) + quad.x(2) + quad.x(3)) / 4.0f;
        float centerZ = (quad.z(0) + quad.z(1) + quad.z(2) + quad.z(3)) / 4.0f;
        double quadDistance = Math.sqrt(((double)centerX - 0.5) * ((double)centerX - 0.5) + ((double)centerZ - 0.5) * ((double)centerZ - 0.5));
        if (quadDistance < 0.1) {
            return quadDirection == Direction.UP ? stateAbove == null : stateBelow == null;
        }
        Direction partSide = Direction.getApproximateNearest((double)((double)centerX - 0.5), (double)0.0, (double)((double)centerZ - 0.5));
        return quadDirection == Direction.UP ? stateAbove == null || !((Boolean)stateAbove.getValue((Property)SIDE_PROPERTIES[partSide.ordinal()])).booleanValue() : stateBelow == null || (Boolean)stateBelow.getValue((Property)SIDE_PROPERTIES[partSide.ordinal()]) == false;
    }
}

