/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.api.provider;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.fusion.api.model.modifier.item.ItemPredicate;
import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.model.modifiers.item.predicates.AndItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.ItemPredicateRegistry;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;

public abstract class FusionItemModelModifierProvider
implements DataProvider {
    private final Map<ResourceLocation, ModifierBuilder> modifiers = new HashMap<ResourceLocation, ModifierBuilder>();
    private final String modName;
    private final DataGenerator generator;

    public FusionItemModelModifierProvider(String modid, DataGenerator generator) {
        this.modName = ModList.get().getModContainerById(modid).map(ModContainer::getModInfo).map(IModInfo::getDisplayName).orElse(modid);
        this.generator = generator;
    }

    public final void m_213708_(CachedOutput cache) throws IOException {
        this.generate();
        ArrayList tasks = new ArrayList();
        Path output = this.generator.m_123916_();
        for (Map.Entry<ResourceLocation, ModifierBuilder> entry : this.modifiers.entrySet()) {
            ResourceLocation location = entry.getKey();
            JsonObject json = this.toJson(entry.getValue());
            String extension = location.m_135815_().endsWith(".json") ? "" : ".json";
            Path path = Path.of("assets", location.m_135827_(), "fusion/model_modifiers/items", location.m_135815_() + extension);
            DataProvider.m_236072_((CachedOutput)cache, (JsonElement)json, (Path)output.resolve(path));
        }
    }

    private JsonObject toJson(ModifierBuilder modifier) {
        JsonObject json = new JsonObject();
        if (modifier.targets.isEmpty()) {
            throw new IllegalArgumentException("Modifier '" + modifier.location + "' must have at least one target!");
        }
        JsonArray targets = new JsonArray();
        modifier.targets.stream().sorted().map(ResourceLocation::toString).forEach(arg_0 -> ((JsonArray)targets).add(arg_0));
        json.add("targets", (JsonElement)targets);
        if (modifier.defaultModel != null) {
            json.addProperty("default_model", modifier.defaultModel.toString());
        }
        JsonArray models = new JsonArray();
        for (Pair<ResourceLocation, ItemPredicate> pair : modifier.conditionalModels) {
            JsonObject model = new JsonObject();
            model.addProperty("model", pair.left().toString());
            JsonArray conditions = new JsonArray();
            List<ItemPredicate> predicates = pair.right() instanceof AndItemPredicate ? ((AndItemPredicate)pair.right()).getPredicates() : List.of(pair.right());
            predicates.stream().map(ItemPredicateRegistry::serializeItemPredicate).forEach(arg_0 -> ((JsonArray)conditions).add(arg_0));
            model.add("conditions", (JsonElement)conditions);
            models.add((JsonElement)model);
        }
        json.add("models", (JsonElement)models);
        return json;
    }

    protected abstract void generate();

    public final ModifierBuilder modifier(ResourceLocation location) {
        return this.modifiers.computeIfAbsent(location, ModifierBuilder::new);
    }

    public String m_6055_() {
        return "Fusion Item Model Modifier Provider: " + this.modName;
    }

    public static final class ModifierBuilder {
        private final ResourceLocation location;
        private final Set<ResourceLocation> targets = new HashSet<ResourceLocation>();
        private final List<Pair<ResourceLocation, ItemPredicate>> conditionalModels = new ArrayList<Pair<ResourceLocation, ItemPredicate>>();
        private ResourceLocation defaultModel = null;

        private ModifierBuilder(ResourceLocation location) {
            this.location = location;
        }

        public ModifierBuilder target(ResourceLocation item) {
            this.targets.add(item);
            return this;
        }

        public ModifierBuilder target(Item item) {
            return this.target(Registry.f_122827_.m_7981_((Object)item));
        }

        public ModifierBuilder target(Block block) {
            Item item = Item.m_41439_((Block)block);
            if (item == null || block != Blocks.f_50016_ && item == Items.f_41852_) {
                throw new IllegalArgumentException("Block '" + block + "' does not have an item!");
            }
            return this.target(item);
        }

        public ModifierBuilder defaultModel(ResourceLocation location) {
            this.defaultModel = location;
            return this;
        }

        public ModifierBuilder conditionalModel(ResourceLocation model, ItemPredicate condition) {
            this.conditionalModels.add(Pair.of(model, condition));
            return this;
        }
    }
}

