/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model;

import com.mojang.datafixers.util.Pair;
import com.supermartijn642.fusion.api.model.DefaultModelTypes;
import com.supermartijn642.fusion.api.model.GatherTexturesContext;
import com.supermartijn642.fusion.api.model.ModelInstance;
import com.supermartijn642.fusion.api.model.SpriteIdentifier;
import com.supermartijn642.fusion.extensions.BlockModelExtension;
import com.supermartijn642.fusion.model.ModelBakingContextImpl;
import com.supermartijn642.fusion.model.ModelInstanceImpl;
import com.supermartijn642.fusion.model.ModelTypeRegistryImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class FusionBlockModel
extends BlockModel {
    public static final UnbakedModel DUMMY_MODEL = new UnbakedModel(){

        public Collection<ResourceLocation> m_7970_() {
            return Collections.emptyList();
        }

        public Collection<Material> m_5500_(Function<ResourceLocation, UnbakedModel> function, Set<Pair<String, String>> set) {
            return Collections.emptyList();
        }

        @Nullable
        public BakedModel m_7611_(ModelBakery modelBakery, Function<Material, TextureAtlasSprite> function, ModelState modelState, ResourceLocation resourceLocation) {
            return null;
        }
    };
    private final ModelInstance<?> model;
    private final BlockModel vanillaModel;
    private Collection<ResourceLocation> dependencies;

    public FusionBlockModel(ModelInstance<?> model) {
        super(null, Collections.emptyList(), Collections.emptyMap(), false, null, ItemTransforms.f_111786_, Collections.emptyList());
        this.model = model;
        this.vanillaModel = model.getAsVanillaModel();
    }

    public BakedModel m_111449_(ModelBakery bakery, BlockModel someOtherModel, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ResourceLocation modelLocation, boolean gui3d) {
        ModelBakingContextImpl context = new ModelBakingContextImpl(bakery, spriteGetter, modelTransform, modelLocation);
        return this.model.bake(context);
    }

    public Collection<ResourceLocation> m_7970_() {
        if (this.dependencies != null) {
            return this.dependencies;
        }
        try {
            this.dependencies = this.model.getModelDependencies();
        }
        catch (Exception e) {
            throw new RuntimeException("Encountered an exception whilst requesting dependencies from model type '" + ModelTypeRegistryImpl.getIdentifier(this.model.getModelType()) + "' for  '" + this.f_111416_ + "'!", e);
        }
        if (this.dependencies == null) {
            throw new RuntimeException("Model type '" + ModelTypeRegistryImpl.getIdentifier(this.model.getModelType()) + "' returned null when requesting dependencies '" + this.f_111416_ + "'!");
        }
        return this.dependencies;
    }

    public Collection<Material> m_5500_(Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> errors) {
        GatherTexturesContext context = identifier -> FusionBlockModel.getModelInstance((UnbakedModel)modelGetter.apply(identifier));
        ArrayList materials = null;
        try {
            Collection<SpriteIdentifier> pairs = this.model.getTextureDependencies(context);
            if (pairs != null) {
                materials = (ArrayList)((Object)pairs.stream().map(SpriteIdentifier::toMaterial).collect(Collectors.toSet()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Encountered an exception whilst requesting texture dependencies from model type '" + ModelTypeRegistryImpl.getIdentifier(this.model.getModelType()) + "' for  '" + this.f_111416_ + "'!", e);
        }
        if (materials == null) {
            throw new RuntimeException("Model type '" + ModelTypeRegistryImpl.getIdentifier(this.model.getModelType()) + "' returned null when requesting texture dependencies for '" + this.f_111416_ + "'!");
        }
        Collection<ResourceLocation> dependencies = this.m_7970_();
        if (!dependencies.isEmpty()) {
            materials = new ArrayList(materials);
            dependencies.forEach(location -> {
                UnbakedModel model = (UnbakedModel)modelGetter.apply((ResourceLocation)location);
                if (model == null) {
                    BlockModel.f_111420_.warn("Could not find dependency model '{}' while loading model '{}'", location, (Object)this);
                }
            });
        }
        return materials;
    }

    public boolean hasVanillaModel() {
        return this.vanillaModel != null;
    }

    public BlockModel getVanillaModel() {
        return this.vanillaModel;
    }

    public static ModelInstance<?> getModelInstance(UnbakedModel model) {
        if (model instanceof FusionBlockModel) {
            return ((FusionBlockModel)model).model;
        }
        if (model instanceof BlockModel) {
            ModelInstance<?> modelInstance = ((BlockModelExtension)model).getFusionModel();
            if (modelInstance == null) {
                modelInstance = new ModelInstanceImpl<BlockModel>(DefaultModelTypes.VANILLA, (BlockModel)model);
                ((BlockModelExtension)model).setFusionModel(modelInstance);
            }
            return modelInstance;
        }
        return new ModelInstanceImpl<UnbakedModel>(DefaultModelTypes.UNKNOWN, model);
    }
}

