/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.connecting;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.api.predicate.ConnectionDirection;
import com.supermartijn642.fusion.api.predicate.ConnectionPredicate;
import com.supermartijn642.fusion.api.texture.DefaultTextureTypes;
import com.supermartijn642.fusion.api.texture.TextureType;
import com.supermartijn642.fusion.api.texture.data.ConnectingTextureLayout;
import com.supermartijn642.fusion.model.ItemBakedModel;
import com.supermartijn642.fusion.model.OriginalRenderTypeHelper;
import com.supermartijn642.fusion.model.types.base.CustomRenderTypeBakedModel;
import com.supermartijn642.fusion.model.types.connecting.ConnectingModelQuad;
import com.supermartijn642.fusion.model.types.connecting.OrientedMutableQuad;
import com.supermartijn642.fusion.model.types.connecting.SurroundingBlockCache;
import com.supermartijn642.fusion.texture.types.connecting.ConnectingTextureSprite;
import com.supermartijn642.fusion.texture.types.connecting.TextureConnections;
import com.supermartijn642.fusion.texture.types.connecting.layouts.ConnectingTextureLayoutHandler;
import com.supermartijn642.fusion.texture.types.continuous.ContinuousTextureSprite;
import com.supermartijn642.fusion.texture.types.continuous.ContinuousTextureType;
import com.supermartijn642.fusion.texture.types.random.RandomTextureSprite;
import com.supermartijn642.fusion.texture.types.random.RandomTextureType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;

public class ConnectingBakedModel
implements IBakedModel,
CustomRenderTypeBakedModel {
    public static final ModelProperty<SurroundingBlockCache> BLOCK_CACHE_PROPERTY = new ModelProperty();
    public static final ModelProperty<BlockPos> POSITION_PROPERTY = new ModelProperty();
    private static final int VERTEX_SIZE;
    private static final int VERTEX_UV_OFFSET;
    private static final int VERTEX_POSITION_OFFSET;
    private static final int[][] DEFAULT_TEXTURE_ROTATIONS_UP;
    private static final int[][] DEFAULT_TEXTURE_ROTATIONS_RIGHT;
    private final List<TaggedBakedQuad>[] completeBlockMesh;
    private final List<BakedQuad> completeItemMesh;
    private final Map<RenderType, List<TaggedBakedQuad>[]> blockMesh;
    private final Map<RenderType, List<BakedQuad>> itemMesh;
    private final List<RenderType> blockRenderTypes;
    private final List<RenderType> itemRenderTypes;
    private final List<RenderType> itemRenderTypesFabulous;
    private final boolean shouldCheckOriginalItemRenderTypes;
    private final boolean shouldCheckOriginalBlockRenderTypes;
    private final ItemBakedModel itemModel;
    private final List<Pair<IBakedModel, RenderType>> itemPasses;
    private final List<Pair<IBakedModel, RenderType>> itemPassesFabulous;
    private final List<QuadPredicates> predicates;
    private final List<TextureAtlasSprite> sprites;
    private final boolean hasSpecialQuads;
    private final boolean hasAmbientOcclusion;
    private final boolean isGui3d;
    private final boolean usesBlockLight;
    private final TextureAtlasSprite particleIcon;
    private final ItemCameraTransforms transforms;
    private final ItemOverrideList overrides;

    private static float[] getUV(BakedQuad quad, int vertexIndex) {
        int offset = vertexIndex * VERTEX_SIZE + VERTEX_UV_OFFSET;
        return new float[]{Float.intBitsToFloat(quad.func_178209_a()[offset]), Float.intBitsToFloat(quad.func_178209_a()[offset + 1])};
    }

    private static float[] getPosition(BakedQuad quad, int vertexIndex) {
        int offset = vertexIndex * VERTEX_SIZE + VERTEX_POSITION_OFFSET;
        return new float[]{Float.intBitsToFloat(quad.func_178209_a()[offset]), Float.intBitsToFloat(quad.func_178209_a()[offset + 1]), Float.intBitsToFloat(quad.func_178209_a()[offset + 2])};
    }

    public ConnectingBakedModel(List<ConnectingModelQuad> quads, boolean hasAmbientOcclusion, boolean isGui3d, boolean usesBlockLight, TextureAtlasSprite particleIcon, ItemCameraTransforms transforms, ItemOverrideList overrides) {
        this.hasAmbientOcclusion = hasAmbientOcclusion;
        this.isGui3d = isGui3d;
        this.usesBlockLight = usesBlockLight;
        this.particleIcon = particleIcon;
        this.transforms = transforms;
        this.overrides = overrides;
        HashMap<RenderType, List[]> blockMesh = new HashMap<RenderType, List[]>();
        HashSet<RenderType> blockRenderTypes = new HashSet<RenderType>();
        HashMap itemMesh = new HashMap();
        HashSet<RenderType> itemRenderTypes = new HashSet<RenderType>();
        HashSet<RenderType> itemRenderTypesFabulous = new HashSet<RenderType>();
        HashMap<QuadPredicates, Integer> predicates = new HashMap<QuadPredicates, Integer>();
        HashMap<TextureAtlasSprite, Integer> sprites = new HashMap<TextureAtlasSprite, Integer>();
        boolean hasSpecialQuads = false;
        OrientedMutableQuad mutableQuad = new OrientedMutableQuad();
        for (ConnectingModelQuad quad : quads) {
            TextureType<?> textureType = quad.textureType();
            int spriteIndex = -1;
            int predicateIndex = -1;
            int auxiliaryQuadCount = 0;
            if (quad.hasConnectingTexture()) {
                Direction direction = quad.bakedQuad().func_178210_d();
                TextureOrientation orientation = ConnectingBakedModel.findOrientation(quad.bakedQuad());
                ConnectionPredicate predicate = quad.connectionPredicate();
                auxiliaryQuadCount = ConnectingTextureLayoutHandler.get(quad.getLayout()).getAuxiliaryQuadCount();
                predicateIndex = predicates.computeIfAbsent(new QuadPredicates(direction, orientation, predicate), o -> predicates.size());
                spriteIndex = sprites.computeIfAbsent(quad.bakedQuad().func_187508_a(), o -> sprites.size());
            }
            if (quad.textureType() == DefaultTextureTypes.RANDOM || quad.textureType() == DefaultTextureTypes.CONTINUOUS) {
                spriteIndex = sprites.computeIfAbsent(quad.bakedQuad().func_187508_a(), o -> sprites.size());
                hasSpecialQuads = true;
            }
            for (int quadIndex = 0; quadIndex < auxiliaryQuadCount + 1; ++quadIndex) {
                mutableQuad.fillFromBakedQuad(quad.bakedQuad());
                mutableQuad.emissive(quad.emissive());
                if (quad.lightEmission() != null) {
                    for (int i = 0; i < 4; ++i) {
                        int sky = Math.max(quad.lightEmission(), LightTexture.func_228454_b_((int)mutableQuad.lightmap(i)));
                        int block = Math.max(quad.lightEmission(), LightTexture.func_228450_a_((int)mutableQuad.lightmap(i)));
                        mutableQuad.lightmap(i, LightTexture.func_228451_a_((int)sky, (int)block));
                    }
                }
                TaggedBakedQuad finishedQuad = new TaggedBakedQuad(mutableQuad.toBakedQuad(), textureType, spriteIndex, predicateIndex, quadIndex);
                RenderType renderType = FusionClient.getRenderTypeMaterial(quad.renderType());
                blockRenderTypes.add(renderType);
                int cullIndex = ConnectingBakedModel.cullIndex(quad.cullDirection());
                List[] mesh = blockMesh.computeIfAbsent(renderType, r -> new List[7]);
                if (mesh[cullIndex] == null) {
                    mesh[cullIndex] = new ArrayList();
                }
                mesh[cullIndex].add(finishedQuad);
                RenderType itemRenderType = renderType == FusionClient.USE_ORIGINAL_RENDER_TYPE_MARKER ? FusionClient.USE_ORIGINAL_RENDER_TYPE_MARKER : (renderType == RenderType.func_228645_f_() ? Atlases.func_239280_i_() : Atlases.func_228783_h_());
                itemRenderTypes.add(itemRenderType);
                ArrayList<BakedQuad> itemQuads = (ArrayList<BakedQuad>)itemMesh.get(renderType);
                if (itemQuads == null) {
                    itemQuads = new ArrayList<BakedQuad>();
                    itemMesh.put(itemRenderType, itemQuads);
                    RenderType fabulousRenderType = renderType == FusionClient.USE_ORIGINAL_RENDER_TYPE_MARKER ? FusionClient.USE_ORIGINAL_RENDER_TYPE_MARKER : (renderType == RenderType.func_228645_f_() ? Atlases.func_228785_j_() : Atlases.func_228783_h_());
                    itemRenderTypesFabulous.add(fabulousRenderType);
                    itemMesh.put(fabulousRenderType, itemQuads);
                }
                if (quad.hasConnectingTexture()) {
                    mutableQuad.set(TextureOrientation.NORMAL_0.vertexIndexPermutation);
                    boolean keepQuad = ConnectingTextureLayoutHandler.get(quad.getLayout()).processItemQuad(quadIndex, mutableQuad, (ConnectingTextureSprite)quad.bakedQuad().func_187508_a());
                    mutableQuad.resetPermutation();
                    if (!keepQuad) continue;
                }
                itemQuads.add(mutableQuad.toBakedQuad());
            }
        }
        this.blockMesh = ImmutableMap.copyOf(blockMesh);
        this.blockRenderTypes = blockRenderTypes.stream().filter(r -> r != FusionClient.USE_ORIGINAL_RENDER_TYPE_MARKER).collect(Collectors.toList());
        this.shouldCheckOriginalBlockRenderTypes = blockRenderTypes.contains(FusionClient.USE_ORIGINAL_RENDER_TYPE_MARKER);
        this.itemMesh = ImmutableMap.copyOf(itemMesh);
        this.itemRenderTypes = itemRenderTypes.stream().filter(r -> r != FusionClient.USE_ORIGINAL_RENDER_TYPE_MARKER).collect(Collectors.toList());
        this.itemRenderTypesFabulous = itemRenderTypesFabulous.stream().filter(r -> r != FusionClient.USE_ORIGINAL_RENDER_TYPE_MARKER).collect(Collectors.toList());
        this.shouldCheckOriginalItemRenderTypes = itemRenderTypes.contains(FusionClient.USE_ORIGINAL_RENDER_TYPE_MARKER);
        this.predicates = predicates.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).collect(Collectors.toList());
        this.sprites = sprites.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).collect(Collectors.toList());
        this.hasSpecialQuads = hasSpecialQuads;
        this.completeBlockMesh = new List[7];
        for (int i = 0; i < 7; ++i) {
            int cullIndex = i;
            this.completeBlockMesh[i] = this.blockMesh.values().stream().map(arr -> arr[cullIndex]).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
        }
        this.completeItemMesh = itemRenderTypes.stream().map(this.itemMesh::get).flatMap(Collection::stream).collect(Collectors.toList());
        this.itemModel = new ItemBakedModel(this){

            @Override
            protected List<BakedQuad> getQuads(ItemStack stack, boolean fabulous, @Nonnull Random random, @Nonnull IModelData data, @Nullable RenderType renderType) {
                List additionalQuads;
                if (renderType == null) {
                    return ConnectingBakedModel.this.completeItemMesh;
                }
                ArrayList quads = (ArrayList)ConnectingBakedModel.this.itemMesh.get(renderType);
                if (ConnectingBakedModel.this.shouldCheckOriginalItemRenderTypes && RenderTypeLookup.func_239219_a_((ItemStack)stack, (boolean)fabulous) == renderType && (additionalQuads = (List)ConnectingBakedModel.this.itemMesh.get(FusionClient.USE_ORIGINAL_RENDER_TYPE_MARKER)) != null) {
                    if (quads == null) {
                        quads = additionalQuads;
                    } else {
                        ArrayList combined = new ArrayList(quads.size() + additionalQuads.size());
                        combined.addAll(quads);
                        combined.addAll(additionalQuads);
                        quads = combined;
                    }
                }
                return quads == null ? Collections.emptyList() : quads;
            }
        };
        this.itemPasses = this.itemRenderTypes.stream().map(r -> Pair.of((Object)this.itemModel, (Object)r)).collect(Collectors.toList());
        this.itemPassesFabulous = this.itemRenderTypesFabulous.stream().map(r -> Pair.of((Object)this.itemModel, (Object)r)).collect(Collectors.toList());
    }

    private static TextureOrientation findOrientation(BakedQuad quad) {
        double angle1to3;
        float[][] uvs = new float[][]{ConnectingBakedModel.getUV(quad, 0), ConnectingBakedModel.getUV(quad, 1), ConnectingBakedModel.getUV(quad, 2), ConnectingBakedModel.getUV(quad, 3)};
        double angle1to2 = Math.atan2(uvs[1][1] - uvs[0][1], uvs[1][0] - uvs[0][0]);
        boolean textureFlipped = (angle1to2 - (angle1to3 = Math.atan2(uvs[2][1] - uvs[0][1], uvs[2][0] - uvs[0][0])) + Math.PI * 4) % (Math.PI * 2) < Math.PI;
        int topLeftMostIndex = 0;
        for (int i = 1; i < 4; ++i) {
            float[] current = uvs[i];
            float[] best = uvs[topLeftMostIndex];
            if (!(current[0] + current[1] < best[0] + best[1])) continue;
            topLeftMostIndex = i;
        }
        int textureRotation = textureFlipped ? topLeftMostIndex : (4 - topLeftMostIndex) % 4;
        float[][] positions3d = new float[][]{ConnectingBakedModel.getPosition(quad, 0), ConnectingBakedModel.getPosition(quad, 1), ConnectingBakedModel.getPosition(quad, 2), ConnectingBakedModel.getPosition(quad, 3)};
        float[][] pos = new float[4][2];
        Direction direction = quad.func_178210_d();
        for (int i = 0; i < 4; ++i) {
            if (direction == Direction.DOWN) {
                pos[i][0] = positions3d[i][0];
                pos[i][1] = -positions3d[i][2];
                continue;
            }
            if (direction == Direction.UP) {
                pos[i][0] = positions3d[i][0];
                pos[i][1] = positions3d[i][2];
                continue;
            }
            if (direction == Direction.NORTH) {
                pos[i][0] = -positions3d[i][0];
                pos[i][1] = -positions3d[i][1];
                continue;
            }
            if (direction == Direction.SOUTH) {
                pos[i][0] = positions3d[i][0];
                pos[i][1] = -positions3d[i][1];
                continue;
            }
            if (direction == Direction.WEST) {
                pos[i][0] = positions3d[i][2];
                pos[i][1] = -positions3d[i][1];
                continue;
            }
            if (direction != Direction.EAST) continue;
            pos[i][0] = -positions3d[i][2];
            pos[i][1] = -positions3d[i][1];
        }
        angle1to2 = Math.atan2(pos[1][1] - pos[0][1], pos[1][0] - pos[0][0]);
        boolean quadFlipped = (angle1to2 - (angle1to3 = Math.atan2(pos[2][1] - pos[0][1], pos[2][0] - pos[0][0])) + Math.PI * 4) % (Math.PI * 2) < Math.PI;
        topLeftMostIndex = 0;
        for (int i = 1; i < 4; ++i) {
            float[] current = pos[i];
            float[] best = pos[topLeftMostIndex];
            if (!(current[0] + current[1] < best[0] + best[1])) continue;
            topLeftMostIndex = i;
        }
        int quadRotation = textureFlipped ? topLeftMostIndex : 4 - topLeftMostIndex;
        boolean flipped = textureFlipped ^ quadFlipped;
        int rotation = quadFlipped ? (4 - textureRotation + quadRotation) % 4 : (textureRotation + quadRotation) % 4;
        return TextureOrientation.of(flipped, rotation);
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction cullDirection, Random random, IModelData data, @Nullable RenderType renderType) {
        ArrayList<TaggedBakedQuad> quads;
        if (renderType == null) {
            quads = this.completeBlockMesh[ConnectingBakedModel.cullIndex(cullDirection)];
        } else {
            List<TaggedBakedQuad>[] mesh = this.blockMesh.get(renderType);
            List<TaggedBakedQuad> list = quads = mesh == null ? null : mesh[ConnectingBakedModel.cullIndex(cullDirection)];
            if (this.shouldCheckOriginalBlockRenderTypes && state != null && OriginalRenderTypeHelper.couldBlockRenderInLayerOriginally(state, renderType)) {
                Iterator<TaggedBakedQuad> additionalQuads;
                mesh = this.blockMesh.get(FusionClient.USE_ORIGINAL_RENDER_TYPE_MARKER);
                Iterator<TaggedBakedQuad> iterator = additionalQuads = mesh == null ? null : mesh[ConnectingBakedModel.cullIndex(cullDirection)];
                if (additionalQuads != null) {
                    if (quads == null) {
                        quads = additionalQuads;
                    } else {
                        ArrayList<TaggedBakedQuad> combined = new ArrayList<TaggedBakedQuad>(quads.size() + additionalQuads.size());
                        combined.addAll(quads);
                        combined.addAll((Collection<TaggedBakedQuad>)((Object)additionalQuads));
                        quads = combined;
                    }
                }
            }
            if (quads == null) {
                quads = Collections.emptyList();
            }
        }
        if (this.predicates.isEmpty() && !this.hasSpecialQuads) {
            ArrayList<BakedQuad> bakedQuads = new ArrayList<BakedQuad>(quads.size());
            for (TaggedBakedQuad quad : quads) {
                bakedQuads.add(quad.bakedQuad);
            }
            return bakedQuads;
        }
        BlockPos pos = (BlockPos)data.getData(POSITION_PROPERTY);
        SurroundingBlockCache blockCache = (SurroundingBlockCache)data.getData(BLOCK_CACHE_PROPERTY);
        if (!(blockCache != null && !this.predicates.isEmpty() || pos != null && this.hasSpecialQuads)) {
            ArrayList<BakedQuad> bakedQuads = new ArrayList<BakedQuad>(quads.size());
            for (TaggedBakedQuad quad : quads) {
                bakedQuads.add(quad.bakedQuad);
            }
            return bakedQuads;
        }
        if (state != null && blockCache != null) {
            blockCache.setSelf(state);
        }
        TextureConnections[] connectionsCache = new TextureConnections[this.predicates.size()];
        ArrayList<BakedQuad> bakedQuads = new ArrayList<BakedQuad>(quads.size());
        OrientedMutableQuad mutableQuad = new OrientedMutableQuad();
        for (TaggedBakedQuad quad : quads) {
            if (pos != null && (quad.textureType == DefaultTextureTypes.RANDOM || quad.textureType == DefaultTextureTypes.CONTINUOUS)) {
                TextureAtlasSprite sprite = this.sprites.get(quad.spriteIndex);
                mutableQuad.fillFromBakedQuad(quad.bakedQuad);
                mutableQuad.resetPermutation();
                if (quad.textureType == DefaultTextureTypes.RANDOM) {
                    RandomTextureType.processQuad(mutableQuad, pos, quad.bakedQuad.func_178210_d(), random, (RandomTextureSprite)sprite);
                } else {
                    ContinuousTextureType.processQuad(mutableQuad, pos, quad.bakedQuad.func_178210_d(), (ContinuousTextureSprite)sprite);
                }
                bakedQuads.add(mutableQuad.toBakedQuad());
                continue;
            }
            if (blockCache != null && quad.textureType == DefaultTextureTypes.CONNECTING) {
                int quadIndex = quad.quadIndex;
                int predicateIndex = quad.predicateIndex;
                int spriteIndex = quad.spriteIndex;
                QuadPredicates predicate = this.predicates.get(predicateIndex);
                TextureConnections connections = connectionsCache[predicateIndex];
                if (connections == null) {
                    connections = connectionsCache[predicateIndex] = ConnectingBakedModel.computeConnections(predicate, blockCache);
                }
                TextureAtlasSprite sprite = this.sprites.get(spriteIndex);
                ConnectingTextureLayout layout = ((ConnectingTextureSprite)sprite).data().getLayout();
                mutableQuad.fillFromBakedQuad(quad.bakedQuad);
                mutableQuad.set(predicate.orientation.vertexIndexPermutation);
                boolean keepQuad = ConnectingTextureLayoutHandler.get(layout).processBlockQuad(quadIndex, mutableQuad, (ConnectingTextureSprite)sprite, connections);
                if (!keepQuad) continue;
                bakedQuads.add(mutableQuad.toBakedQuad());
                continue;
            }
            bakedQuads.add(quad.bakedQuad);
        }
        return bakedQuads;
    }

    private static TextureConnections computeConnections(QuadPredicates predicates, SurroundingBlockCache blocks) {
        ConnectionPredicate predicate = predicates.predicate;
        Direction face = predicates.direction;
        TextureOrientation orientation = predicates.orientation;
        int[] up = orientation.transformWorldVector(DEFAULT_TEXTURE_ROTATIONS_UP[face.ordinal()], face);
        int[] right = orientation.transformWorldVector(DEFAULT_TEXTURE_ROTATIONS_RIGHT[face.ordinal()], face);
        boolean connectTop = ConnectingBakedModel.shouldConnect(predicate, blocks, face, orientation.worldToTexture[0], up[0], up[1], up[2]);
        boolean connectTopRight = ConnectingBakedModel.shouldConnect(predicate, blocks, face, orientation.worldToTexture[1], up[0] + right[0], up[1] + right[1], up[2] + right[2]);
        boolean connectRight = ConnectingBakedModel.shouldConnect(predicate, blocks, face, orientation.worldToTexture[2], right[0], right[1], right[2]);
        boolean connectBottomRight = ConnectingBakedModel.shouldConnect(predicate, blocks, face, orientation.worldToTexture[3], -up[0] + right[0], -up[1] + right[1], -up[2] + right[2]);
        boolean connectBottom = ConnectingBakedModel.shouldConnect(predicate, blocks, face, orientation.worldToTexture[4], -up[0], -up[1], -up[2]);
        boolean connectBottomLeft = ConnectingBakedModel.shouldConnect(predicate, blocks, face, orientation.worldToTexture[5], -up[0] - right[0], -up[1] - right[1], -up[2] - right[2]);
        boolean connectLeft = ConnectingBakedModel.shouldConnect(predicate, blocks, face, orientation.worldToTexture[6], -right[0], -right[1], -right[2]);
        boolean connectTopLeft = ConnectingBakedModel.shouldConnect(predicate, blocks, face, orientation.worldToTexture[7], up[0] - right[0], up[1] - right[1], up[2] - right[2]);
        return new TextureConnections(connectTop, connectTopRight, connectRight, connectBottomRight, connectBottom, connectBottomLeft, connectLeft, connectTopLeft);
    }

    private static boolean shouldConnect(ConnectionPredicate predicate, SurroundingBlockCache blocks, Direction face, ConnectionDirection direction, int neighborX, int neighborY, int neighborZ) {
        IBlockDisplayReader level = blocks.getLevel();
        BlockPos position = blocks.getRealPos();
        BlockState self = blocks.getCenter();
        BlockState neighborState = blocks.getState(neighborX, neighborY, neighborZ);
        BlockState stateInFront = blocks.getState(neighborX + face.func_82601_c(), neighborY + face.func_96559_d(), neighborZ + face.func_82599_e());
        return predicate.shouldConnect((IBlockReader)level, position, face, self, neighborState, stateInFront, direction);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction cullDirection, @Nonnull Random random, @Nonnull IModelData data) {
        return this.getQuads(state, cullDirection, random, data, MinecraftForgeClient.getRenderLayer());
    }

    public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction cullDirection, Random random) {
        return this.getQuads(state, cullDirection, random, (IModelData)EmptyModelData.INSTANCE, MinecraftForgeClient.getRenderLayer());
    }

    public List<RenderType> getBlockRenderTypes() {
        return this.blockRenderTypes;
    }

    public List<Pair<IBakedModel, RenderType>> getLayerModels(ItemStack stack, boolean fabulous) {
        RenderType renderType;
        this.itemModel.set(stack, fabulous);
        if (this.shouldCheckOriginalItemRenderTypes && !(fabulous ? this.itemRenderTypesFabulous : this.itemRenderTypes).contains(renderType = RenderTypeLookup.func_239219_a_((ItemStack)stack, (boolean)fabulous))) {
            ArrayList<Pair<IBakedModel, RenderType>> combined = new ArrayList<Pair<IBakedModel, RenderType>>((fabulous ? this.itemPassesFabulous : this.itemPasses).size() + 1);
            combined.addAll(fabulous ? this.itemPassesFabulous : this.itemPasses);
            combined.add(Pair.of((Object)this.itemModel, (Object)renderType));
            return combined;
        }
        return fabulous ? this.itemPassesFabulous : this.itemPasses;
    }

    public boolean isLayered() {
        return true;
    }

    @Nonnull
    public IModelData getModelData(@Nonnull IBlockDisplayReader level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData data) {
        if (this.predicates.isEmpty() && !this.hasSpecialQuads) {
            return EmptyModelData.INSTANCE;
        }
        ModelDataMap.Builder builder = new ModelDataMap.Builder();
        if (this.hasSpecialQuads) {
            builder.withInitial(POSITION_PROPERTY, (Object)pos);
        }
        if (!this.predicates.isEmpty()) {
            SurroundingBlockCache blockCache = new SurroundingBlockCache(level, pos, state);
            blockCache.fillAll();
            builder.withInitial(BLOCK_CACHE_PROPERTY, (Object)blockCache);
        }
        return builder.build();
    }

    public boolean func_177555_b() {
        return this.hasAmbientOcclusion;
    }

    public boolean func_177556_c() {
        return this.isGui3d;
    }

    public boolean func_230044_c_() {
        return this.usesBlockLight;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.particleIcon;
    }

    public ItemCameraTransforms func_177552_f() {
        return this.transforms;
    }

    public ItemOverrideList func_188617_f() {
        return this.overrides;
    }

    private static int cullIndex(Direction cullDirection) {
        return cullDirection == null ? 0 : cullDirection.ordinal() + 1;
    }

    static {
        DEFAULT_TEXTURE_ROTATIONS_UP = new int[6][];
        DEFAULT_TEXTURE_ROTATIONS_RIGHT = new int[6][];
        VertexFormat blockFormat = DefaultVertexFormats.field_176600_a;
        VERTEX_SIZE = blockFormat.func_177338_f() / 4;
        VERTEX_UV_OFFSET = blockFormat.getOffset(blockFormat.func_227894_c_().indexOf((Object)DefaultVertexFormats.field_181715_o)) / 4;
        VERTEX_POSITION_OFFSET = blockFormat.getOffset(blockFormat.func_227894_c_().indexOf((Object)DefaultVertexFormats.field_181713_m)) / 4;
        for (Direction direction : Direction.values()) {
            int upX = 0;
            int upY = 0;
            int upZ = 0;
            int rightX = 0;
            int rightY = 0;
            int rightZ = 0;
            if (direction == Direction.DOWN) {
                upZ = 1;
                rightX = 1;
            } else if (direction == Direction.UP) {
                upZ = -1;
                rightX = 1;
            } else if (direction == Direction.NORTH) {
                upY = 1;
                rightX = -1;
            } else if (direction == Direction.SOUTH) {
                upY = 1;
                rightX = 1;
            } else if (direction == Direction.WEST) {
                upY = 1;
                rightZ = 1;
            } else if (direction == Direction.EAST) {
                upY = 1;
                rightZ = -1;
            }
            ConnectingBakedModel.DEFAULT_TEXTURE_ROTATIONS_UP[direction.ordinal()] = new int[]{upX, upY, upZ};
            ConnectingBakedModel.DEFAULT_TEXTURE_ROTATIONS_RIGHT[direction.ordinal()] = new int[]{rightX, rightY, rightZ};
        }
    }

    private static class TaggedBakedQuad {
        final BakedQuad bakedQuad;
        final TextureType<?> textureType;
        final int spriteIndex;
        final int predicateIndex;
        final int quadIndex;

        private TaggedBakedQuad(BakedQuad bakedQuad, TextureType<?> textureType, int spriteIndex, int predicateIndex, int quadIndex) {
            this.bakedQuad = bakedQuad;
            this.textureType = textureType;
            this.spriteIndex = spriteIndex;
            this.predicateIndex = predicateIndex;
            this.quadIndex = quadIndex;
        }
    }

    private static enum TextureOrientation {
        NORMAL_0(false, 0),
        NORMAL_90(false, 1),
        NORMAL_180(false, 2),
        NORMAL_270(false, 3),
        FLIPPED_0(true, 0),
        FLIPPED_90(false, 1),
        FLIPPED_180(true, 2),
        FLIPPED_270(true, 3);

        public final boolean flipped;
        public final int rotations;
        public final ConnectionDirection[] worldToTexture;
        public final int[] vertexIndexPermutation;

        public static TextureOrientation of(boolean flipped, int rotations) {
            return TextureOrientation.values()[flipped ? 4 + rotations : rotations];
        }

        private TextureOrientation(boolean flipped, int rotations) {
            this.flipped = flipped;
            this.rotations = rotations;
            this.worldToTexture = ConnectionDirection.values();
            this.vertexIndexPermutation = new int[]{0, 3, 2, 1};
            if (flipped) {
                this.worldToTexture[ConnectionDirection.TOP.ordinal()] = ConnectionDirection.LEFT;
                this.worldToTexture[ConnectionDirection.TOP_RIGHT.ordinal()] = ConnectionDirection.BOTTOM_LEFT;
                this.worldToTexture[ConnectionDirection.RIGHT.ordinal()] = ConnectionDirection.BOTTOM;
                this.worldToTexture[ConnectionDirection.LEFT.ordinal()] = ConnectionDirection.TOP;
                this.worldToTexture[ConnectionDirection.BOTTOM_LEFT.ordinal()] = ConnectionDirection.TOP_RIGHT;
                this.worldToTexture[ConnectionDirection.BOTTOM.ordinal()] = ConnectionDirection.RIGHT;
                this.vertexIndexPermutation[1] = 1;
                this.vertexIndexPermutation[3] = 3;
            }
            if (rotations != 0) {
                ConnectionDirection[] old = Arrays.copyOf(this.worldToTexture, this.worldToTexture.length);
                for (int i = 0; i < 8; ++i) {
                    this.worldToTexture[i] = old[(i - rotations * 2 + 8) % 8];
                }
                int[] old2 = Arrays.copyOf(this.vertexIndexPermutation, this.vertexIndexPermutation.length);
                for (int i = 0; i < 4; ++i) {
                    this.vertexIndexPermutation[i] = old2[(i + rotations + 4) % 4];
                }
            }
        }

        public int[] transformWorldVector(int[] vector, Direction face) {
            boolean positive;
            if (!this.flipped && this.rotations == 0) {
                return vector;
            }
            int[] newVector = Arrays.copyOf(vector, vector.length);
            Direction.Axis axis = face.func_176740_k();
            boolean bl = positive = face.func_176743_c() == Direction.AxisDirection.POSITIVE;
            if (this.flipped) {
                if (face.func_176740_k() == Direction.Axis.X) {
                    newVector[1] = positive ? vector[2] : -vector[2];
                    int n = newVector[2] = positive ? vector[1] : -vector[1];
                }
                if (face.func_176740_k() == Direction.Axis.Y) {
                    newVector[0] = positive ? vector[2] : -vector[2];
                    int n = newVector[2] = positive ? vector[0] : -vector[0];
                }
                if (face.func_176740_k() == Direction.Axis.Z) {
                    newVector[0] = positive ? vector[1] : -vector[1];
                    int n = newVector[1] = positive ? vector[0] : -vector[0];
                }
            }
            if (this.rotations > 0) {
                if (this.rotations == 2) {
                    if (axis != Direction.Axis.X) {
                        newVector[0] = -newVector[0];
                    }
                    if (axis != Direction.Axis.Y) {
                        newVector[1] = -newVector[1];
                    }
                    if (axis != Direction.Axis.Z) {
                        newVector[2] = -newVector[2];
                    }
                } else {
                    int oldX = newVector[0];
                    int oldY = newVector[1];
                    if (axis != Direction.Axis.X) {
                        newVector[0] = (positive ^ this.rotations == 3 ? 1 : -1) * (axis == Direction.Axis.Y ? -newVector[2] : newVector[1]);
                    }
                    if (axis != Direction.Axis.Y) {
                        newVector[1] = (positive ^ this.rotations == 3 ? 1 : -1) * (axis == Direction.Axis.Z ? -oldX : newVector[2]);
                    }
                    if (axis != Direction.Axis.Z) {
                        newVector[2] = (positive ^ this.rotations == 3 ? 1 : -1) * (axis == Direction.Axis.X ? -oldY : oldX);
                    }
                }
            }
            return newVector;
        }
    }

    private static class QuadPredicates {
        public final Direction direction;
        public final TextureOrientation orientation;
        public final ConnectionPredicate predicate;

        private QuadPredicates(Direction direction, TextureOrientation orientation, ConnectionPredicate predicate) {
            this.direction = direction;
            this.orientation = orientation;
            this.predicate = predicate;
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof QuadPredicates)) {
                return false;
            }
            QuadPredicates that = (QuadPredicates)o;
            return this.direction == that.direction && this.orientation == that.orientation && this.predicate.equals(that.predicate);
        }

        public int hashCode() {
            int result = this.direction.hashCode();
            result = 31 * result + this.orientation.hashCode();
            result = 31 * result + this.predicate.hashCode();
            return result;
        }
    }
}

