/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.connecting.predicates;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.predicate.ConnectionDirection;
import com.supermartijn642.fusion.api.predicate.ConnectionPredicate;
import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.api.util.Serializer;
import com.supermartijn642.fusion.util.IdentifierUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class MatchStateInFrontConnectionPredicate
implements ConnectionPredicate {
    public static final Serializer<MatchStateInFrontConnectionPredicate> SERIALIZER = new Serializer<MatchStateInFrontConnectionPredicate>(){

        @Override
        public MatchStateInFrontConnectionPredicate deserialize(JsonObject json) throws JsonParseException {
            if (!(json.has("block") && json.get("block").isJsonPrimitive() && json.getAsJsonPrimitive("block").isString())) {
                throw new JsonParseException("Match state predicate must have string property 'block'!");
            }
            if (!IdentifierUtil.isValidIdentifier(json.get("block").getAsString())) {
                throw new JsonParseException("Property 'block' must be a valid identifier!");
            }
            ResourceLocation identifier = new ResourceLocation(json.get("block").getAsString());
            if (!Registry.field_212618_g.func_212607_c(identifier)) {
                throw new JsonParseException("Unknown block '" + identifier + "'!");
            }
            Block block = (Block)Registry.field_212618_g.func_82594_a(identifier);
            ArrayList<Pair<Property<?>, Set<?>>> properties = new ArrayList();
            if (!json.has("properties") || !json.get("properties").isJsonObject()) {
                throw new JsonParseException("Match block predicate must have object property 'properties'!");
            }
            if (json.getAsJsonObject("properties").size() == 0) {
                throw new JsonParseException("At least one property must be specified for match state predicate!");
            }
            for (Map.Entry entry : json.getAsJsonObject("properties").entrySet()) {
                Property property = block.func_176194_O().func_185920_a((String)entry.getKey());
                if (property == null) {
                    throw new JsonParseException("Block '" + identifier + "' does not have a property named '" + (String)entry.getKey() + "'!");
                }
                ImmutableSet.Builder builder = ImmutableSet.builder();
                if (((JsonElement)entry.getValue()).isJsonPrimitive() && ((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                    Optional value = property.func_185929_b(((JsonElement)entry.getValue()).getAsString());
                    if (!value.isPresent()) {
                        throw new JsonParseException("Unknown value '" + ((JsonElement)entry.getValue()).getAsString() + "' for property '" + property.func_177701_a() + "' in block '" + identifier + "'!");
                    }
                    builder.add(value.get());
                } else if (((JsonElement)entry.getValue()).isJsonArray()) {
                    if (((JsonElement)entry.getValue()).getAsJsonArray().size() == 0) {
                        throw new JsonParseException("Valid values for property '" + property.func_177701_a() + "' cannot be empty!");
                    }
                    for (JsonElement element : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                        if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString()) {
                            throw new JsonParseException("Property '" + (String)entry.getKey() + "' must be a string or an array of strings!");
                        }
                        Optional value = property.func_185929_b(element.getAsString());
                        if (!value.isPresent()) {
                            throw new JsonParseException("Unknown value '" + element.getAsString() + "' for property '" + property.func_177701_a() + "' in block '" + identifier + "'!");
                        }
                        builder.add(value.get());
                    }
                } else {
                    throw new JsonParseException("Property '" + (String)entry.getKey() + "' must be a string or an array of strings!");
                }
                properties.add(Pair.of(property, builder.build()));
            }
            properties = Arrays.asList(properties.toArray(new Pair[0]));
            return new MatchStateInFrontConnectionPredicate(block, properties);
        }

        @Override
        public JsonObject serialize(MatchStateInFrontConnectionPredicate value) {
            JsonObject json = new JsonObject();
            json.addProperty("block", Registry.field_212618_g.func_177774_c((Object)value.block).toString());
            JsonObject properties = new JsonObject();
            value.properties.stream().map(p -> p.mapRight(values -> {
                JsonArray array = new JsonArray();
                values.stream().map(v -> ((Property)p.left()).func_177702_a((Comparable)v)).sorted().forEach(arg_0 -> ((JsonArray)array).add(arg_0));
                return array;
            })).map(p -> p.mapLeft(Property::func_177701_a)).sorted(Comparator.comparing(Pair::left)).forEach(pair -> properties.add((String)pair.left(), (JsonElement)pair.right()));
            json.add("properties", (JsonElement)properties);
            return json;
        }
    };
    private final Block block;
    private final List<Pair<Property<?>, Set<?>>> properties;
    private boolean compareStates = false;
    private Set<BlockState> states = null;

    public MatchStateInFrontConnectionPredicate(Block block, List<Pair<Property<?>, Set<?>>> properties) {
        this.block = block;
        this.properties = properties;
        this.computeStates();
    }

    @SafeVarargs
    public MatchStateInFrontConnectionPredicate(Block block, Pair<Property<?>, ?> ... propertyPair) {
        this.block = block;
        HashMap<Property, List> propertyMap = new HashMap<Property, List>();
        for (Pair<Property<?>, ?> pair : propertyPair) {
            Property<?> property = pair.left();
            if (!block.func_176194_O().func_177623_d().contains(property)) {
                throw new IllegalArgumentException("Property '" + property.func_177701_a() + "' is not a property of block '" + Registry.field_212618_g.func_177774_c((Object)block) + "'!");
            }
            Object value = pair.right();
            if (!property.func_177700_c().contains(value)) {
                throw new IllegalArgumentException("Invalid value '" + value + "' for property '" + property.func_177701_a() + "'!");
            }
            propertyMap.computeIfAbsent(property, p -> new ArrayList()).add(value);
        }
        Pair[] properties = new Pair[propertyMap.size()];
        int index = 0;
        for (Map.Entry entry : propertyMap.entrySet()) {
            properties[index++] = Pair.of(entry.getKey(), ImmutableSet.copyOf((Collection)((Collection)entry.getValue())));
        }
        this.properties = Arrays.asList(properties);
        this.computeStates();
    }

    private <T extends Comparable<T>> void computeStates() {
        HashSet unrestrictedProperties = new HashSet(this.block.func_176194_O().func_177623_d());
        int validStates = 1;
        for (Pair<Property<?>, Set<?>> pair : this.properties) {
            validStates *= pair.right().size();
            unrestrictedProperties.remove(pair.left());
        }
        for (Property property : unrestrictedProperties) {
            validStates *= property.func_177700_c().size();
        }
        if (validStates > 64) {
            return;
        }
        Stream<Object> states = Stream.of(this.block.func_176194_O().func_177621_b());
        for (Pair<Property<?>, Set<?>> pair : this.properties) {
            Property<?> property = pair.left();
            Set<?> values = pair.right();
            states = states.flatMap(state -> values.stream().map(value -> (BlockState)state.func_206870_a(property, (Comparable)value)));
        }
        for (Property property : unrestrictedProperties) {
            states = states.flatMap(state -> property.func_241491_c_().map(value -> (BlockState)state.func_206870_a(property, value.func_241493_b_())));
        }
        this.compareStates = true;
        this.states = (Set)states.collect(ImmutableSet.toImmutableSet());
        if (this.states.size() != validStates) {
            throw new AssertionError((Object)("Got two different numbers of valid states: " + validStates + " and " + this.states.size() + "!"));
        }
    }

    @Override
    public boolean shouldConnect(Direction side, @Nullable BlockState ownState, BlockState otherState, BlockState blockInFront, ConnectionDirection direction) {
        if (this.compareStates) {
            return this.states.contains(blockInFront);
        }
        if (blockInFront.func_177230_c() != this.block) {
            return false;
        }
        for (Pair<Property<?>, Set<?>> property : this.properties) {
            if (property.right().contains(blockInFront.func_177229_b(property.left()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Serializer<? extends ConnectionPredicate> getSerializer() {
        return SERIALIZER;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MatchStateInFrontConnectionPredicate)) {
            return false;
        }
        MatchStateInFrontConnectionPredicate that = (MatchStateInFrontConnectionPredicate)o;
        return this.block.equals(that.block) && this.properties.equals(that.properties);
    }

    public int hashCode() {
        int result = this.block.hashCode();
        result = 31 * result + this.properties.hashCode();
        return result;
    }
}

