/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.texture.types.base;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.texture.SpriteCreationContext;
import com.supermartijn642.fusion.api.texture.SpritePreparationContext;
import com.supermartijn642.fusion.api.texture.TextureErrorException;
import com.supermartijn642.fusion.api.texture.TextureType;
import com.supermartijn642.fusion.api.texture.data.BaseTextureData;
import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.texture.types.base.BaseTextureSprite;
import java.util.Arrays;
import java.util.Locale;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;

public class BaseTextureType
implements TextureType<BaseTextureData> {
    @Override
    public Pair<Integer, Integer> getFrameSize(SpritePreparationContext context, BaseTextureData data) {
        if (context.getTextureWidth() % context.getOriginalFrameWith() != 0 || context.getTextureHeight() % context.getOriginalFrameHeight() != 0) {
            throw new TextureErrorException("Image size " + context.getTextureWidth() + "x" + context.getTextureHeight() + " is not a multiple of frame size " + context.getOriginalFrameWith() + "x" + context.getOriginalFrameHeight() + "!");
        }
        return context.getOriginalFrameSize();
    }

    @Override
    public TextureAtlasSprite createSprite(SpriteCreationContext context, BaseTextureData data) {
        return new BaseTextureSprite(context.createOriginalSprite(), data);
    }

    @Override
    public BaseTextureData deserialize(JsonObject json) throws JsonParseException {
        BaseTextureData.Builder<?, BaseTextureData> builder = BaseTextureData.builder();
        if (json.has("render_type")) {
            BaseTextureData.RenderType renderType;
            if (!json.get("render_type").isJsonPrimitive() || !json.getAsJsonPrimitive("render_type").isString()) {
                throw new JsonParseException("Property 'render_type' must be a string!");
            }
            String renderTypeString = json.get("render_type").getAsString();
            try {
                renderType = BaseTextureData.RenderType.valueOf(renderTypeString.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new JsonParseException("Property 'render_type' must be one of " + Arrays.toString((Object[])BaseTextureData.RenderType.values()).toLowerCase(Locale.ROOT) + ", not '" + renderTypeString + "'!");
            }
            builder.renderType(renderType);
        }
        if (json.has("emissive")) {
            if (!json.get("emissive").isJsonPrimitive() || !json.getAsJsonPrimitive("emissive").isBoolean()) {
                throw new JsonParseException("Property 'emissive' must be a boolean!");
            }
            builder.emissive(json.get("emissive").getAsBoolean());
        }
        if (json.has("tinting")) {
            BaseTextureData.QuadTinting tinting;
            if (!json.get("tinting").isJsonPrimitive() || !json.getAsJsonPrimitive("tinting").isString()) {
                throw new JsonParseException("Property 'tinting' must be a string!");
            }
            String tintingString = json.get("tinting").getAsString();
            try {
                tinting = BaseTextureData.QuadTinting.valueOf(tintingString.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new JsonParseException("Property 'tinting' must be one of " + Arrays.toString((Object[])BaseTextureData.QuadTinting.values()).toLowerCase(Locale.ROOT) + ", not '" + tintingString + "'!");
            }
            builder.tinting(tinting);
        }
        return builder.build();
    }

    @Override
    public JsonObject serialize(BaseTextureData value) {
        JsonObject json = new JsonObject();
        if (value.getRenderType() != null) {
            json.addProperty("render_type", value.getRenderType().name().toLowerCase());
        }
        if (value.isEmissive()) {
            json.addProperty("emissive", Boolean.valueOf(true));
        }
        if (value.getTinting() != null) {
            json.addProperty("tinting", value.getTinting().name().toLowerCase());
        }
        return json;
    }
}

