/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.modifiers.block;

import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.model.modifiers.block.BlockModelModifierBakedModel;
import com.supermartijn642.fusion.model.modifiers.block.PaneCullingBakedModel;
import com.supermartijn642.fusion.util.IdentifierUtil;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockModelModifierReloadListener
implements PreparableReloadListener {
    private static final Gson GSON = new GsonBuilder().setLenient().create();
    private static final String LOCATION = "fusion/model_modifiers/blocks";
    public static final BlockModelModifierReloadListener INSTANCE = new BlockModelModifierReloadListener();
    private final Map<ModelResourceLocation, Properties> models = new HashMap<ModelResourceLocation, Properties>();

    private BlockModelModifierReloadListener() {
    }

    public void registerOverlays(ModelBakery bakery) {
        HashSet<ResourceLocation> models = new HashSet<ResourceLocation>();
        for (Properties properties : this.models.values()) {
            models.addAll(properties.appendModels);
        }
        for (ResourceLocation model : models) {
            UnbakedModel unbakedModel = bakery.m_119341_(model);
            bakery.f_119212_.put(model, unbakedModel);
            bakery.f_119214_.put(model, unbakedModel);
            unbakedModel.m_5500_(arg_0 -> ((ModelBakery)bakery).m_119341_(arg_0));
        }
    }

    public void applyOverlays(ModelBakery bakery) {
        Map bakedModels = bakery.m_119251_();
        for (Map.Entry<ModelResourceLocation, Properties> entry : this.models.entrySet()) {
            ModelResourceLocation target = entry.getKey();
            BakedModel targetModel = (BakedModel)bakedModels.get(target);
            Properties properties = entry.getValue();
            List<ResourceLocation> overlays = properties.appendModels;
            List<BakedModel> overlayModels = overlays.stream().map(bakedModels::get).toList();
            Object model = new BlockModelModifierBakedModel(targetModel, overlayModels);
            if (properties.paneCullingFix) {
                model = new PaneCullingBakedModel((BakedModel)model);
            }
            bakedModels.put(target, model);
        }
    }

    public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier barrier, ResourceManager resourceManager, ProfilerFiller profiler, ProfilerFiller profiler2, Executor executor, Executor executor2) {
        return CompletableFuture.runAsync(() -> this.reload(resourceManager)).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)barrier).m_6769_(arg_0));
    }

    private void reload(ResourceManager resourceManager) {
        ResourceLocation location;
        this.models.clear();
        HashMap<ResourceLocation, JsonElement> resources = new HashMap<ResourceLocation, JsonElement>();
        FileToIdConverter fileToId = FileToIdConverter.m_246568_((String)LOCATION);
        for (Map.Entry entry : fileToId.m_247457_(resourceManager).entrySet()) {
            location = fileToId.m_245273_((ResourceLocation)entry.getKey());
            try {
                BufferedReader reader = ((Resource)entry.getValue()).m_215508_();
                try {
                    JsonElement element = (JsonElement)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonElement.class);
                    resources.put(location, element);
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (JsonParseException e) {
                FusionClient.LOGGER.error("Failed to parse json from block model overlay '{}'!", entry.getKey(), (Object)e);
            }
            catch (Exception e) {
                FusionClient.LOGGER.error("Encountered an exception whilst reading block model overlay at '{}'!", entry.getKey(), (Object)e);
            }
        }
        for (Map.Entry entry : resources.entrySet()) {
            location = (ResourceLocation)entry.getKey();
            if (!((JsonElement)entry.getValue()).isJsonObject()) {
                throw new IllegalArgumentException("Block model overlay '" + location + "' must contain a json object!");
            }
            JsonObject json = ((JsonElement)entry.getValue()).getAsJsonObject();
            try {
                this.parseResource(json);
            }
            catch (JsonParseException e) {
                FusionClient.LOGGER.error("Failed to parse block model overlay '{}': {}", (Object)location, (Object)e.getMessage());
            }
        }
    }

    private void parseResource(JsonObject json) {
        if (!json.has("targets") || !json.get("targets").isJsonArray()) {
            throw new JsonParseException("Model overlay must have array property 'targets'!");
        }
        JsonArray targetsJson = json.getAsJsonArray("targets");
        HashSet targets = new HashSet();
        for (JsonElement element : targetsJson) {
            if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
                if (!IdentifierUtil.isValidIdentifier(element.getAsString())) {
                    throw new JsonParseException("Target must be a valid identifier, not '" + element.getAsString() + "'!!");
                }
                ResourceLocation identifier = new ResourceLocation(element.getAsString());
                Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(identifier);
                if (block == null || block == Blocks.f_50016_) {
                    throw new JsonParseException("Could not find a block for model overlay target '" + identifier + "'!");
                }
                block.m_49965_().m_61056_().stream().map(BlockModelShaper::m_110895_).forEach(targets::add);
                continue;
            }
            if (element.isJsonObject()) {
                this.parseTarget(element.getAsJsonObject()).map(BlockModelShaper::m_110895_).forEach(targets::add);
                continue;
            }
            throw new JsonParseException("Model overlay 'targets' array must only contain objects and strings!");
        }
        if (targets.isEmpty()) {
            return;
        }
        if (!json.has("append") && !json.has("pane_culling_fix")) {
            throw new JsonParseException("Must have either 'append' or 'pane_culling_fix' property!");
        }
        LinkedHashSet<ResourceLocation> models = new LinkedHashSet<ResourceLocation>();
        if (json.has("append")) {
            if (!json.get("append").isJsonArray()) {
                throw new JsonParseException("Property 'append' must be an array!");
            }
            JsonArray appendJson = json.getAsJsonArray("append");
            for (JsonElement element : appendJson) {
                if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString()) {
                    throw new JsonParseException("Array property 'append' must only contain strings!");
                }
                if (!IdentifierUtil.isValidIdentifier(element.getAsString())) {
                    throw new JsonParseException("Model must be a valid identifier, not '" + element.getAsString() + "'!!");
                }
                models.add(new ResourceLocation(element.getAsString()));
            }
        }
        boolean paneCullingFix = false;
        if (json.has("pane_culling_fix")) {
            if (!json.get("pane_culling_fix").isJsonPrimitive() || !json.getAsJsonPrimitive("pane_culling_fix").isBoolean()) {
                throw new JsonParseException("Property 'pane_culling_fix' must be a boolean!");
            }
            paneCullingFix = json.get("pane_culling_fix").getAsBoolean();
        }
        if (models.isEmpty() && !paneCullingFix) {
            return;
        }
        for (ModelResourceLocation target : targets) {
            Properties properties = this.models.computeIfAbsent(target, t -> new Properties());
            properties.appendModels.addAll(models);
            properties.paneCullingFix = paneCullingFix;
        }
    }

    private Stream<BlockState> parseTarget(JsonObject json) {
        if (!(json.has("block") && json.get("block").isJsonPrimitive() && json.getAsJsonPrimitive("block").isString())) {
            throw new JsonParseException("Target must have string property 'block'!");
        }
        if (!IdentifierUtil.isValidIdentifier(json.get("block").getAsString())) {
            throw new JsonParseException("Target property 'block' must be a valid identifier, not '" + json.get("block").getAsString() + "'!!");
        }
        ResourceLocation identifier = new ResourceLocation(json.get("block").getAsString());
        Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(identifier);
        if (block == null || block == Blocks.f_50016_) {
            throw new JsonParseException("Could not find a block for model overlay target '" + identifier + "'!");
        }
        HashMap<Property, ImmutableSet> properties = new HashMap<Property, ImmutableSet>();
        if (!json.has("properties") || !json.get("properties").isJsonObject()) {
            throw new JsonParseException("Match block predicate must have object property 'properties'!");
        }
        if (json.getAsJsonObject("properties").size() == 0) {
            throw new JsonParseException("At least one property must be specified for match state predicate!");
        }
        for (Map.Entry entry : json.getAsJsonObject("properties").entrySet()) {
            Property property = block.m_49965_().m_61081_((String)entry.getKey());
            if (property == null) {
                throw new JsonParseException("Block '" + identifier + "' does not have a property named '" + (String)entry.getKey() + "'!");
            }
            ImmutableSet.Builder builder = ImmutableSet.builder();
            if (((JsonElement)entry.getValue()).isJsonPrimitive() && ((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                Optional value = property.m_6215_(((JsonElement)entry.getValue()).getAsString());
                if (value.isEmpty()) {
                    throw new JsonParseException("Unknown value '" + ((JsonElement)entry.getValue()).getAsString() + "' for property '" + property.m_61708_() + "' in block '" + identifier + "'!");
                }
                builder.add(value.get());
            } else if (((JsonElement)entry.getValue()).isJsonArray()) {
                if (((JsonElement)entry.getValue()).getAsJsonArray().isEmpty()) {
                    throw new JsonParseException("Valid values for property '" + property.m_61708_() + "' cannot be empty!");
                }
                for (JsonElement element : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                    if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString()) {
                        throw new JsonParseException("Property '" + (String)entry.getKey() + "' must be a string or an array of strings!");
                    }
                    Optional value = property.m_6215_(element.getAsString());
                    if (value.isEmpty()) {
                        throw new JsonParseException("Unknown value '" + element.getAsString() + "' for property '" + property.m_61708_() + "' in block '" + identifier + "'!");
                    }
                    builder.add(value.get());
                }
            } else {
                throw new JsonParseException("Property '" + (String)entry.getKey() + "' must be a string or an array of strings!");
            }
            properties.put(property, builder.build());
        }
        Stream<Object> states = Stream.of((BlockState)block.m_49965_().m_61090_());
        for (Property property : block.m_49965_().m_61092_()) {
            if (properties.containsKey(property)) {
                Set values = (Set)properties.get(property);
                states = states.flatMap(state -> values.stream().map(value -> BlockModelModifierReloadListener.stateWithValue(state, property, value)));
                continue;
            }
            states = states.flatMap(state -> property.m_61702_().map(value -> BlockModelModifierReloadListener.stateWithValue(state, property, value.f_61713_())));
        }
        return states;
    }

    private static <T extends Comparable<T>> BlockState stateWithValue(BlockState state, Property<?> property, Object value) {
        return (BlockState)state.m_61124_(property, (Comparable)value);
    }

    public String m_7812_() {
        return "Fusion Block Model Overlay Reload Listener";
    }

    private static class Properties {
        final List<ResourceLocation> appendModels = new ArrayList<ResourceLocation>();
        boolean paneCullingFix;

        private Properties() {
        }
    }
}

