/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.api.provider;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.fusion.api.model.modifier.item.ItemPredicate;
import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.model.modifiers.item.predicates.AndItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.ItemPredicateRegistry;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_7923;

public abstract class FusionItemModelModifierProvider
implements class_2405 {
    private final Map<class_2960, ModifierBuilder> modifiers = new HashMap<class_2960, ModifierBuilder>();
    private final String modName;
    private final class_7784 output;

    public FusionItemModelModifierProvider(String modid, class_7784 output) {
        this.modName = FabricLoader.getInstance().getModContainer(modid).map(ModContainer::getMetadata).map(ModMetadata::getName).orElse(modid);
        this.output = output;
    }

    public final CompletableFuture<?> method_10319(class_7403 cache) {
        this.generate();
        ArrayList<CompletableFuture> tasks = new ArrayList<CompletableFuture>();
        Path output = this.output.method_45971();
        for (Map.Entry<class_2960, ModifierBuilder> entry : this.modifiers.entrySet()) {
            class_2960 location = entry.getKey();
            JsonObject json = this.toJson(entry.getValue());
            String extension = location.method_12832().endsWith(".json") ? "" : ".json";
            Path path = Path.of("assets", location.method_12836(), "fusion/model_modifiers/items", location.method_12832() + extension);
            tasks.add(class_2405.method_10320((class_7403)cache, (JsonElement)json, (Path)output.resolve(path)));
        }
        return CompletableFuture.allOf((CompletableFuture[])tasks.toArray(CompletableFuture[]::new));
    }

    private JsonObject toJson(ModifierBuilder modifier) {
        JsonObject json = new JsonObject();
        if (modifier.targets.isEmpty()) {
            throw new IllegalArgumentException("Modifier '" + String.valueOf(modifier.location) + "' must have at least one target!");
        }
        JsonArray targets = new JsonArray();
        modifier.targets.stream().sorted().map(class_2960::toString).forEach(arg_0 -> ((JsonArray)targets).add(arg_0));
        json.add("targets", (JsonElement)targets);
        if (modifier.defaultModel != null) {
            json.addProperty("default_model", modifier.defaultModel.toString());
        }
        JsonArray models = new JsonArray();
        for (Pair<class_2960, ItemPredicate> pair : modifier.conditionalModels) {
            JsonObject model = new JsonObject();
            model.addProperty("model", pair.left().toString());
            JsonArray conditions = new JsonArray();
            List<ItemPredicate> predicates = pair.right() instanceof AndItemPredicate ? ((AndItemPredicate)pair.right()).getPredicates() : List.of(pair.right());
            predicates.stream().map(ItemPredicateRegistry::serializeItemPredicate).forEach(arg_0 -> ((JsonArray)conditions).add(arg_0));
            model.add("conditions", (JsonElement)conditions);
            models.add((JsonElement)model);
        }
        json.add("models", (JsonElement)models);
        return json;
    }

    protected abstract void generate();

    public final ModifierBuilder modifier(class_2960 location) {
        return this.modifiers.computeIfAbsent(location, ModifierBuilder::new);
    }

    public String method_10321() {
        return "Fusion Item Model Modifier Provider: " + this.modName;
    }

    public static final class ModifierBuilder {
        private final class_2960 location;
        private final Set<class_2960> targets = new HashSet<class_2960>();
        private final List<Pair<class_2960, ItemPredicate>> conditionalModels = new ArrayList<Pair<class_2960, ItemPredicate>>();
        private class_2960 defaultModel = null;

        private ModifierBuilder(class_2960 location) {
            this.location = location;
        }

        public ModifierBuilder target(class_2960 item) {
            this.targets.add(item);
            return this;
        }

        public ModifierBuilder target(class_1792 item) {
            return this.target(class_7923.field_41178.method_10221((Object)item));
        }

        public ModifierBuilder target(class_2248 block) {
            class_1792 item = class_1792.method_7867((class_2248)block);
            if (item == null || block != class_2246.field_10124 && item == class_1802.field_8162) {
                throw new IllegalArgumentException("Block '" + String.valueOf(block) + "' does not have an item!");
            }
            return this.target(item);
        }

        public ModifierBuilder defaultModel(class_2960 location) {
            this.defaultModel = location;
            return this;
        }

        public ModifierBuilder conditionalModel(class_2960 model, ItemPredicate condition) {
            this.conditionalModels.add(Pair.of(model, condition));
            return this;
        }
    }
}

