/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.base;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.model.DefaultModelTypes;
import com.supermartijn642.fusion.api.model.ModelBakingContext;
import com.supermartijn642.fusion.api.model.ModelType;
import com.supermartijn642.fusion.api.model.data.BaseModelData;
import com.supermartijn642.fusion.model.types.base.BaseBakedModel;
import com.supermartijn642.fusion.model.types.base.BaseModelDataImpl;
import com.supermartijn642.fusion.model.types.base.BaseModelElement;
import com.supermartijn642.fusion.model.types.base.BaseModelQuad;
import com.supermartijn642.fusion.util.IdentifierUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_793;
import net.minecraft.class_801;
import net.minecraft.class_809;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;

public class BaseModelType
implements ModelType<BaseModelData> {
    @Override
    public Collection<class_2960> getModelDependencies(BaseModelData data) {
        return data.getParents();
    }

    @Override
    @Nullable
    public class_1100 getAsVanillaModel(BaseModelData data) {
        return data.getVanillaModel();
    }

    @Override
    public List<class_2960> getParentModels(BaseModelData data) {
        return data.getParents();
    }

    @Override
    public class_1087 bake(ModelBakingContext context, BaseModelData data) {
        ((BaseModelDataImpl)data).validateParents(context);
        List<BaseModelQuad> quads = ((BaseModelDataImpl)data).bakeQuads(context);
        boolean ambientOcclusion = ((BaseModelDataImpl)data).findProperty(context, class_1100::method_65537, true);
        boolean isGui3d = ((BaseModelDataImpl)data).findProperty(context, model -> model instanceof class_801 ? Boolean.valueOf(false) : null, true);
        boolean usesBlockLight = ((BaseModelDataImpl)data).findProperty(context, class_1100::method_24298, class_1100.class_4751.field_21859).method_24299();
        class_1058 particleSprite = context.getTexture(((BaseModelDataImpl)data).findParticleSprite(context));
        class_809 itemTransforms = new class_809(((BaseModelDataImpl)data).findItemTransform(context, class_811.field_4323), ((BaseModelDataImpl)data).findItemTransform(context, class_811.field_4320), ((BaseModelDataImpl)data).findItemTransform(context, class_811.field_4321), ((BaseModelDataImpl)data).findItemTransform(context, class_811.field_4322), ((BaseModelDataImpl)data).findItemTransform(context, class_811.field_4316), ((BaseModelDataImpl)data).findItemTransform(context, class_811.field_4317), ((BaseModelDataImpl)data).findItemTransform(context, class_811.field_4318), ((BaseModelDataImpl)data).findItemTransform(context, class_811.field_4319));
        return new BaseBakedModel(quads, ambientOcclusion, isGui3d, usesBlockLight, particleSprite, itemTransforms);
    }

    @Override
    public BaseModelData deserialize(JsonObject json) throws JsonParseException {
        class_793 model = (class_793)DefaultModelTypes.VANILLA.deserialize(json);
        if (json.has("parent") && json.has("parents")) {
            throw new JsonParseException("Model can only have either 'parent' or 'parents', not both!");
        }
        List<class_2960> parents = List.of();
        if (json.has("parent")) {
            if (!json.get("parent").isJsonPrimitive() || !json.get("parent").getAsJsonPrimitive().isString()) {
                throw new JsonParseException("Property 'parent' must be a string!");
            }
            String parent = json.get("parent").getAsString();
            if (!IdentifierUtil.isValidIdentifier(parent)) {
                throw new JsonParseException("Property 'parent' must be a valid identifier!");
            }
            parents = List.of(class_2960.method_60654((String)parent));
        } else if (json.has("parents")) {
            if (!json.get("parents").isJsonArray()) {
                throw new JsonParseException("Property 'parents' must be an array!");
            }
            JsonArray parentArray = json.getAsJsonArray("parents");
            parents = new ArrayList(parentArray.size());
            for (JsonElement element2 : parentArray) {
                if (!element2.isJsonPrimitive() || !element2.getAsJsonPrimitive().isString()) {
                    throw new JsonParseException("Array 'parents' must only contain strings!");
                }
                String parent = element2.getAsString();
                if (!IdentifierUtil.isValidIdentifier(parent)) {
                    throw new JsonParseException("Array 'parents' must only contain valid identifiers, not '" + parent + "'!");
                }
                parents.add(class_2960.method_60654((String)parent));
            }
            if (!parents.isEmpty()) {
                model.field_4247 = parents.get(0);
            }
        }
        ArrayList<BaseModelElement> elements = new ArrayList<BaseModelElement>(model.field_4245.size());
        model.field_4245.forEach(element -> elements.add(new BaseModelElement(element.field_4228, element.field_4231, element.field_4230, element.field_4232, element.field_4229, element.field_53159)));
        return new BaseModelDataImpl(model, parents, elements);
    }

    @Override
    public JsonObject serialize(BaseModelData value) {
        JsonObject json = DefaultModelTypes.VANILLA.serialize(value.getVanillaModel());
        if (value.getParents().size() > 1) {
            json.remove("parent");
            JsonArray parents = new JsonArray(value.getParents().size());
            value.getParents().forEach(p -> parents.add(p.toString()));
            json.add("parents", (JsonElement)parents);
        }
        return json;
    }
}

