/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.base;

import com.google.common.collect.ImmutableList;
import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.api.model.DefaultModelTypes;
import com.supermartijn642.fusion.api.model.GatherTexturesContext;
import com.supermartijn642.fusion.api.model.ModelBakingContext;
import com.supermartijn642.fusion.api.model.ModelInstance;
import com.supermartijn642.fusion.api.model.SpriteIdentifier;
import com.supermartijn642.fusion.api.model.data.BaseModelData;
import com.supermartijn642.fusion.model.types.base.BaseModelElement;
import com.supermartijn642.fusion.model.types.base.BaseModelQuad;
import com.supermartijn642.fusion.util.IdentifierUtil;
import com.supermartijn642.fusion.util.TextureAtlases;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.FaceBakery;
import net.minecraft.client.renderer.model.ItemModelGenerator;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.ISprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.BasicState;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;

public class BaseModelDataImpl
implements BaseModelData {
    protected static final FaceBakery FACE_BAKERY = new FaceBakery();
    protected final BlockModel model;
    protected final List<ResourceLocation> parents;
    protected final List<BaseModelElement> elements;

    public BaseModelDataImpl(BlockModel model, List<ResourceLocation> parents, List<BaseModelElement> elements) {
        this.model = model;
        this.parents = ImmutableList.copyOf(parents);
        this.elements = ImmutableList.copyOf(elements);
    }

    @Override
    public BlockModel getVanillaModel() {
        return this.model;
    }

    @Override
    public List<ResourceLocation> getParents() {
        return this.parents;
    }

    public List<? extends BaseModelElement> getElements() {
        return this.elements;
    }

    public void validateParents(Function<ResourceLocation, ModelInstance<?>> modelResolver, ResourceLocation rootModel) {
        ArrayList<ResourceLocation> encounteredModels = new ArrayList<ResourceLocation>();
        for (ResourceLocation parent : this.parents) {
            this.validateParents(modelResolver, parent, encounteredModels, rootModel);
        }
    }

    private void validateParents(Function<ResourceLocation, ModelInstance<?>> modelResolver, ResourceLocation modelLocation, List<ResourceLocation> encounteredModels, ResourceLocation rootModel) {
        if (encounteredModels.contains(modelLocation)) {
            throw new IllegalStateException("Unable to bake model '" + rootModel + "' due to circular dependency " + encounteredModels.stream().map(o -> "'" + o + "'").collect(Collectors.joining("->")) + "->'" + modelLocation + "'!");
        }
        encounteredModels.add(modelLocation);
        ModelInstance<?> model = modelResolver.apply(modelLocation);
        if (model != null) {
            for (ResourceLocation dependency : model.getParentModels()) {
                this.validateParents(modelResolver, dependency, encounteredModels, rootModel);
            }
        }
        encounteredModels.remove(encounteredModels.size() - 1);
    }

    public <T> T findProperty(ModelBakingContext context, Function<BlockModel, T> property, T defaultValue) {
        T value = this.findProperty(context::getModel, ModelInstance.of(DefaultModelTypes.BASE, this), property);
        return value == null ? defaultValue : value;
    }

    private <T> T findProperty(Function<ResourceLocation, ModelInstance<?>> modelResolver, ModelInstance<?> model, Function<BlockModel, T> property) {
        T value;
        BlockModel vanillaModel = model.getAsVanillaModel();
        if (vanillaModel != null && (value = property.apply(vanillaModel)) != null) {
            return value;
        }
        for (ResourceLocation location : model.getParentModels()) {
            T childValue;
            ModelInstance<?> dependency = modelResolver.apply(location);
            if (dependency == null || (childValue = this.findProperty(modelResolver, dependency, property)) == null) continue;
            return childValue;
        }
        return null;
    }

    public SpriteIdentifier findParticleSprite(ModelBakingContext context) {
        ModelInstance<BaseModelDataImpl> model = ModelInstance.of(DefaultModelTypes.BASE, this);
        ArrayList<String> encounteredKeys = new ArrayList<String>();
        encounteredKeys.add("particle");
        String currentKey = "particle";
        while (true) {
            String finalCurrentKey = currentKey;
            String value = this.findProperty(context::getModel, model, m -> (String)m.field_178318_c.get(finalCurrentKey));
            if (value == null) {
                return SpriteIdentifier.missing();
            }
            if (!value.isEmpty() && value.charAt(0) != '#' && IdentifierUtil.isValidIdentifier(value)) {
                return SpriteIdentifier.of(TextureAtlases.getBlocks(), new ResourceLocation(value));
            }
            String string = currentKey = value.charAt(0) == '#' ? value.substring(1) : value;
            if (encounteredKeys.contains(currentKey)) {
                FusionClient.LOGGER.warn("Unable to resolve texture due to circular references {}->'{}' in '{}'!", (Object)encounteredKeys.stream().map(o -> "'" + o + "'").collect(Collectors.joining("->")), (Object)currentKey, (Object)context.getModelIdentifier());
                return SpriteIdentifier.missing();
            }
            encounteredKeys.add(currentKey);
        }
    }

    public List<BaseModelQuad> bakeQuads(ModelBakingContext context) {
        ArrayList<BaseModelQuad> quads = new ArrayList<BaseModelQuad>();
        this.bakeQuads(context, ModelInstance.of(DefaultModelTypes.BASE, this), new LinkedList(), quads::add);
        return quads;
    }

    private void bakeQuads(ModelBakingContext context, ModelInstance<?> model, Deque<ModelInstance<?>> modelStack, Consumer<BaseModelQuad> output) {
        modelStack.addLast(model);
        List<BlockPart> elements = null;
        if (model.getModelType() == DefaultModelTypes.BASE || model.getModelType() == DefaultModelTypes.CONNECTING) {
            elements = ((BaseModelDataImpl)model.getModelData()).elements;
        } else {
            BlockModel vanillaModel = model.getAsVanillaModel();
            if (vanillaModel != null) {
                elements = vanillaModel == ModelBakery.field_177606_o ? this.generateItemModel(context, modelStack) : vanillaModel.field_178314_g;
            }
        }
        if (elements != null && !elements.isEmpty()) {
            for (BlockPart element : elements) {
                for (Direction direction : element.field_178240_c.keySet()) {
                    BlockPartFace face = (BlockPartFace)element.field_178240_c.get(direction);
                    TextureAtlasSprite sprite = context.getTexture(this.resolveMaterial(context::getModel, modelStack, face.field_178242_d, context.getModelIdentifier()));
                    BakedQuad quad = FACE_BAKERY.func_217648_a(element.field_178241_a, element.field_178239_b, face, sprite, direction, (ISprite)new BasicState((IModelState)context.getTransformation().getState().apply(Optional.empty()).orElse(TRSRTransformation.identity()), context.getTransformation().func_188049_c()), element.field_178237_d, element.field_178238_e);
                    Direction cullDirection = face.field_178244_b == null ? null : context.getTransformation().getState().apply(Optional.empty()).map(t -> t.rotateTransform(face.field_178244_b)).orElse(face.field_178244_b);
                    Integer lightEmission = element instanceof BaseModelElement ? ((BaseModelElement)element).light_emission : null;
                    output.accept(new BaseModelQuad(quad, cullDirection, lightEmission));
                }
            }
            modelStack.pop();
            return;
        }
        for (ResourceLocation location : model.getParentModels()) {
            ModelInstance<?> dependency = context.getModel(location);
            if (dependency == null) continue;
            this.bakeQuads(context, dependency, modelStack, output);
        }
        modelStack.removeLast();
    }

    public Set<SpriteIdentifier> gatherTextures(GatherTexturesContext context) {
        HashSet<SpriteIdentifier> textures = new HashSet<SpriteIdentifier>();
        this.gatherTextures(context, ModelInstance.of(DefaultModelTypes.BASE, this), new LinkedList(), textures::add);
        return textures;
    }

    private void gatherTextures(GatherTexturesContext context, ModelInstance<?> model, Deque<ModelInstance<?>> modelStack, Consumer<SpriteIdentifier> output) {
        modelStack.addLast(model);
        List elements = null;
        if (model.getModelType() == DefaultModelTypes.BASE || model.getModelType() == DefaultModelTypes.CONNECTING) {
            elements = ((BaseModelDataImpl)model.getModelData()).elements;
        } else {
            BlockModel vanillaModel = model.getAsVanillaModel();
            if (vanillaModel != null) {
                elements = vanillaModel.field_178314_g;
            }
        }
        if (elements != null && !elements.isEmpty()) {
            for (BlockPart element : elements) {
                for (Direction direction : element.field_178240_c.keySet()) {
                    BlockPartFace face = (BlockPartFace)element.field_178240_c.get(direction);
                    SpriteIdentifier sprite = this.resolveMaterial(context::getModel, modelStack, face.field_178242_d, null);
                    if (sprite.equals(SpriteIdentifier.missing())) continue;
                    output.accept(sprite);
                }
            }
            modelStack.pop();
            return;
        }
        for (ResourceLocation location : model.getParentModels()) {
            ModelInstance<?> dependency = context.getModel(location);
            if (dependency == null) continue;
            this.gatherTextures(context, dependency, modelStack, output);
        }
        modelStack.removeLast();
    }

    protected SpriteIdentifier resolveMaterial(Function<ResourceLocation, ModelInstance<?>> modelResolver, Deque<ModelInstance<?>> modelStack, String key, ResourceLocation rootModel) {
        if (key.charAt(0) == '#') {
            key = key.substring(1);
        }
        ArrayList<String> encounteredKeys = new ArrayList<String>();
        encounteredKeys.add(key);
        String currentKey = key;
        while (true) {
            String value = null;
            for (ModelInstance<?> model2 : modelStack) {
                BlockModel vanillaModel = model2.getAsVanillaModel();
                if (vanillaModel == null) continue;
                if (vanillaModel == ModelBakery.field_177606_o && currentKey.equals("particle")) {
                    value = "#layer0";
                    break;
                }
                value = (String)vanillaModel.field_178318_c.get(currentKey);
                if (value == null) continue;
                break;
            }
            if (value == null) {
                String finalCurrentKey = currentKey;
                value = this.findProperty(modelResolver, modelStack.getLast(), model -> {
                    if (model == ModelBakery.field_177606_o && finalCurrentKey.equals("particle")) {
                        return "#layer0";
                    }
                    return (String)model.field_178318_c.get(finalCurrentKey);
                });
            }
            if (value == null) {
                return SpriteIdentifier.missing();
            }
            if (!value.isEmpty() && value.charAt(0) != '#' && IdentifierUtil.isValidIdentifier(value)) {
                return SpriteIdentifier.of(TextureAtlases.getBlocks(), new ResourceLocation(value));
            }
            String string = currentKey = value.charAt(0) == '#' ? value.substring(1) : value;
            if (encounteredKeys.contains(currentKey)) {
                FusionClient.LOGGER.warn("Unable to resolve texture due to circular references {}->'{}' in '{}'!", (Object)encounteredKeys.stream().map(o -> "'" + o + "'").collect(Collectors.joining("->")), (Object)currentKey, (Object)rootModel);
                return SpriteIdentifier.missing();
            }
            encounteredKeys.add(currentKey);
        }
    }

    protected List<BlockPart> generateItemModel(ModelBakingContext context, Deque<ModelInstance<?>> modelStack) {
        ArrayList<BlockPart> elements = new ArrayList<BlockPart>();
        for (int layer = 0; layer < ItemModelGenerator.field_178398_a.size(); ++layer) {
            String layerName = (String)ItemModelGenerator.field_178398_a.get(layer);
            SpriteIdentifier sprite = this.resolveMaterial(context::getModel, modelStack, layerName, context.getModelIdentifier());
            if (SpriteIdentifier.missing().equals(sprite)) break;
            TextureAtlasSprite texture = context.getTexture(sprite);
            elements.addAll(ModelBakery.field_217854_z.func_178394_a(layer, layerName, texture));
        }
        return elements;
    }
}

