/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.vanilla;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.model.GatherTexturesContext;
import com.supermartijn642.fusion.api.model.ModelBakingContext;
import com.supermartijn642.fusion.api.model.ModelInstance;
import com.supermartijn642.fusion.api.model.ModelType;
import com.supermartijn642.fusion.api.model.SpriteIdentifier;
import com.supermartijn642.fusion.model.types.vanilla.VanillaModelSerializer;
import com.supermartijn642.fusion.util.TextureAtlases;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoaderRegistry2;

public class VanillaModelType
implements ModelType<BlockModel> {
    @Override
    public Collection<ResourceLocation> getModelDependencies(BlockModel data) {
        return data.func_187965_e();
    }

    @Override
    public Collection<SpriteIdentifier> getTextureDependencies(GatherTexturesContext context, BlockModel data) {
        VanillaModelType.resolveParents(context, data);
        Collection materials = data.func_209559_a(location -> context.getModel((ResourceLocation)location).getAsVanillaModel(), new HashSet());
        return materials.stream().map(t -> SpriteIdentifier.of(TextureAtlases.getBlocks(), t)).collect(Collectors.toList());
    }

    @Override
    public IBakedModel bake(ModelBakingContext context, BlockModel data) {
        return data.func_217641_a(context.getModelBakery(), material -> context.getTexture(SpriteIdentifier.of(TextureAtlases.getBlocks(), material)), context.getTransformation());
    }

    @Override
    @Nullable
    public BlockModel getAsVanillaModel(BlockModel data) {
        return data;
    }

    @Override
    public BlockModel deserialize(JsonObject json) throws JsonParseException {
        return (BlockModel)ModelLoaderRegistry2.ExpandedBlockModelDeserializer.INSTANCE.fromJson((JsonElement)json, BlockModel.class);
    }

    @Override
    public JsonObject serialize(BlockModel value) {
        return (JsonObject)VanillaModelSerializer.GSON.toJsonTree((Object)value);
    }

    private static void resolveParents(GatherTexturesContext context, BlockModel model) {
        LinkedHashSet<BlockModel> passedModels = new LinkedHashSet<BlockModel>();
        while (model.field_178316_e != null && model.field_178315_d == null) {
            passedModels.add(model);
            ModelInstance<?> modelInstance = context.getModel(model.field_178316_e);
            if (modelInstance == null) {
                return;
            }
            BlockModel parent = modelInstance.getAsVanillaModel();
            if (parent == null) {
                BlockModel.field_178313_f.warn("Vanilla model {} cannot have parent with model type {} for {}!", (Object)model, modelInstance.getModelType(), (Object)model.field_178316_e);
            }
            if (passedModels.contains(parent)) {
                BlockModel.field_178313_f.warn("Found 'parent' loop while loading model '{}' in chain: {} -> {}", (Object)model, (Object)passedModels.stream().map(Object::toString).collect(Collectors.joining(" -> ")), (Object)model.field_178316_e);
                parent = null;
            }
            if (parent == null) {
                model.field_178316_e = ModelBakery.field_177604_a;
                parent = context.getModel(model.field_178316_e).getAsVanillaModel();
                if (parent == null) {
                    throw new RuntimeException("Got null for missing model request!");
                }
            }
            model.field_178315_d = parent;
            model = parent;
        }
    }
}

