/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin;

import com.google.common.collect.Sets;
import com.supermartijn642.fusion.extensions.PackResourcesExtension;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.resources.FolderPack;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FolderPack.class})
public class FolderPackResourcesMixin
implements PackResourcesExtension {
    @Unique
    private File overridesFolder;

    @Override
    public void setFusionOverridesFolder(@Nonnull String folder) {
        this.overridesFolder = new File(((FolderPack)this).field_195771_a, folder);
    }

    @Shadow
    private void func_199546_a(File folder, int depth, String namespace, List<ResourceLocation> locations, String folderPath, Predicate<String> namePredicate) {
        throw new AssertionError();
    }

    @Inject(method={"getFile"}, at={@At(value="HEAD")}, cancellable=true)
    private void getFile(String path, CallbackInfoReturnable<File> ci) {
        if (this.overridesFolder == null) {
            return;
        }
        try {
            File file = new File(this.overridesFolder, path);
            if (file.isFile() && FolderPack.func_195777_a((File)file, (String)path)) {
                ci.setReturnValue((Object)file);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Inject(method={"getNamespaces"}, at={@At(value="RETURN")}, cancellable=true)
    private void getNamespaces(ResourcePackType type, CallbackInfoReturnable<Set<String>> ci) {
        if (this.overridesFolder == null) {
            return;
        }
        HashSet namespaces = Sets.newHashSet((Iterable)((Iterable)ci.getReturnValue()));
        File typeFolder = new File(this.overridesFolder, type.func_198956_a());
        File[] folders = typeFolder.listFiles((FileFilter)DirectoryFileFilter.DIRECTORY);
        if (folders == null) {
            return;
        }
        for (File folder : folders) {
            String relativePath = FolderPack.func_195767_a((File)typeFolder, (File)folder);
            if (relativePath.equals(relativePath.toLowerCase(Locale.ROOT))) {
                namespaces.add(relativePath.substring(0, relativePath.length() - 1));
                continue;
            }
            ((FolderPack)this).func_195769_d(relativePath);
        }
        ci.setReturnValue((Object)namespaces);
    }

    @Inject(method={"getResources"}, at={@At(value="RETURN")}, cancellable=true)
    private void getResources(ResourcePackType type, String folderName, int depth, Predicate<String> predicate, CallbackInfoReturnable<Collection<ResourceLocation>> ci) {
        if (this.overridesFolder == null) {
            return;
        }
        if (ci.getReturnValue() == null) {
            return;
        }
        List locations = ci.getReturnValue() instanceof ArrayList ? (List)ci.getReturnValue() : new ArrayList((Collection)ci.getReturnValue());
        HashSet locationSet = new HashSet(locations);
        ArrayList<ResourceLocation> newLocations = new ArrayList<ResourceLocation>();
        File typeFolder = new File(this.overridesFolder, type.func_198956_a());
        for (String namespace : ((FolderPack)this).func_195759_a(type)) {
            File folder = new File(new File(typeFolder, namespace), folderName);
            this.func_199546_a(folder, depth, namespace, newLocations, folderName + "/", predicate);
        }
        newLocations.stream().filter(l -> !locationSet.contains(l)).forEach(locations::add);
        ci.setReturnValue(locations);
    }
}

