/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.supermartijn642.fusion.model.types.base.CustomRenderTypeBakedModel;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.MultipartBakedModel;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraftforge.client.extensions.IForgeBakedModel;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MultipartBakedModel.class}, priority=900)
public class MultiPartBakedModelMixin
implements IForgeBakedModel,
CustomRenderTypeBakedModel {
    @Unique
    private static final ModelProperty<Map<IBakedModel, IModelData>> SUB_MODEL_DATA = new ModelProperty();
    @Final
    @Shadow
    private List<Pair<Predicate<BlockState>, IBakedModel>> field_188626_f;
    @Final
    @Shadow
    private Map<BlockState, BitSet> field_210277_g;
    @Unique
    private Set<BlockRenderLayer> customBlockRenderTypes;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void init(List<Pair<Predicate<BlockState>, IBakedModel>> models, CallbackInfo ci) {
        HashSet<BlockRenderLayer> customBlockRenderTypes = null;
        for (Pair<Predicate<BlockState>, IBakedModel> model : models) {
            Collection<BlockRenderLayer> renderTypes;
            if (!(model.getRight() instanceof CustomRenderTypeBakedModel) || (renderTypes = ((CustomRenderTypeBakedModel)model.getRight()).getBlockRenderTypes()).isEmpty()) continue;
            if (customBlockRenderTypes == null) {
                customBlockRenderTypes = new HashSet<BlockRenderLayer>();
            }
            customBlockRenderTypes.addAll(renderTypes);
        }
        this.customBlockRenderTypes = customBlockRenderTypes == null ? Collections.emptySet() : ImmutableSet.copyOf(customBlockRenderTypes);
    }

    @Nonnull
    public IModelData getModelData(@Nonnull IEnviromentBlockReader level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData modelData) {
        if (state == null) {
            return super.getModelData(level, pos, state, modelData);
        }
        BitSet bitSet = this.field_210277_g.get(state);
        if (bitSet == null) {
            bitSet = new BitSet();
            for (int i = 0; i < this.field_188626_f.size(); ++i) {
                Pair<Predicate<BlockState>, IBakedModel> pair = this.field_188626_f.get(i);
                if (!((Predicate)pair.getLeft()).test(state)) continue;
                bitSet.set(i);
            }
            this.field_210277_g.put(state, bitSet);
        }
        Map subModelData = IntStream.range(0, this.field_188626_f.size()).filter(bitSet::get).mapToObj(this.field_188626_f::get).map(Pair::getRight).collect(Collectors.toMap(Function.identity(), model -> model.getModelData(level, pos, state, modelData), (first, second) -> first));
        ModelDataMap.Builder builder = new ModelDataMap.Builder();
        builder.withInitial(SUB_MODEL_DATA, subModelData);
        return builder.build();
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random random, @Nonnull IModelData modelData) {
        if (state == null) {
            return Collections.emptyList();
        }
        BitSet bitSet = this.field_210277_g.get(state);
        if (bitSet == null) {
            bitSet = new BitSet();
            for (int i = 0; i < this.field_188626_f.size(); ++i) {
                Pair<Predicate<BlockState>, IBakedModel> pair = this.field_188626_f.get(i);
                if (!((Predicate)pair.getLeft()).test(state)) continue;
                bitSet.set(i);
            }
            this.field_210277_g.put(state, bitSet);
        }
        ArrayList list = Lists.newArrayList();
        long seed = random.nextLong();
        Map subModelData = modelData.hasProperty(SUB_MODEL_DATA) ? (Map)modelData.getData(SUB_MODEL_DATA) : Collections.emptyMap();
        for (int j = 0; j < bitSet.length(); ++j) {
            if (!bitSet.get(j)) continue;
            IBakedModel model = (IBakedModel)this.field_188626_f.get(j).getRight();
            IModelData data = (IModelData)subModelData.get(model);
            list.addAll(model.getQuads(state, side, new Random(seed), (IModelData)(data == null ? EmptyModelData.INSTANCE : data)));
        }
        return list;
    }

    @Override
    public Collection<BlockRenderLayer> getBlockRenderTypes() {
        return this.customBlockRenderTypes;
    }
}

