/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin;

import com.supermartijn642.fusion.extensions.PackExtension;
import com.supermartijn642.fusion.resources.FusionPackMetadata;
import com.supermartijn642.fusion.resources.ResourcePackListTipRenderer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.ResourcePacksScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.list.AbstractResourcePackList;
import net.minecraft.client.resources.ClientResourcePackInfo;
import net.minecraft.util.text.ITextComponent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractResourcePackList.ResourcePackEntry.class})
public class PackEntryMixin {
    @Final
    @Shadow
    private ClientResourcePackInfo field_214431_d;
    @Final
    @Shadow
    private ResourcePacksScreen field_214429_b;
    @Unique
    private FusionPackMetadata metadata;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void cacheFusionMetadata(CallbackInfo ci) {
        this.metadata = ((PackExtension)this.field_214431_d).getFusionMetadata();
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/AbstractGui;blit(IIFFIIII)V", shift=At.Shift.BEFORE, ordinal=0)})
    private void renderBackground(int entryIndex, int top, int left, int width, int height, int mouseX, int mouseY, boolean isHovered, float partialTicks, CallbackInfo ci) {
        if (this.metadata == null) {
            return;
        }
        ResourcePackListTipRenderer.renderBackground(this.metadata, this.field_214431_d.func_195791_d().func_198968_a(), left, top, width, height);
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/AbstractGui;blit(IIFFIIII)V", shift=At.Shift.AFTER, ordinal=0)})
    private void renderIcon(int entryIndex, int top, int left, int width, int height, int mouseX, int mouseY, boolean isHovered, float partialTicks, CallbackInfo ci) {
        if (this.metadata == null) {
            return;
        }
        ResourcePackListTipRenderer.renderIcon(this.metadata, this.field_214431_d.func_195791_d().func_198968_a(), left, top, width, height);
    }

    @ModifyVariable(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/widget/list/AbstractResourcePackList$ResourcePackEntry;canMoveRight()Z", shift=At.Shift.BEFORE), ordinal=1)
    private String adjustDescription(String label) {
        if (this.metadata == null) {
            return label;
        }
        ITextComponent warningMessage = ResourcePackListTipRenderer.getWarningMessage(this.metadata, this.field_214431_d.func_195791_d().func_198968_a());
        return warningMessage == null ? label : warningMessage.func_150254_d();
    }

    @Inject(method={"mouseClicked"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/widget/list/AbstractResourcePackList$ResourcePackEntry;getCompatibility()Lnet/minecraft/resources/PackCompatibility;", shift=At.Shift.BEFORE)}, cancellable=true)
    private void showFusionWarningScreen(CallbackInfoReturnable<Boolean> ci) {
        if (this.metadata == null) {
            return;
        }
        Consumer<Boolean> callback = select -> {
            Minecraft.func_71410_x().func_147108_a((Screen)this.field_214429_b);
            if (select.booleanValue()) {
                this.field_214429_b.func_214300_a((AbstractResourcePackList.ResourcePackEntry)this);
            }
        };
        if (ResourcePackListTipRenderer.showWarningScreen(this.metadata, this.field_214431_d.func_195791_d().func_198968_a(), this.field_214431_d, callback)) {
            ci.setReturnValue((Object)false);
        }
    }
}

