/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.modifiers.block;

import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.model.MutableQuad;
import com.supermartijn642.fusion.model.WrappedBakedModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;

public class PaneCullingBakedModel
extends WrappedBakedModel {
    private static final ModelProperty<Pair<BlockState, BlockState>> NEIGHBOR_PROPERTY = new ModelProperty();
    private static final BooleanProperty[] SIDE_PROPERTIES = new BooleanProperty[]{null, null, BlockStateProperties.field_208151_D, BlockStateProperties.field_208153_F, BlockStateProperties.field_208154_G, BlockStateProperties.field_208152_E};
    private final MutableQuad helperMutableQuad = new MutableQuad();

    public PaneCullingBakedModel(IBakedModel original) {
        super(original);
    }

    @Override
    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction cullDirection, @Nonnull Random random, @Nonnull IModelData data) {
        BlockState stateBelow;
        if (state == null) {
            return super.getQuads(null, cullDirection, random, data);
        }
        if (!(state.func_196959_b((IProperty)BlockStateProperties.field_208151_D) || state.func_196959_b((IProperty)BlockStateProperties.field_208153_F) || state.func_196959_b((IProperty)BlockStateProperties.field_208154_G) || state.func_196959_b((IProperty)BlockStateProperties.field_208152_E))) {
            return super.getQuads(state, cullDirection, random, data);
        }
        Pair neighbors = (Pair)data.getData(NEIGHBOR_PROPERTY);
        if (neighbors == null) {
            return super.getQuads(state, cullDirection, random, data);
        }
        BlockState stateAbove = (BlockState)neighbors.left();
        if (stateAbove.func_177230_c() != state.func_177230_c()) {
            stateAbove = null;
        }
        if ((stateBelow = (BlockState)neighbors.right()).func_177230_c() != state.func_177230_c()) {
            stateBelow = null;
        }
        if (stateAbove == null && stateBelow == null) {
            return super.getQuads(state, cullDirection, random, data);
        }
        List<BakedQuad> quads = super.getQuads(state, cullDirection, random, data);
        ArrayList<BakedQuad> culledQuads = new ArrayList<BakedQuad>(quads.size());
        for (BakedQuad quad : quads) {
            if (!this.filterQuad(quad, stateAbove, stateBelow)) continue;
            culledQuads.add(quad);
        }
        return culledQuads;
    }

    @Override
    public IModelData getModelData(IEnviromentBlockReader level, BlockPos pos, BlockState state, IModelData data) {
        if (!(data = super.getModelData(level, pos, state, data)).getClass().equals(ModelDataMap.class)) {
            return new ModelDataMap.Builder().withInitial(NEIGHBOR_PROPERTY, Pair.of(level.func_180495_p(pos.func_177984_a()), level.func_180495_p(pos.func_177977_b()))).build();
        }
        data.setData(NEIGHBOR_PROPERTY, Pair.of(level.func_180495_p(pos.func_177984_a()), level.func_180495_p(pos.func_177977_b())));
        return data;
    }

    private boolean filterQuad(BakedQuad bakedQuad, BlockState stateAbove, BlockState stateBelow) {
        Direction quadDirection = bakedQuad.func_178210_d();
        if (quadDirection != Direction.UP && quadDirection != Direction.DOWN) {
            return true;
        }
        MutableQuad quad = this.helperMutableQuad;
        quad.fillFromBakedQuad(bakedQuad);
        float centerX = (quad.x(0) + quad.x(1) + quad.x(2) + quad.x(3)) / 4.0f;
        float centerZ = (quad.z(0) + quad.z(1) + quad.z(2) + quad.z(3)) / 4.0f;
        double quadDistance = Math.sqrt(((double)centerX - 0.5) * ((double)centerX - 0.5) + ((double)centerZ - 0.5) * ((double)centerZ - 0.5));
        if (quadDistance < 0.1) {
            return quadDirection == Direction.UP ? stateAbove == null : stateBelow == null;
        }
        Direction partSide = Direction.func_210769_a((double)((double)centerX - 0.5), (double)0.0, (double)((double)centerZ - 0.5));
        return quadDirection == Direction.UP ? stateAbove == null || !((Boolean)stateAbove.func_177229_b((IProperty)SIDE_PROPERTIES[partSide.ordinal()])).booleanValue() : stateBelow == null || (Boolean)stateBelow.func_177229_b((IProperty)SIDE_PROPERTIES[partSide.ordinal()]) == false;
    }
}

