/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.base;

import com.supermartijn642.fusion.api.model.data.BaseModelData;
import com.supermartijn642.fusion.api.model.data.BaseModelDataBuilder;
import com.supermartijn642.fusion.model.types.base.BaseModelDataImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.util.ResourceLocation;

public class BaseModelDataBuilderImpl
implements BaseModelDataBuilder<BaseModelDataBuilderImpl, BaseModelData> {
    private final Set<ResourceLocation> parents = new LinkedHashSet<ResourceLocation>();
    private final Map<String, String> textures = new HashMap<String, String>();

    @Override
    public BaseModelDataBuilderImpl parent(ResourceLocation parent) {
        return this.parents(parent);
    }

    @Override
    public BaseModelDataBuilderImpl parents(ResourceLocation ... parents) {
        this.parents.addAll(Arrays.asList(parents));
        return this;
    }

    @Override
    public BaseModelDataBuilderImpl texture(String key, String reference) {
        if (!key.matches("[a-zA-Z_]*")) {
            throw new IllegalArgumentException("Texture reference must only contain characters [a-zA-Z_]!");
        }
        if (reference.charAt(0) != '#') {
            reference = '#' + reference;
        }
        if (this.textures.containsKey(key)) {
            throw new RuntimeException("Duplicate texture entry for key '" + key + "': '" + this.textures.get(key) + "' and '" + reference + "'!");
        }
        this.textures.put(key, reference);
        return this;
    }

    @Override
    public BaseModelDataBuilderImpl texture(String key, ResourceLocation texture) {
        if (!key.matches("[a-zA-Z_]*")) {
            throw new IllegalArgumentException("Texture reference must only contain characters [a-zA-Z_]!");
        }
        if (this.textures.containsKey(key)) {
            throw new RuntimeException("Duplicate texture entry for key '" + key + "': '" + this.textures.get(key) + "' and '" + texture + "'!");
        }
        this.textures.put(key, texture.toString());
        return this;
    }

    @Override
    public BaseModelData build() {
        ArrayList<ResourceLocation> parents = new ArrayList<ResourceLocation>(this.parents);
        ResourceLocation parent = parents.isEmpty() ? null : (ResourceLocation)parents.get(0);
        BlockModel vanillaModel = new BlockModel(parent, Collections.emptyList(), this.textures, true, true, ItemCameraTransforms.field_178357_a, Collections.emptyList());
        return new BaseModelDataImpl(vanillaModel, parents, Collections.emptyList());
    }
}

