/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.connecting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.model.DefaultModelTypes;
import com.supermartijn642.fusion.api.model.GatherTexturesContext;
import com.supermartijn642.fusion.api.model.ModelBakingContext;
import com.supermartijn642.fusion.api.model.ModelType;
import com.supermartijn642.fusion.api.model.SpriteIdentifier;
import com.supermartijn642.fusion.api.model.data.BaseModelData;
import com.supermartijn642.fusion.api.model.data.ConnectingModelData;
import com.supermartijn642.fusion.api.predicate.ConnectionPredicate;
import com.supermartijn642.fusion.api.predicate.DefaultConnectionPredicates;
import com.supermartijn642.fusion.api.predicate.FusionPredicateRegistry;
import com.supermartijn642.fusion.model.types.base.BaseModelDataImpl;
import com.supermartijn642.fusion.model.types.base.BaseModelElement;
import com.supermartijn642.fusion.model.types.base.BaseModelQuad;
import com.supermartijn642.fusion.model.types.connecting.ConnectingBakedModel;
import com.supermartijn642.fusion.model.types.connecting.ConnectingModelDataImpl;
import com.supermartijn642.fusion.model.types.connecting.ConnectingModelElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ItemTransformVec3f;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;

public class ConnectingModelType
implements ModelType<ConnectingModelData> {
    public static final String DEFAULT_CONNECTION_KEY = "default";

    @Override
    public Collection<ResourceLocation> getModelDependencies(ConnectingModelData data) {
        return DefaultModelTypes.BASE.getModelDependencies(data);
    }

    @Override
    public Collection<SpriteIdentifier> getTextureDependencies(GatherTexturesContext context, ConnectingModelData data) {
        return DefaultModelTypes.BASE.getTextureDependencies(context, data);
    }

    @Override
    @Nullable
    public BlockModel getAsVanillaModel(ConnectingModelData data) {
        return DefaultModelTypes.BASE.getAsVanillaModel(data);
    }

    @Override
    public List<ResourceLocation> getParentModels(ConnectingModelData data) {
        return data.getParents();
    }

    @Override
    public IBakedModel bake(ModelBakingContext context, ConnectingModelData data) {
        ((ConnectingModelDataImpl)data).validateParents(context::getModel, context.getModelIdentifier());
        List<BaseModelQuad> quads = ((ConnectingModelDataImpl)data).bakeQuads(context);
        boolean ambientOcclusion = ((ConnectingModelDataImpl)data).findProperty(context, model -> model.field_178322_i, true);
        boolean gui3d = data.getVanillaModel().func_178311_c();
        TextureAtlasSprite particleSprite = context.getTexture(((ConnectingModelDataImpl)data).findParticleSprite(context));
        ItemTransformVec3f transformThirdPersonLeftHand = ((ConnectingModelDataImpl)data).findProperty(context, model -> model.field_178320_j.func_181687_c(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND) ? model.field_178320_j.func_181688_b(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND) : null, ItemTransformVec3f.field_178366_a);
        ItemTransformVec3f transformThirdPersonRightHand = ((ConnectingModelDataImpl)data).findProperty(context, model -> model.field_178320_j.func_181687_c(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND) ? model.field_178320_j.func_181688_b(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND) : null, ItemTransformVec3f.field_178366_a);
        ItemTransformVec3f transformFirstPersonLeftHand = ((ConnectingModelDataImpl)data).findProperty(context, model -> model.field_178320_j.func_181687_c(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND) ? model.field_178320_j.func_181688_b(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND) : null, ItemTransformVec3f.field_178366_a);
        ItemTransformVec3f transformFirstPersonRightHand = ((ConnectingModelDataImpl)data).findProperty(context, model -> model.field_178320_j.func_181687_c(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND) ? model.field_178320_j.func_181688_b(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND) : null, ItemTransformVec3f.field_178366_a);
        ItemTransformVec3f transformHead = ((ConnectingModelDataImpl)data).findProperty(context, model -> model.field_178320_j.func_181687_c(ItemCameraTransforms.TransformType.HEAD) ? model.field_178320_j.func_181688_b(ItemCameraTransforms.TransformType.HEAD) : null, ItemTransformVec3f.field_178366_a);
        ItemTransformVec3f transformGui = ((ConnectingModelDataImpl)data).findProperty(context, model -> model.field_178320_j.func_181687_c(ItemCameraTransforms.TransformType.GUI) ? model.field_178320_j.func_181688_b(ItemCameraTransforms.TransformType.GUI) : null, ItemTransformVec3f.field_178366_a);
        ItemTransformVec3f transformGround = ((ConnectingModelDataImpl)data).findProperty(context, model -> model.field_178320_j.func_181687_c(ItemCameraTransforms.TransformType.GROUND) ? model.field_178320_j.func_181688_b(ItemCameraTransforms.TransformType.GROUND) : null, ItemTransformVec3f.field_178366_a);
        ItemTransformVec3f transformFixed = ((ConnectingModelDataImpl)data).findProperty(context, model -> model.field_178320_j.func_181687_c(ItemCameraTransforms.TransformType.FIXED) ? model.field_178320_j.func_181688_b(ItemCameraTransforms.TransformType.FIXED) : null, ItemTransformVec3f.field_178366_a);
        ItemCameraTransforms itemTransforms = new ItemCameraTransforms(transformThirdPersonLeftHand, transformThirdPersonRightHand, transformFirstPersonLeftHand, transformFirstPersonRightHand, transformHead, transformGui, transformGround, transformFixed);
        ItemOverrideList itemOverrides = data.getVanillaModel().field_187968_k.isEmpty() ? ItemOverrideList.field_188022_a : new ItemOverrideList(context.getModelBakery(), data.getVanillaModel(), i -> context.getModel((ResourceLocation)i).getAsVanillaModel(), data.getVanillaModel().field_187968_k);
        return new ConnectingBakedModel(quads, ambientOcclusion, gui3d, particleSprite, itemTransforms, itemOverrides);
    }

    @Override
    public ConnectingModelData deserialize(JsonObject json) throws JsonParseException {
        BaseModelData base = (BaseModelData)DefaultModelTypes.BASE.deserialize(json);
        HashMap<String, ConnectionPredicate> predicates = new HashMap<String, ConnectionPredicate>();
        HashMap<String, String> connectionReferences = new HashMap<String, String>();
        predicates.put(DEFAULT_CONNECTION_KEY, DefaultConnectionPredicates.isSameState());
        if (json.has("connections")) {
            JsonElement connectionsElement = json.get("connections");
            if (connectionsElement.isJsonArray() || connectionsElement.isJsonObject() && connectionsElement.getAsJsonObject().has("type")) {
                predicates.put(DEFAULT_CONNECTION_KEY, ConnectingModelType.loadPredicate(connectionsElement, "connections"));
            } else if (connectionsElement.isJsonObject()) {
                JsonObject object = connectionsElement.getAsJsonObject();
                if (object.size() == 0) {
                    throw new JsonParseException("Property 'connections' must have a 'type' key or keys per texture!");
                }
                for (Map.Entry texture : object.entrySet()) {
                    if (((JsonElement)texture.getValue()).isJsonPrimitive() && ((JsonElement)texture.getValue()).getAsJsonPrimitive().isString()) {
                        connectionReferences.put((String)texture.getKey(), ((JsonElement)texture.getValue()).getAsString());
                        continue;
                    }
                    predicates.put((String)texture.getKey(), ConnectingModelType.loadPredicate((JsonElement)texture.getValue(), (String)texture.getKey()));
                }
            } else {
                throw new JsonParseException("Property 'connections' must be an array!");
            }
        }
        ArrayList<ConnectingModelElement> elements = new ArrayList<ConnectingModelElement>(((BaseModelDataImpl)base).getElements().size());
        JsonArray elementsJson = json.getAsJsonArray("elements");
        for (int i = 0; i < ((BaseModelDataImpl)base).getElements().size(); ++i) {
            JsonObject elementFaces = elementsJson.get(i).getAsJsonObject().getAsJsonObject("faces");
            BaseModelElement baseElement = ((BaseModelDataImpl)base).getElements().get(i);
            EnumMap<Direction, String> connectionKeys = null;
            if (elementFaces != null) {
                for (Direction side : Direction.values()) {
                    if (!elementFaces.has(side.func_176742_j()) || !elementFaces.get(side.func_176742_j()).isJsonObject() || !elementFaces.getAsJsonObject(side.func_176742_j()).has("connections")) continue;
                    JsonElement connectionsJson = elementFaces.getAsJsonObject(side.func_176742_j()).get("connections");
                    if (!connectionsJson.isJsonPrimitive() || !connectionsJson.getAsJsonPrimitive().isString()) {
                        throw new JsonParseException("Face property 'connections' must be a string!");
                    }
                    String key = connectionsJson.getAsString();
                    if (key.isEmpty()) {
                        throw new JsonParseException("Face property 'connections' must not be empty!");
                    }
                    if (connectionKeys == null) {
                        connectionKeys = new EnumMap<Direction, String>(Direction.class);
                    }
                    connectionKeys.put(side, key);
                }
            }
            elements.add(new ConnectingModelElement(baseElement.field_178241_a, baseElement.field_178239_b, baseElement.field_178240_c, baseElement.field_178237_d, baseElement.field_178238_e, baseElement.light_emission, connectionKeys));
        }
        return new ConnectingModelDataImpl(base.getVanillaModel(), base.getParents(), elements, predicates, connectionReferences);
    }

    @Override
    public JsonObject serialize(ConnectingModelData value) {
        JsonObject json = DefaultModelTypes.BASE.serialize(value);
        Map<String, ConnectionPredicate> predicates = value.getAllConnectionPredicates();
        if (predicates.size() == 1 && predicates.containsKey(DEFAULT_CONNECTION_KEY)) {
            json.add("connections", (JsonElement)FusionPredicateRegistry.serializeConnectionPredicate(predicates.get(DEFAULT_CONNECTION_KEY)));
        } else if (!predicates.isEmpty()) {
            JsonObject connectionsJson = new JsonObject();
            predicates.forEach((texture, predicate) -> connectionsJson.add(texture, (JsonElement)FusionPredicateRegistry.serializeConnectionPredicate(predicate)));
            json.add("connections", (JsonElement)connectionsJson);
        }
        for (int i = 0; i < ((ConnectingModelDataImpl)value).getElements().size(); ++i) {
            JsonObject elementFaces;
            Map<Direction, String> connectionKeys = ((ConnectingModelDataImpl)value).getElements().get((int)i).faceConnectionKeys;
            if (connectionKeys.isEmpty() || (elementFaces = json.getAsJsonArray("elements").get(i).getAsJsonObject().getAsJsonObject("faces")) == null) continue;
            for (Direction side : connectionKeys.keySet()) {
                if (!elementFaces.has(side.func_176742_j())) continue;
                elementFaces.getAsJsonObject(side.func_176742_j()).addProperty("connections", connectionKeys.get(side));
            }
        }
        return json;
    }

    private static ConnectionPredicate loadPredicate(JsonElement element, String key) {
        if (element.isJsonArray()) {
            JsonArray array = element.getAsJsonArray();
            ArrayList<ConnectionPredicate> subPredicates = new ArrayList<ConnectionPredicate>();
            for (JsonElement predicateElements : array) {
                if (!predicateElements.isJsonObject()) {
                    throw new JsonParseException("Predicate '" + key + "' must only contain objects!");
                }
                ConnectionPredicate predicate = FusionPredicateRegistry.deserializeConnectionPredicate(predicateElements.getAsJsonObject());
                subPredicates.add(predicate);
            }
            return DefaultConnectionPredicates.or(subPredicates.toArray(new ConnectionPredicate[0]));
        }
        if (element.isJsonObject()) {
            return FusionPredicateRegistry.deserializeConnectionPredicate(element.getAsJsonObject());
        }
        throw new JsonParseException("Predicate '" + key + "' must be an object or an array!");
    }
}

