/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.resources;

import com.mojang.blaze3d.platform.GlStateManager;
import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.extensions.PackExtension;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.ClientResourcePackInfo;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class MinimumVersionWarningScreen
extends Screen {
    private static final ResourceLocation FUSION_LOGO = new ResourceLocation("fusion", "textures/resourcepacks/fusion_icon.png");
    private final ClientResourcePackInfo pack;
    private final Consumer<Boolean> confirmation;
    private final String title;
    private final int titleWidth;
    private final String packName;
    private final List<String> packDescription;
    private final List<String> headerMessage;
    private final List<String> confirmationMessage;
    private final int headerMessageWidth;
    private final int confirmationMessageWidth;
    private final String currentVersionLabel;
    private final String requiredVersionLabel;
    private final String currentVersion;
    private final String requiredVersion;
    private final int versionLabelTextWidth;
    private final int versionTextWidth;
    private final Button confirmButton;
    private final Button cancelButton;

    public MinimumVersionWarningScreen(ClientResourcePackInfo pack, Consumer<Boolean> confirmation) {
        super((ITextComponent)new TranslationTextComponent("fusion.resource_packs.warning_screen.title", new Object[0]));
        this.pack = pack;
        this.confirmation = confirmation;
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        this.title = new TranslationTextComponent("fusion.resource_packs.warning_screen.title", new Object[0]).func_211708_a(TextFormatting.UNDERLINE).func_150254_d();
        this.titleWidth = font.func_78256_a(this.title);
        String title = pack.func_195789_b().func_150254_d();
        int width = font.func_78256_a(title);
        if (width > 157) {
            title = font.func_78269_a(title, 157 - font.func_78256_a("...")) + "...";
        }
        this.packName = title;
        List lines = font.func_78271_c(pack.func_195795_c().func_150254_d(), 157);
        this.packDescription = lines.size() > 2 ? lines.subList(0, 2) : lines;
        this.headerMessage = font.func_78271_c(new TranslationTextComponent("fusion.resource_packs.warning_screen.message", new Object[0]).func_150254_d(), 220);
        this.headerMessageWidth = this.headerMessage.stream().mapToInt(arg_0 -> ((FontRenderer)font).func_78256_a(arg_0)).max().orElse(0);
        this.confirmationMessage = font.func_78271_c(new TranslationTextComponent("fusion.resource_packs.warning_screen.confirmation", new Object[0]).func_150254_d(), 220);
        this.confirmationMessageWidth = this.confirmationMessage.stream().mapToInt(arg_0 -> ((FontRenderer)font).func_78256_a(arg_0)).max().orElse(0);
        this.currentVersionLabel = new TranslationTextComponent("fusion.resource_packs.warning_screen.current_version", new Object[0]).func_150254_d();
        this.requiredVersionLabel = new TranslationTextComponent("fusion.resource_packs.warning_screen.required_version", new Object[0]).func_150254_d();
        this.versionLabelTextWidth = Math.max(font.func_78256_a(this.currentVersionLabel), font.func_78256_a(this.requiredVersionLabel));
        this.currentVersion = new StringTextComponent(FusionClient.getFusionVersion()).func_211708_a(TextFormatting.GOLD).func_150254_d();
        this.requiredVersion = new StringTextComponent(((PackExtension)pack).getFusionMetadata().getMinimumVersion()).func_211708_a(TextFormatting.GOLD).func_150254_d();
        this.versionTextWidth = Math.max(font.func_78256_a(this.currentVersion), font.func_78256_a(this.requiredVersion));
        this.confirmButton = new Button(0, 0, 80, 20, new TranslationTextComponent("fusion.resource_packs.warning_screen.confirm", new Object[0]).func_150254_d(), b -> confirmation.accept(true));
        this.cancelButton = new Button(0, 0, 80, 20, new TranslationTextComponent("fusion.resource_packs.warning_screen.cancel", new Object[0]).func_150254_d(), b -> confirmation.accept(false));
    }

    public String getNarrationMessage() {
        return new TranslationTextComponent("fusion.resource_packs.warning_screen.message", new Object[0]).func_150257_a((ITextComponent)new TranslationTextComponent("fusion.resource_packs.warning_screen.confirmation", new Object[0])).getString();
    }

    protected void init() {
        super.init();
        this.confirmButton.x = this.width / 2 - this.confirmButton.getWidth() - 2;
        this.confirmButton.y = this.height / 2 + 110 - this.confirmButton.getHeight();
        this.cancelButton.x = this.width / 2 + 2;
        this.cancelButton.y = this.height / 2 + 110 - this.cancelButton.getHeight();
        this.addButton((Widget)this.confirmButton);
        this.addButton((Widget)this.cancelButton);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        super.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)((float)this.width / 2.0f), (float)((float)this.height / 2.0f - 110.0f), (float)0.0f);
        int titleLeft = -(this.titleWidth + 17) / 2;
        GlStateManager.enableBlend();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(FUSION_LOGO);
        Screen.blit((int)titleLeft, (int)0, (float)0.0f, (float)0.0f, (int)12, (int)12, (int)12, (int)12);
        GlStateManager.disableBlend();
        this.drawString(this.font, this.title, titleLeft + 17, 2, -1);
        GlStateManager.popMatrix();
        GlStateManager.pushMatrix();
        int middleHeight = 98 + this.headerMessage.size() * 10 + this.confirmationMessage.size() * 10;
        GlStateManager.translatef((float)((float)this.width / 2.0f), (float)((float)(this.height - middleHeight) / 2.0f), (float)0.0f);
        Screen.fill((int)-98, (int)0, (int)98, (int)36, (int)0x46FFFFFF);
        this.pack.func_195808_a(Minecraft.func_71410_x().field_71446_o);
        Screen.blit((int)-96, (int)2, (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
        this.font.func_175063_a(this.packName, -62.0f, 3.0f, 0xFFFFFF);
        for (int i = 0; i < this.packDescription.size(); ++i) {
            this.drawString(this.font, this.packDescription.get(i), -62, 14 + i * 10, -8355712);
        }
        this.hLine(-115, 115, 44, -1);
        int textLeft = -Math.max(this.headerMessageWidth, this.confirmationMessageWidth) / 2;
        for (int i = 0; i < this.headerMessage.size(); ++i) {
            this.drawString(this.font, this.headerMessage.get(i), textLeft, 54 + i * 10, -1);
        }
        int textHeight = this.headerMessage.size() * 10;
        for (int i = 0; i < this.confirmationMessage.size(); ++i) {
            this.drawString(this.font, this.confirmationMessage.get(i), textLeft, 58 + textHeight + i * 10, -1);
        }
        this.hLine(-115, 115, 66 + (textHeight += this.confirmationMessage.size() * 10), -1);
        textLeft = -(this.versionLabelTextWidth + 5 + this.versionTextWidth) / 2;
        this.drawString(this.font, this.currentVersionLabel, textLeft, 76 + textHeight, -4934476);
        this.drawString(this.font, this.requiredVersionLabel, textLeft, 88 + textHeight, -4934476);
        this.drawString(this.font, this.currentVersion, textLeft + this.versionLabelTextWidth + 5, 76 + textHeight, 0xFFFFFF);
        this.drawString(this.font, this.requiredVersion, textLeft + this.versionLabelTextWidth + 5, 88 + textHeight, 0xFFFFFF);
        GlStateManager.popMatrix();
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.confirmation.accept(false);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }
}

