/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin;

import com.google.common.collect.Sets;
import com.supermartijn642.fusion.extensions.PackResourcesExtension;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.FileUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PathPackResources.class})
public class PathPackResourcesMixin
implements PackResourcesExtension {
    @Final
    @Shadow
    private static Logger LOGGER;
    @Final
    @Shadow
    private Path root;
    @Unique
    private Path overridesFolderRoot;

    @Override
    public void setFusionOverridesFolder(@NotNull String folder) {
        this.overridesFolderRoot = this.root.resolve(folder);
    }

    @Inject(method={"getResource(Lnet/minecraft/server/packs/PackType;Lnet/minecraft/resources/ResourceLocation;)Lnet/minecraft/server/packs/resources/IoSupplier;"}, at={@At(value="HEAD")}, cancellable=true)
    private void getResource(PackType type, ResourceLocation location, CallbackInfoReturnable<IoSupplier<InputStream>> ci) {
        if (this.overridesFolderRoot == null) {
            return;
        }
        Path namespaceFolder = this.overridesFolderRoot.resolve(type.getDirectory()).resolve(location.getNamespace());
        FileUtil.decomposePath((String)location.getPath()).result().map(list -> {
            Path path = FileUtil.resolvePath((Path)namespaceFolder, (List)list);
            return PathPackResources.returnFileIfExists((Path)path);
        }).ifPresent(arg_0 -> ci.setReturnValue(arg_0));
    }

    @Inject(method={"getNamespaces"}, at={@At(value="RETURN")}, cancellable=true)
    private void getNamespaces(PackType type, CallbackInfoReturnable<Set<String>> ci) {
        if (this.overridesFolderRoot == null) {
            return;
        }
        HashSet namespaces = Sets.newHashSet((Iterable)((Iterable)ci.getReturnValue()));
        Path typeFolder = this.overridesFolderRoot.resolve(type.getDirectory());
        try (DirectoryStream<Path> stream2 = Files.newDirectoryStream(typeFolder);){
            for (Path directory : stream2) {
                String location = directory.getFileName().toString();
                if (ResourceLocation.isValidNamespace((String)location)) {
                    namespaces.add(location);
                    continue;
                }
                LOGGER.warn("Ignored non-lowercase namespace: {} in {}", (Object)location, (Object)this.root);
            }
        }
        catch (NoSuchFileException stream2) {
        }
        catch (IOException e) {
            LOGGER.error("Failed to list path {}", (Object)typeFolder, (Object)e);
        }
        ci.setReturnValue((Object)namespaces);
    }

    @ModifyVariable(method={"listResources"}, at=@At(value="HEAD"), ordinal=0)
    private PackResources.ResourceOutput modifyListResources(PackResources.ResourceOutput output, PackType type, String namespace, String path) {
        if (this.overridesFolderRoot == null) {
            return output;
        }
        HashSet overriddenLocations = new HashSet();
        FileUtil.decomposePath((String)path).ifSuccess(list -> {
            Path namespaceFolder = this.overridesFolderRoot.resolve(type.getDirectory()).resolve(namespace);
            PathPackResources.listPath((String)namespace, (Path)namespaceFolder, (List)list, (location, streamSupplier) -> {
                overriddenLocations.add(location);
                output.accept(location, streamSupplier);
            });
        }).ifError(partialResult -> LOGGER.error("Invalid path {}: {}", (Object)path, (Object)partialResult.message()));
        return (location, streamSupplier) -> {
            if (!overriddenLocations.contains(location)) {
                output.accept(location, streamSupplier);
            }
        };
    }
}

