/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin;

import com.mojang.blaze3d.platform.NativeImage;
import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.api.texture.TextureErrorException;
import com.supermartijn642.fusion.api.texture.TextureType;
import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.extensions.ResourceMetadataExtension;
import com.supermartijn642.fusion.extensions.SpriteContentsExtension;
import com.supermartijn642.fusion.texture.FusionTextureMetadataSection;
import com.supermartijn642.fusion.texture.SpritePreparationContextImpl;
import com.supermartijn642.fusion.texture.TextureTypeRegistryImpl;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceMetadata;
import net.minecraftforge.client.textures.ForgeTextureMetadata;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={SpriteContents.class})
public class SpriteContentsMixin
implements SpriteContentsExtension {
    @Unique
    private Pair<TextureType<Object>, Object> fusionTextureMetadata;

    @Override
    public Pair<TextureType<Object>, Object> fusionTextureMetadata() {
        return this.fusionTextureMetadata;
    }

    @Override
    public void clearFusionTextureMetadata() {
        this.fusionTextureMetadata = null;
    }

    @ModifyVariable(method={"<init>(Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/client/resources/metadata/animation/FrameSize;Lcom/mojang/blaze3d/platform/NativeImage;Lnet/minecraft/server/packs/resources/ResourceMetadata;Lnet/minecraftforge/client/textures/ForgeTextureMetadata;)V"}, at=@At(value="INVOKE", target="Ljava/lang/Object;<init>()V", shift=At.Shift.AFTER), ordinal=0)
    private FrameSize initMetadata(FrameSize originalSize, ResourceLocation identifier, FrameSize ignore, NativeImage image, ResourceMetadata resourceMetadata, ForgeTextureMetadata forgeTextureMetadata) {
        Pair metadata = resourceMetadata.getSection(FusionTextureMetadataSection.TYPE).orElse(null);
        if (metadata != null) {
            Pair<Integer, Integer> newSize;
            this.fusionTextureMetadata = metadata;
            if (resourceMetadata instanceof ResourceMetadataExtension) {
                ((ResourceMetadataExtension)resourceMetadata).disableFusionOverwrite();
            }
            AnimationMetadataSection animationMetadata = resourceMetadata.getSection(AnimationMetadataSection.TYPE).orElse(null);
            try {
                newSize = ((TextureType)metadata.left()).getFrameSize(new SpritePreparationContextImpl(originalSize.width(), originalSize.height(), image.getWidth(), image.getHeight(), identifier, animationMetadata), metadata.right());
            }
            catch (TextureErrorException e) {
                FusionClient.LOGGER.error("Error for texture '{}': {}", (Object)identifier, (Object)e.getMessage());
                return originalSize;
            }
            catch (Exception e) {
                throw new RuntimeException("Encountered an exception whilst getting frame size from texture type '" + String.valueOf(TextureTypeRegistryImpl.getIdentifier((TextureType)metadata.left())) + "' for texture '" + String.valueOf(identifier) + "'!", e);
            }
            if (newSize == null) {
                throw new RuntimeException("Received null frame size from texture type '" + String.valueOf(TextureTypeRegistryImpl.getIdentifier((TextureType)metadata.left())) + "' for texture '" + String.valueOf(identifier) + "'!");
            }
            return new FrameSize(newSize.left().intValue(), newSize.right().intValue());
        }
        return originalSize;
    }
}

