/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin;

import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.WeightedBakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import net.minecraftforge.client.extensions.IForgeBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WeightedBakedModel.class})
public class WeightedBakedModelMixin
implements IForgeBakedModel {
    @Final
    @Shadow
    private SimpleWeightedRandomList<BakedModel> list;
    @Unique
    private static final ConcurrentHashMap<Class<? extends IForgeBakedModel>, Boolean> MODELS_PRODUCING_DATA = new ConcurrentHashMap();
    @Unique
    private boolean fusion$innerModelProducesData;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onInit(CallbackInfo ci) {
        this.fusion$innerModelProducesData = this.list.unwrap().stream().anyMatch(w -> w.data() != null && MODELS_PRODUCING_DATA.computeIfAbsent(((BakedModel)w.data()).getClass(), clz -> {
            try {
                Method method = clz.getMethod("getModelData", BlockAndTintGetter.class, BlockPos.class, BlockState.class, ModelData.class);
                return method.getDeclaringClass() != IForgeBakedModel.class;
            }
            catch (NoSuchMethodException e) {
                return true;
            }
        }) != false);
    }

    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData modelData) {
        if (state == null || !this.fusion$innerModelProducesData) {
            return modelData;
        }
        SingleThreadedRandomSource randomSource = new SingleThreadedRandomSource(state.getSeed(pos));
        BakedModel model = this.list.getRandomValue((RandomSource)randomSource).orElse(null);
        return model == null ? modelData : model.getModelData(level, pos, state, modelData);
    }
}

