/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model;

import com.supermartijn642.fusion.api.model.DefaultModelTypes;
import com.supermartijn642.fusion.api.model.ModelInstance;
import com.supermartijn642.fusion.extensions.BlockModelExtension;
import com.supermartijn642.fusion.model.ModelBakingContextImpl;
import com.supermartijn642.fusion.model.ModelInstanceImpl;
import com.supermartijn642.fusion.model.ModelTypeRegistryImpl;
import com.supermartijn642.fusion.util.IdentifierUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.MissingBlockModel;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.SpriteGetter;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;

public class FusionBlockModel
extends BlockModel {
    public static final ThreadLocal<ResourceLocation> CURRENT_MODEL = new ThreadLocal();
    public static final UnbakedModel DUMMY_MODEL = new UnbakedModel(){

        public void resolveDependencies(ResolvableModel.Resolver resolver) {
        }

        public BakedModel bake(TextureSlots textures, ModelBaker baker, ModelState modelTransform, boolean ambientOcclusion, boolean useBlockLighting, ItemTransforms itemTransforms) {
            return null;
        }
    };
    private final ResourceLocation name;
    private final ModelInstance<?> model;
    private final UnbakedModel vanillaModel;
    private Collection<ResourceLocation> dependencies;
    private Map<ResourceLocation, UnbakedModel> resolvedDependencies;

    public FusionBlockModel(ModelInstance<?> model) {
        super(null, Collections.emptyList(), new TextureSlots.Data(Collections.emptyMap()), Boolean.valueOf(false), null, ItemTransforms.NO_TRANSFORMS);
        ResourceLocation name = CURRENT_MODEL.get();
        this.name = name == null ? IdentifierUtil.withFusionNamespace("unknown") : name;
        this.model = model;
        this.vanillaModel = model.getAsVanillaModel();
    }

    public BakedModel bake(TextureSlots textures, ModelBaker baker, ModelState modelTransform, boolean ambientOcclusion, boolean useBlockLighting, ItemTransforms itemTransforms) {
        ModelBakingContextImpl context = new ModelBakingContextImpl(baker, arg_0 -> ((SpriteGetter)baker.sprites()).get(arg_0), modelTransform, this.name, this.resolvedDependencies, textures.resolvedValues, ambientOcclusion, useBlockLighting, itemTransforms);
        return this.model.bake(context);
    }

    public void resolveDependencies(ResolvableModel.Resolver resolver) {
        if (this.dependencies == null) {
            try {
                this.dependencies = this.model.getModelDependencies();
            }
            catch (Exception e) {
                throw new RuntimeException("Encountered an exception whilst requesting dependencies from model type '" + String.valueOf(ModelTypeRegistryImpl.getIdentifier(this.model.getModelType())) + "' for  '" + String.valueOf(this.name) + "'!", e);
            }
            if (this.dependencies == null) {
                throw new RuntimeException("Model type '" + String.valueOf(ModelTypeRegistryImpl.getIdentifier(this.model.getModelType())) + "' returned null when requesting dependencies '" + String.valueOf(this.name) + "'!");
            }
        }
        this.resolvedDependencies = new HashMap<ResourceLocation, UnbakedModel>(this.dependencies.size());
        for (ResourceLocation location2 : this.dependencies) {
            this.resolvedDependencies.put(location2, resolver.resolve(location2));
        }
        LinkedList<ResourceLocation> unresolved = new LinkedList<ResourceLocation>(this.dependencies);
        ResolvableModel.Resolver trackingResolver = location -> {
            UnbakedModel model = resolver.resolve(location);
            if (!this.resolvedDependencies.containsKey(location)) {
                unresolved.add(location);
                this.resolvedDependencies.put(location, resolver.resolve(location));
            }
            return model;
        };
        while (!unresolved.isEmpty()) {
            ResourceLocation location3 = (ResourceLocation)unresolved.removeFirst();
            this.resolvedDependencies.get(location3).resolveDependencies(trackingResolver);
        }
        this.resolvedDependencies.put(MissingBlockModel.LOCATION, resolver.resolve(MissingBlockModel.LOCATION));
        UnbakedModel vanillaModel = this.model.getAsVanillaModel();
        if (vanillaModel != null) {
            vanillaModel.resolveDependencies(resolver);
        }
    }

    public boolean hasVanillaModel() {
        return this.vanillaModel != null;
    }

    public UnbakedModel getVanillaModel() {
        return this.vanillaModel;
    }

    public static ModelInstance<?> getModelInstance(UnbakedModel model) {
        if (model instanceof FusionBlockModel) {
            return ((FusionBlockModel)model).model;
        }
        if (model instanceof BlockModel) {
            ModelInstance<?> modelInstance = ((BlockModelExtension)model).getFusionModel();
            if (modelInstance == null) {
                modelInstance = new ModelInstanceImpl<BlockModel>(DefaultModelTypes.VANILLA, (BlockModel)model);
                ((BlockModelExtension)model).setFusionModel(modelInstance);
            }
            return modelInstance;
        }
        return new ModelInstanceImpl<UnbakedModel>(DefaultModelTypes.UNKNOWN, model);
    }
}

