/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.vanilla;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.api.model.ModelBakingContext;
import com.supermartijn642.fusion.api.model.ModelInstance;
import com.supermartijn642.fusion.api.model.ModelType;
import com.supermartijn642.fusion.model.types.vanilla.VanillaModelSerializer;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.MissingBlockModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class VanillaModelType
implements ModelType<BlockModel> {
    @Override
    public Collection<ResourceLocation> getModelDependencies(BlockModel data) {
        return data.parentLocation == null ? List.of() : List.of(data.parentLocation);
    }

    @Override
    public BakedModel bake(ModelBakingContext context, BlockModel data) {
        VanillaModelType.resolveParents(context, data);
        return data.bake(new TextureSlots(context.getTopLevelTextureReferences()), context.getModelBaker(), context.getTransformation(), context.getTopLevelAmbientOcclusion(), context.getTopLevelUseBlockLighting(), context.getTopLevelItemTransforms());
    }

    @Nullable
    public BlockModel getAsVanillaModel(BlockModel data) {
        return data;
    }

    @Override
    public List<ResourceLocation> getParentModels(BlockModel data) {
        return data.parentLocation == null ? List.of() : List.of(data.parentLocation);
    }

    @Override
    public BlockModel deserialize(JsonObject json) throws JsonParseException {
        return (BlockModel)BlockModel.GSON.fromJson((JsonElement)json, BlockModel.class);
    }

    @Override
    public JsonObject serialize(BlockModel value) {
        return (JsonObject)VanillaModelSerializer.GSON.toJsonTree((Object)value);
    }

    private static void resolveParents(ModelBakingContext context, BlockModel model) {
        LinkedHashSet<BlockModel> passedModels = new LinkedHashSet<BlockModel>();
        while (model.parentLocation != null && model.parent == null) {
            passedModels.add(model);
            ModelInstance<?> modelInstance = context.getModel(model.parentLocation);
            if (modelInstance == null) {
                return;
            }
            UnbakedModel parent = modelInstance.getAsVanillaModel();
            if (parent == null) {
                FusionClient.LOGGER.warn("Vanilla model {} cannot have parent with model type {} for {}!", new Object[]{model, modelInstance.getModelType(), model.parentLocation});
            }
            if (passedModels.contains(parent)) {
                FusionClient.LOGGER.warn("Found 'parent' loop while loading model '{}' in chain: {} -> {}", new Object[]{model, passedModels.stream().map(Object::toString).collect(Collectors.joining(" -> ")), model.parentLocation});
                parent = null;
            }
            if (parent == null) {
                model.parentLocation = MissingBlockModel.LOCATION;
                parent = context.getModel(model.parentLocation).getAsVanillaModel();
                if (parent == null) {
                    throw new RuntimeException("Got null for missing model request!");
                }
            }
            model.parent = parent;
            if (!(parent instanceof BlockModel)) break;
            model = (BlockModel)parent;
        }
    }
}

