/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin;

import com.google.common.collect.ImmutableMap;
import com.supermartijn642.fusion.entity.EntityModelModifierManager;
import java.util.Map;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.world.entity.EntityType;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityRenderers.class})
public class EntityRenderersMixin {
    @Final
    @Mutable
    @Shadow
    private static Map<EntityType<?>, EntityRendererProvider<?>> PROVIDERS;
    @Unique
    private static Map<EntityType<?>, EntityRendererProvider<?>> providersCopy;

    @Inject(method={"createEntityRenderers"}, at={@At(value="HEAD")})
    private static void interceptRendererCreation(EntityRendererProvider.Context context, CallbackInfoReturnable<?> ci) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        PROVIDERS.forEach((entityType, rendererProvider) -> builder.put(entityType, c -> EntityModelModifierManager.handleRendererCreation(entityType, rendererProvider, c)));
        providersCopy = PROVIDERS;
        PROVIDERS = builder.build();
    }

    @Inject(method={"createEntityRenderers"}, at={@At(value="TAIL")})
    private static void resetProviderMap(EntityRendererProvider.Context context, CallbackInfoReturnable<?> ci) {
        PROVIDERS = providersCopy;
        providersCopy = null;
    }
}

