/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.api.provider;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.fusion.api.util.Pair;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;

public abstract class FusionBlockModelModifierProvider
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
    private final Map<ResourceLocation, ModifierBuilder> modifiers = new HashMap<ResourceLocation, ModifierBuilder>();
    private final String modName;
    private final DataGenerator generator;

    public FusionBlockModelModifierProvider(String modid, DataGenerator generator) {
        this.modName = ModList.get().getModContainerById(modid).map(ModContainer::getModInfo).map(IModInfo::getDisplayName).orElse(modid);
        this.generator = generator;
    }

    public final void func_200398_a(DirectoryCache cache) throws IOException {
        this.generate();
        Path output = this.generator.func_200391_b();
        for (Map.Entry<ResourceLocation, ModifierBuilder> entry : this.modifiers.entrySet()) {
            ResourceLocation location = entry.getKey();
            JsonObject json = this.toJson(entry.getValue());
            String extension = location.func_110623_a().endsWith(".json") ? "" : ".json";
            Path path = Paths.get("assets", location.func_110624_b(), "fusion/model_modifiers/blocks", location.func_110623_a() + extension);
            IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)json, (Path)output.resolve(path));
        }
    }

    private JsonObject toJson(ModifierBuilder modifier) {
        JsonObject json = new JsonObject();
        if (modifier.targets.isEmpty()) {
            throw new IllegalArgumentException("Modifier '" + modifier.location + "' must have at least one target!");
        }
        JsonArray targets = new JsonArray();
        modifier.targets.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
            ResourceLocation block = (ResourceLocation)entry.getKey();
            Map properties = (Map)entry.getValue();
            if (properties.isEmpty()) {
                targets.add(block.toString());
                return;
            }
            JsonObject object = new JsonObject();
            object.addProperty("block", block.toString());
            JsonObject propertiesJson = new JsonObject();
            properties.entrySet().stream().sorted(Comparator.comparing(e -> ((Property)e.getKey()).func_177701_a())).forEach(e -> {
                Property property = (Property)e.getKey();
                JsonArray values = new JsonArray();
                ((Set)e.getValue()).stream().map(v -> property.func_177702_a((Comparable)v)).sorted().forEach(arg_0 -> ((JsonArray)values).add(arg_0));
                propertiesJson.add(property.func_177701_a(), (JsonElement)values);
            });
            object.add("properties", (JsonElement)propertiesJson);
            targets.add((JsonElement)object);
        });
        json.add("targets", (JsonElement)targets);
        if (!modifier.appendModels.isEmpty() || !modifier.paneCullingFix) {
            JsonArray appendModels = new JsonArray();
            modifier.appendModels.stream().map(ResourceLocation::toString).sorted().forEach(arg_0 -> ((JsonArray)appendModels).add(arg_0));
            json.add("append", (JsonElement)appendModels);
        }
        if (modifier.paneCullingFix) {
            json.addProperty("pane_culling_fix", Boolean.valueOf(true));
        }
        return json;
    }

    protected abstract void generate();

    public final ModifierBuilder modifier(ResourceLocation location) {
        return this.modifiers.computeIfAbsent(location, x$0 -> new ModifierBuilder((ResourceLocation)x$0));
    }

    public String func_200397_b() {
        return "Fusion Block Model Modifier Provider: " + this.modName;
    }

    public static final class ModifierBuilder {
        private final ResourceLocation location;
        private final Map<ResourceLocation, Map<Property<?>, Set<Object>>> targets = new HashMap();
        private final Set<ResourceLocation> appendModels = new HashSet<ResourceLocation>();
        private boolean paneCullingFix = false;

        private ModifierBuilder(ResourceLocation location) {
            this.location = location;
        }

        public ModifierBuilder target(ResourceLocation block) {
            if (!this.targets.containsKey(block)) {
                this.targets.put(block, new HashMap());
            }
            return this;
        }

        public ModifierBuilder target(Block block) {
            return this.target(Registry.field_212618_g.func_177774_c((Object)block));
        }

        public ModifierBuilder target(Block block, Map<Property<?>, Set<?>> properties) {
            ResourceLocation identifier = Registry.field_212618_g.func_177774_c((Object)block);
            Map map = this.targets.computeIfAbsent(identifier, o -> new HashMap());
            for (Map.Entry<Property<?>, Set<?>> entry : properties.entrySet()) {
                Property<?> property = entry.getKey();
                Set values = map.computeIfAbsent(property, o -> new HashSet());
                for (Object value : entry.getValue()) {
                    if (!property.func_177700_c().contains(value)) {
                        throw new IllegalStateException("Value '" + value + "' is not a valid value for property '" + property.func_177701_a() + "'!");
                    }
                    values.add(value);
                }
            }
            return this;
        }

        public <T extends Comparable<T>> ModifierBuilder target(Block block, Property<T> property, T ... values) {
            return this.target(block, new HashMap(Collections.singletonMap(property, new HashSet<T[]>(Collections.singleton(values)))));
        }

        public ModifierBuilder target(BlockState state) {
            return this.target(state.func_177230_c(), state.func_235904_r_().stream().sorted(Comparator.comparing(Property::func_177701_a)).map(property -> Pair.of(property, new HashSet<Comparable>(Collections.singleton(state.func_177229_b(property))))).collect(Collectors.toMap(Pair::left, Pair::right, (a, b) -> {
                throw new AssertionError();
            }, HashMap::new)));
        }

        public ModifierBuilder appendModel(ResourceLocation location) {
            this.appendModels.add(location);
            return this;
        }

        public ModifierBuilder paneCullingFix(boolean enabled) {
            this.paneCullingFix = enabled;
            return this;
        }
    }
}

