/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.api.provider;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.fusion.api.model.modifier.item.ItemPredicate;
import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.model.modifiers.item.predicates.AndItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.ItemPredicateRegistry;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;

public abstract class FusionItemModelModifierProvider
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
    private final Map<ResourceLocation, ModifierBuilder> modifiers = new HashMap<ResourceLocation, ModifierBuilder>();
    private final String modName;
    private final DataGenerator generator;

    public FusionItemModelModifierProvider(String modid, DataGenerator generator) {
        this.modName = ModList.get().getModContainerById(modid).map(ModContainer::getModInfo).map(IModInfo::getDisplayName).orElse(modid);
        this.generator = generator;
    }

    public final void func_200398_a(DirectoryCache cache) throws IOException {
        this.generate();
        ArrayList tasks = new ArrayList();
        Path output = this.generator.func_200391_b();
        for (Map.Entry<ResourceLocation, ModifierBuilder> entry : this.modifiers.entrySet()) {
            ResourceLocation location = entry.getKey();
            JsonObject json = this.toJson(entry.getValue());
            String extension = location.func_110623_a().endsWith(".json") ? "" : ".json";
            Path path = Paths.get("assets", location.func_110624_b(), "fusion/model_modifiers/items", location.func_110623_a() + extension);
            IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)json, (Path)output.resolve(path));
        }
    }

    private JsonObject toJson(ModifierBuilder modifier) {
        JsonObject json = new JsonObject();
        if (modifier.targets.isEmpty()) {
            throw new IllegalArgumentException("Modifier '" + modifier.location + "' must have at least one target!");
        }
        JsonArray targets = new JsonArray();
        modifier.targets.stream().sorted().map(ResourceLocation::toString).forEach(arg_0 -> ((JsonArray)targets).add(arg_0));
        json.add("targets", (JsonElement)targets);
        if (modifier.defaultModel != null) {
            json.addProperty("default_model", modifier.defaultModel.toString());
        }
        JsonArray models = new JsonArray();
        for (Pair pair : modifier.conditionalModels) {
            JsonObject model = new JsonObject();
            model.addProperty("model", ((ResourceLocation)pair.left()).toString());
            JsonArray conditions = new JsonArray();
            List<Object> predicates = pair.right() instanceof AndItemPredicate ? ((AndItemPredicate)pair.right()).getPredicates() : Collections.singletonList(pair.right());
            predicates.stream().map(ItemPredicateRegistry::serializeItemPredicate).forEach(arg_0 -> ((JsonArray)conditions).add(arg_0));
            model.add("conditions", (JsonElement)conditions);
            models.add((JsonElement)model);
        }
        json.add("models", (JsonElement)models);
        return json;
    }

    protected abstract void generate();

    public final ModifierBuilder modifier(ResourceLocation location) {
        return this.modifiers.computeIfAbsent(location, x$0 -> new ModifierBuilder((ResourceLocation)x$0));
    }

    public String func_200397_b() {
        return "Fusion Item Model Modifier Provider: " + this.modName;
    }

    public static final class ModifierBuilder {
        private final ResourceLocation location;
        private final Set<ResourceLocation> targets = new HashSet<ResourceLocation>();
        private final List<Pair<ResourceLocation, ItemPredicate>> conditionalModels = new ArrayList<Pair<ResourceLocation, ItemPredicate>>();
        private ResourceLocation defaultModel = null;

        private ModifierBuilder(ResourceLocation location) {
            this.location = location;
        }

        public ModifierBuilder target(ResourceLocation item) {
            this.targets.add(item);
            return this;
        }

        public ModifierBuilder target(Item item) {
            return this.target(Registry.field_212630_s.func_177774_c((Object)item));
        }

        public ModifierBuilder target(Block block) {
            Item item = Item.func_150898_a((Block)block);
            if (item == null || block != Blocks.field_150350_a && item == Items.field_190931_a) {
                throw new IllegalArgumentException("Block '" + block + "' does not have an item!");
            }
            return this.target(item);
        }

        public ModifierBuilder defaultModel(ResourceLocation location) {
            this.defaultModel = location;
            return this;
        }

        public ModifierBuilder conditionalModel(ResourceLocation model, ItemPredicate condition) {
            this.conditionalModels.add(Pair.of(model, condition));
            return this;
        }
    }
}

