/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin;

import com.google.common.collect.ImmutableSet;
import com.supermartijn642.fusion.model.types.base.CustomRenderTypeBakedModel;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.MultipartBakedModel;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MultipartBakedModel.class})
public class MultiPartBakedModelMixin
implements CustomRenderTypeBakedModel {
    @Unique
    private Set<RenderType> customBlockRenderTypes;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void init(List<Pair<Predicate<BlockState>, IBakedModel>> models, CallbackInfo ci) {
        HashSet<RenderType> customBlockRenderTypes = null;
        for (Pair<Predicate<BlockState>, IBakedModel> model : models) {
            Collection<RenderType> renderTypes;
            if (!(model.getRight() instanceof CustomRenderTypeBakedModel) || (renderTypes = ((CustomRenderTypeBakedModel)model.getRight()).getBlockRenderTypes()).isEmpty()) continue;
            if (customBlockRenderTypes == null) {
                customBlockRenderTypes = new HashSet<RenderType>();
            }
            customBlockRenderTypes.addAll(renderTypes);
        }
        this.customBlockRenderTypes = customBlockRenderTypes == null ? Collections.emptySet() : ImmutableSet.copyOf(customBlockRenderTypes);
    }

    @Override
    public Collection<RenderType> getBlockRenderTypes() {
        return this.customBlockRenderTypes;
    }
}

