/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion;

import com.google.common.collect.ImmutableSet;
import com.supermartijn642.fusion.api.model.DefaultModelTypes;
import com.supermartijn642.fusion.api.model.FusionModelTypeRegistry;
import com.supermartijn642.fusion.api.predicate.FusionPredicateRegistry;
import com.supermartijn642.fusion.api.texture.DefaultTextureTypes;
import com.supermartijn642.fusion.api.texture.FusionTextureTypeRegistry;
import com.supermartijn642.fusion.api.texture.data.BaseTextureData;
import com.supermartijn642.fusion.entity.model.predicates.AltitudeEntityModelPredicate;
import com.supermartijn642.fusion.entity.model.predicates.AndEntityModelPredicate;
import com.supermartijn642.fusion.entity.model.predicates.BabyEntityModelPredicate;
import com.supermartijn642.fusion.entity.model.predicates.BiomeEntityModelPredicate;
import com.supermartijn642.fusion.entity.model.predicates.DimensionEntityModelPredicate;
import com.supermartijn642.fusion.entity.model.predicates.EntityModelPredicateRegistry;
import com.supermartijn642.fusion.entity.model.predicates.NotEntityModelPredicate;
import com.supermartijn642.fusion.entity.model.predicates.OrEntityModelPredicate;
import com.supermartijn642.fusion.model.FusionModelLoader;
import com.supermartijn642.fusion.model.modifiers.block.BlockModelModifierReloadListener;
import com.supermartijn642.fusion.model.modifiers.item.ItemModelModifierReloadListener;
import com.supermartijn642.fusion.model.modifiers.item.predicates.AndItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.CountItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.DurabilityItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.EnchantmentItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.ItemPredicateRegistry;
import com.supermartijn642.fusion.model.modifiers.item.predicates.NotItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.OrItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.PotionItemPredicate;
import com.supermartijn642.fusion.model.types.connecting.ConnectingBakedModel;
import com.supermartijn642.fusion.model.types.connecting.predicates.AndConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.IsDirectionConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.IsFaceVisibleConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.IsSameBlockConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.IsSameStateConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.MatchBlockConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.MatchBlockInFrontConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.MatchStateConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.MatchStateInFrontConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.NotConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.OrConnectionPredicate;
import com.supermartijn642.fusion.texture.FusionTextureMetadataSection;
import com.supermartijn642.fusion.util.IdentifierUtil;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.SpriteLoader;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.neoforged.fml.InterModComms;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.neoforge.client.model.UnbakedModelLoader;
import net.neoforged.neoforge.client.resources.VanillaClientListeners;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FusionClient {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"fusion");
    public static final RenderType USE_ORIGINAL_RENDER_TYPE_MARKER = RenderType.create((String)"fusion:ignore", null, null, (int)0, (RenderType.CompositeState)RenderType.CompositeState.builder().createCompositeState(false));
    private static String fusionVersion;

    public static void init() {
        FusionTextureTypeRegistry.registerTextureType(ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"vanilla"), DefaultTextureTypes.VANILLA);
        FusionTextureTypeRegistry.registerTextureType(ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"base"), DefaultTextureTypes.BASE);
        FusionTextureTypeRegistry.registerTextureType(ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"connecting"), DefaultTextureTypes.CONNECTING);
        FusionTextureTypeRegistry.registerTextureType(ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"scrolling"), DefaultTextureTypes.SCROLLING);
        FusionTextureTypeRegistry.registerTextureType(ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"random"), DefaultTextureTypes.RANDOM);
        FusionTextureTypeRegistry.registerTextureType(ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"continuous"), DefaultTextureTypes.CONTINUOUS);
        FusionModelTypeRegistry.registerModelType(ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"unknown"), DefaultModelTypes.UNKNOWN);
        FusionModelTypeRegistry.registerModelType(ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"vanilla"), DefaultModelTypes.VANILLA);
        FusionModelTypeRegistry.registerModelType(ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"base"), DefaultModelTypes.BASE);
        FusionModelTypeRegistry.registerModelType(ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"connecting"), DefaultModelTypes.CONNECTING);
        FusionPredicateRegistry.registerConnectionPredicate(ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"and"), AndConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"or"), OrConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"not"), NotConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"is_direction"), IsDirectionConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"is_face_visible"), IsFaceVisibleConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"is_same_block"), IsSameBlockConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"is_same_state"), IsSameStateConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"match_block"), MatchBlockConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"match_block_in_front"), MatchBlockInFrontConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"match_state"), MatchStateConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"match_state_in_front"), MatchStateInFrontConnectionPredicate.SERIALIZER);
        ItemPredicateRegistry.registerItemPredicate(ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"and"), AndItemPredicate.SERIALIZER);
        ItemPredicateRegistry.registerItemPredicate(ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"or"), OrItemPredicate.SERIALIZER);
        ItemPredicateRegistry.registerItemPredicate(ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"not"), NotItemPredicate.SERIALIZER);
        ItemPredicateRegistry.registerItemPredicate(ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"count"), CountItemPredicate.SERIALIZER);
        ItemPredicateRegistry.registerItemPredicate(ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"durability"), DurabilityItemPredicate.SERIALIZER);
        ItemPredicateRegistry.registerItemPredicate(ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"enchantment"), EnchantmentItemPredicate.SERIALIZER);
        ItemPredicateRegistry.registerItemPredicate(ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"potion"), PotionItemPredicate.SERIALIZER);
        EntityModelPredicateRegistry.registerEntityModelPredicate(ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"and"), AndEntityModelPredicate.SERIALIZER);
        EntityModelPredicateRegistry.registerEntityModelPredicate(ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"or"), OrEntityModelPredicate.SERIALIZER);
        EntityModelPredicateRegistry.registerEntityModelPredicate(ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"not"), NotEntityModelPredicate.SERIALIZER);
        EntityModelPredicateRegistry.registerEntityModelPredicate(ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"altitude"), AltitudeEntityModelPredicate.SERIALIZER);
        EntityModelPredicateRegistry.registerEntityModelPredicate(ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"is_baby"), BabyEntityModelPredicate.SERIALIZER);
        EntityModelPredicateRegistry.registerEntityModelPredicate(ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"biome"), BiomeEntityModelPredicate.SERIALIZER);
        EntityModelPredicateRegistry.registerEntityModelPredicate(ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"dimension"), DimensionEntityModelPredicate.SERIALIZER);
        SpriteLoader.DEFAULT_METADATA_SECTIONS = ImmutableSet.builder().addAll((Iterable)SpriteLoader.DEFAULT_METADATA_SECTIONS).add(FusionTextureMetadataSection.TYPE).build();
        ModLoadingContext.get().getActiveContainer().getEventBus().addListener(e -> e.register(IdentifierUtil.withFusionNamespace("model"), (UnbakedModelLoader)new FusionModelLoader()));
        ModLoadingContext.get().getActiveContainer().getEventBus().addListener(event -> {
            event.addListener(ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"block_model_modifiers"), (PreparableReloadListener)BlockModelModifierReloadListener.INSTANCE);
            event.addDependency(VanillaClientListeners.MODELS, ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"block_model_modifiers"));
            event.addListener(ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"item_model_modifiers"), (PreparableReloadListener)ItemModelModifierReloadListener.INSTANCE);
            event.addDependency(VanillaClientListeners.MODELS, ResourceLocation.fromNamespaceAndPath((String)"fusion", (String)"item_model_modifiers"));
        });
        ModLoadingContext.get().getActiveContainer().getEventBus().addListener(event -> InterModComms.sendTo((String)"framedblocks", (String)"add_ct_property", () -> ConnectingBakedModel.BLOCK_CACHE_PROPERTY));
    }

    public static RenderType getRenderTypeMaterial(BaseTextureData.RenderType renderType) {
        if (renderType == null) {
            return USE_ORIGINAL_RENDER_TYPE_MARKER;
        }
        return switch (renderType) {
            case BaseTextureData.RenderType.OPAQUE -> RenderType.solid();
            case BaseTextureData.RenderType.CUTOUT -> RenderType.cutout();
            case BaseTextureData.RenderType.TRANSLUCENT -> RenderType.translucent();
            default -> throw new AssertionError();
        };
    }

    public static String getFusionVersion() {
        if (fusionVersion == null) {
            String version = ((ModContainer)ModList.get().getModContainerById("fusion").orElseThrow()).getModInfo().getVersion().toString();
            if (!version.matches("\\d+\\.\\d+\\.\\d+")) {
                version = version.substring(0, version.length() - version.replaceFirst("\\d+\\.\\d+\\.\\d+\\D", "").length() - 1);
            }
            fusionVersion = version;
        }
        return fusionVersion;
    }
}

