/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.modifiers.item;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.api.model.modifier.item.ItemPredicate;
import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.model.modifiers.item.ItemModelModifierItemModel;
import com.supermartijn642.fusion.model.modifiers.item.predicates.AndItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.ItemPredicateRegistry;
import com.supermartijn642.fusion.util.IdentifierUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.client.renderer.item.BlockModelWrapper;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;

public class ItemModelModifierReloadListener
implements PreparableReloadListener {
    private static final Gson GSON = new GsonBuilder().setLenient().create();
    private static final String LOCATION = "fusion/model_modifiers/items";
    private static final FileToIdConverter ID_CONVERTER = FileToIdConverter.json((String)"fusion/model_modifiers/items");
    public static final ItemModelModifierReloadListener INSTANCE = new ItemModelModifierReloadListener();
    private final Map<ResourceLocation, ItemModelPredicatesProperties> models = new HashMap<ResourceLocation, ItemModelPredicatesProperties>();

    private ItemModelModifierReloadListener() {
    }

    public void registerPredicateModels(ResolvableModel.Resolver resolver) {
        HashSet<ResourceLocation> models = new HashSet<ResourceLocation>();
        for (ItemModelPredicatesProperties properties : this.models.values()) {
            models.addAll(properties.dependencies());
        }
        models.forEach(arg_0 -> ((ResolvableModel.Resolver)resolver).resolve(arg_0));
    }

    public void applyPredicateModels(ModelBakery.BakingResult results, ModelBakery.ModelBakerImpl resolver) {
        Map bakedModels = results.itemStackModels();
        for (Map.Entry<ResourceLocation, ItemModelPredicatesProperties> entry : this.models.entrySet()) {
            ResourceLocation target = entry.getKey();
            ItemModelPredicatesProperties properties = entry.getValue();
            BlockModelWrapper defaultModel = properties.defaultModel == null ? (ItemModel)bakedModels.get(target) : new BlockModelWrapper(resolver.bake(properties.defaultModel, (ModelState)BlockModelRotation.X0_Y0), List.of());
            List<Pair<ItemPredicate, BakedModel>> models = properties.models.stream().map(pair -> pair.mapRight(location -> resolver.bake(location, (ModelState)BlockModelRotation.X0_Y0))).toList();
            bakedModels.put(target, new ItemModelModifierItemModel((ItemModel)defaultModel, models));
        }
    }

    public CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier barrier, ResourceManager resourceManager, Executor executor, Executor executor2) {
        ItemPredicateRegistry.finalizeRegistration();
        return CompletableFuture.runAsync(() -> this.reload(resourceManager), executor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)barrier).wait(arg_0));
    }

    private void reload(ResourceManager resourceManager) {
        this.models.clear();
        HashMap resources = new HashMap();
        SimpleJsonResourceReloadListener.scanDirectory((ResourceManager)resourceManager, (FileToIdConverter)ID_CONVERTER, (DynamicOps)JsonOps.INSTANCE, (Codec)new Codec<JsonElement>(this){

            public <T> DataResult<com.mojang.datafixers.util.Pair<JsonElement, T>> decode(DynamicOps<T> ops, T input) {
                return DataResult.success((Object)com.mojang.datafixers.util.Pair.of((Object)((JsonElement)ops.convertTo((DynamicOps)JsonOps.INSTANCE, input)), input));
            }

            public <T> DataResult<T> encode(JsonElement input, DynamicOps<T> ops, T prefix) {
                return DataResult.success((Object)JsonOps.INSTANCE.convertTo(ops, input));
            }
        }, resources);
        for (Map.Entry entry : resources.entrySet()) {
            ResourceLocation location = (ResourceLocation)entry.getKey();
            if (!((JsonElement)entry.getValue()).isJsonObject()) {
                throw new IllegalArgumentException("Item model predicates file '" + String.valueOf(location) + "' must contain a json object!");
            }
            JsonObject json = ((JsonElement)entry.getValue()).getAsJsonObject();
            try {
                this.parseResource(json);
            }
            catch (JsonParseException e) {
                FusionClient.LOGGER.error("Failed to parse item model predicates file '{}': {}", (Object)location, (Object)e.getMessage());
            }
        }
    }

    private void parseResource(JsonObject json) {
        if (!json.has("targets") || !json.get("targets").isJsonArray()) {
            throw new JsonParseException("Item model predicates file must have array property 'targets'!");
        }
        JsonArray targetsJson = json.getAsJsonArray("targets");
        HashSet<ResourceLocation> targets = new HashSet<ResourceLocation>();
        for (JsonElement element : targetsJson) {
            if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString()) {
                throw new JsonParseException("Array property 'targets' must only contain strings!");
            }
            if (!IdentifierUtil.isValidIdentifier(element.getAsString())) {
                throw new JsonParseException("Target must be a valid identifier, not '" + element.getAsString() + "'!!");
            }
            ResourceLocation identifier = ResourceLocation.parse((String)element.getAsString());
            Optional item = BuiltInRegistries.ITEM.getOptional(identifier);
            if (item.isEmpty()) {
                throw new JsonParseException("Could not find an item for target '" + String.valueOf(identifier) + "'!");
            }
            targets.add(identifier);
        }
        if (targets.isEmpty()) {
            return;
        }
        ResourceLocation defaultModel = null;
        if (json.has("default_model")) {
            if (!json.get("default_model").isJsonPrimitive() || !json.getAsJsonPrimitive("default_model").isString()) {
                throw new JsonParseException("Property 'default_model' must be a string!");
            }
            if (!IdentifierUtil.isValidIdentifier(json.get("default_model").getAsString())) {
                throw new JsonParseException("Default model must be a valid identifier, not '" + json.get("default_model").getAsString() + "'!");
            }
            defaultModel = ResourceLocation.parse((String)json.get("default_model").getAsString());
        }
        if (!json.has("models") || !json.get("models").isJsonArray()) {
            throw new JsonParseException("Item model predicates file must have array property 'models'!");
        }
        JsonArray modelsJson = json.getAsJsonArray("models");
        ArrayList<Pair<ItemPredicate, ResourceLocation>> models = new ArrayList<Pair<ItemPredicate, ResourceLocation>>();
        for (JsonElement element : modelsJson) {
            if (!element.isJsonObject()) {
                throw new JsonParseException("Array property 'models' must only contain objects!");
            }
            models.add(this.parseModelEntry(element.getAsJsonObject()));
        }
        if (defaultModel == null && models.isEmpty()) {
            return;
        }
        ItemModelPredicatesProperties properties = new ItemModelPredicatesProperties(defaultModel, models);
        for (ResourceLocation target : targets) {
            this.models.put(target, properties);
        }
    }

    private Pair<ItemPredicate, ResourceLocation> parseModelEntry(JsonObject json) {
        if (!(json.has("model") && json.get("model").isJsonPrimitive() && json.getAsJsonPrimitive("model").isString())) {
            throw new JsonParseException("Models entry must have string property 'model'!");
        }
        if (!IdentifierUtil.isValidIdentifier(json.get("model").getAsString())) {
            throw new JsonParseException("Model must be a valid identifier, not '" + json.get("model").getAsString() + "'!");
        }
        ResourceLocation model = ResourceLocation.parse((String)json.get("model").getAsString());
        if (!json.has("conditions") || !json.get("conditions").isJsonArray()) {
            throw new JsonParseException("Models entry must have array property 'conditions'!");
        }
        JsonArray conditionsJson = json.getAsJsonArray("conditions");
        if (conditionsJson.isEmpty()) {
            throw new JsonParseException("Model entry property 'conditions' must not be empty!");
        }
        ArrayList<ItemPredicate> predicates = new ArrayList<ItemPredicate>();
        for (JsonElement element : conditionsJson) {
            if (!element.isJsonObject()) {
                throw new JsonParseException("Model entry property 'conditions' must only contain objects!");
            }
            predicates.add(ItemPredicateRegistry.deserializeItemPredicate(element.getAsJsonObject()));
        }
        ItemPredicate predicate = predicates.size() == 1 ? (ItemPredicate)predicates.getFirst() : new AndItemPredicate(predicates);
        return Pair.of(predicate, model);
    }

    public String getName() {
        return "Fusion Item Model Predicates Reload Listener";
    }

    private static class ItemModelPredicatesProperties {
        final ResourceLocation defaultModel;
        final List<Pair<ItemPredicate, ResourceLocation>> models;

        private ItemModelPredicatesProperties(ResourceLocation defaultModel, List<Pair<ItemPredicate, ResourceLocation>> models) {
            this.defaultModel = defaultModel;
            this.models = models;
        }

        Collection<ResourceLocation> dependencies() {
            HashSet<ResourceLocation> models = new HashSet<ResourceLocation>(this.models.size() + 1);
            if (this.defaultModel != null) {
                models.add(this.defaultModel);
            }
            for (Pair<ItemPredicate, ResourceLocation> entry : this.models) {
                models.add(entry.right());
            }
            return models;
        }
    }
}

