/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.modifiers.item.predicates;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.model.modifier.item.ItemPredicate;
import com.supermartijn642.fusion.api.util.Serializer;
import com.supermartijn642.fusion.model.modifiers.item.predicates.ItemPredicateRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class OrItemPredicate
implements ItemPredicate {
    public static final Serializer<OrItemPredicate> SERIALIZER = new Serializer<OrItemPredicate>(){

        @Override
        public OrItemPredicate deserialize(JsonObject json) throws JsonParseException {
            if (!json.has("predicates") || !json.get("predicates").isJsonArray()) {
                throw new JsonParseException("Or-predicate must have array property 'predicates'!");
            }
            ArrayList<ItemPredicate> predicates = new ArrayList<ItemPredicate>();
            JsonArray array = json.getAsJsonArray("predicates");
            for (JsonElement element : array) {
                if (!element.isJsonObject()) {
                    throw new JsonParseException("Property 'predicates' must only contain objects!");
                }
                ItemPredicate predicate = ItemPredicateRegistry.deserializeItemPredicate(element.getAsJsonObject());
                predicates.add(predicate);
            }
            return new OrItemPredicate(predicates);
        }

        @Override
        public JsonObject serialize(OrItemPredicate value) {
            JsonObject json = new JsonObject();
            JsonArray predicatesJson = new JsonArray();
            for (ItemPredicate predicate : value.predicates) {
                predicatesJson.add((JsonElement)ItemPredicateRegistry.serializeItemPredicate(predicate));
            }
            json.add("predicates", (JsonElement)predicatesJson);
            return json;
        }
    };
    private final List<ItemPredicate> predicates;

    public OrItemPredicate(List<ItemPredicate> predicates) {
        this.predicates = predicates;
    }

    @Override
    public boolean test(ItemStack stack) {
        for (ItemPredicate predicate : this.predicates) {
            if (!predicate.test(stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Serializer<? extends ItemPredicate> getSerializer() {
        return SERIALIZER;
    }
}

