/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.base;

import com.google.common.collect.ImmutableList;
import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.api.model.DefaultModelTypes;
import com.supermartijn642.fusion.api.model.ModelBakingContext;
import com.supermartijn642.fusion.api.model.ModelInstance;
import com.supermartijn642.fusion.api.model.SpriteIdentifier;
import com.supermartijn642.fusion.api.model.data.BaseModelData;
import com.supermartijn642.fusion.model.types.base.BaseModelElement;
import com.supermartijn642.fusion.model.types.base.BaseModelQuad;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockElementRotation;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class BaseModelDataImpl
implements BaseModelData {
    protected final BlockModel model;
    protected final List<ResourceLocation> parents;
    protected final List<BaseModelElement> elements;

    public BaseModelDataImpl(BlockModel model, List<ResourceLocation> parents, List<BaseModelElement> elements) {
        this.model = model;
        this.parents = ImmutableList.copyOf(parents);
        this.elements = ImmutableList.copyOf(elements);
    }

    @Override
    public BlockModel getVanillaModel() {
        return this.model;
    }

    @Override
    public List<ResourceLocation> getParents() {
        return this.parents;
    }

    public List<? extends BaseModelElement> getElements() {
        return this.elements;
    }

    public void validateParents(ModelBakingContext context) {
        ArrayList<ResourceLocation> encounteredModels = new ArrayList<ResourceLocation>();
        for (ResourceLocation parent : this.parents) {
            this.validateParents(context, parent, encounteredModels);
        }
    }

    private void validateParents(ModelBakingContext context, ResourceLocation modelLocation, List<ResourceLocation> encounteredModels) {
        if (encounteredModels.contains(modelLocation)) {
            throw new IllegalStateException("Unable to bake model '" + String.valueOf(context.getModelIdentifier()) + "' due to circular dependency " + encounteredModels.stream().map(o -> "'" + String.valueOf(o) + "'").collect(Collectors.joining("->")) + "->'" + String.valueOf(modelLocation) + "'!");
        }
        encounteredModels.add(modelLocation);
        ModelInstance<?> model = context.getModel(modelLocation);
        if (model != null) {
            for (ResourceLocation dependency : model.getParentModels()) {
                this.validateParents(context, dependency, encounteredModels);
            }
        }
        encounteredModels.remove(encounteredModels.size() - 1);
    }

    public <T> T findProperty(ModelBakingContext context, Function<UnbakedModel, T> property, T defaultValue) {
        T value = this.findProperty(context, ModelInstance.of(DefaultModelTypes.BASE, this), property);
        return value == null ? defaultValue : value;
    }

    private <T> T findProperty(ModelBakingContext context, ModelInstance<?> model, Function<UnbakedModel, T> property) {
        T value;
        UnbakedModel vanillaModel = model.getAsVanillaModel();
        if (vanillaModel != null && (value = property.apply(vanillaModel)) != null) {
            return value;
        }
        for (ResourceLocation location : model.getParentModels()) {
            T childValue;
            ModelInstance<?> dependency = context.getModel(location);
            if (dependency == null || (childValue = this.findProperty(context, dependency, property)) == null) continue;
            return childValue;
        }
        return null;
    }

    public ItemTransform findItemTransform(ModelBakingContext context, ItemDisplayContext transformType) {
        return this.findProperty(context, (UnbakedModel model) -> {
            ItemTransforms transforms = model.getTransforms();
            if (transforms == null || transforms.getTransform(transformType) == ItemTransform.NO_TRANSFORM) {
                return null;
            }
            return transforms.getTransform(transformType);
        }, ItemTransform.NO_TRANSFORM);
    }

    public SpriteIdentifier findParticleSprite(ModelBakingContext context) {
        ModelInstance<BaseModelDataImpl> model = ModelInstance.of(DefaultModelTypes.BASE, this);
        ArrayList<String> encounteredKeys = new ArrayList<String>();
        encounteredKeys.add("particle");
        String currentKey = "particle";
        String finalCurrentKey;
        TextureSlots.SlotContents contents;
        while ((contents = this.findProperty(context, model, arg_0 -> BaseModelDataImpl.lambda$findParticleSprite$2(finalCurrentKey = currentKey, arg_0))) != null) {
            if (contents instanceof TextureSlots.Value) {
                return SpriteIdentifier.of(((TextureSlots.Value)contents).material());
            }
            currentKey = ((TextureSlots.Reference)contents).target();
            if (encounteredKeys.contains(currentKey)) {
                FusionClient.LOGGER.warn("Unable to resolve texture due to circular references {}->'{}' in '{}'!", new Object[]{encounteredKeys.stream().map(o -> "'" + o + "'").collect(Collectors.joining("->")), currentKey, context.getModelIdentifier()});
                return SpriteIdentifier.missing();
            }
            encounteredKeys.add(currentKey);
        }
        return SpriteIdentifier.missing();
    }

    public List<BaseModelQuad> bakeQuads(ModelBakingContext context) {
        ArrayList<BaseModelQuad> quads = new ArrayList<BaseModelQuad>();
        this.bakeQuads(context, ModelInstance.of(DefaultModelTypes.BASE, this), new LinkedList(), quads::add);
        return quads;
    }

    private void bakeQuads(ModelBakingContext context, ModelInstance<?> model, Deque<ModelInstance<?>> modelStack, Consumer<BaseModelQuad> output) {
        modelStack.addLast(model);
        List elements = null;
        if (model.getModelType() == DefaultModelTypes.BASE || model.getModelType() == DefaultModelTypes.CONNECTING) {
            elements = ((BaseModelDataImpl)model.getModelData()).elements;
        } else {
            UnbakedModel vanillaModel = model.getAsVanillaModel();
            if (vanillaModel instanceof ItemModelGenerator) {
                elements = this.generateItemModel(context, modelStack, (ItemModelGenerator)vanillaModel);
            } else if (vanillaModel instanceof BlockModel) {
                elements = ((BlockModel)vanillaModel).elements;
            }
        }
        if (elements != null && !elements.isEmpty()) {
            for (BlockElement element : elements) {
                for (Direction direction : element.faces.keySet()) {
                    BlockElementFace face = (BlockElementFace)element.faces.get(direction);
                    TextureAtlasSprite sprite = context.getTexture(this.resolveMaterial(context, modelStack, face.texture()));
                    BakedQuad quad = FaceBakery.bakeQuad((Vector3f)element.from, (Vector3f)element.to, (BlockElementFace)face, (TextureAtlasSprite)sprite, (Direction)direction, (ModelState)context.getTransformation(), (BlockElementRotation)element.rotation, (boolean)element.shade, (int)element.lightEmission);
                    Direction cullDirection = face.cullForDirection() != null ? Direction.rotate((Matrix4f)context.getTransformation().getRotation().getMatrix(), (Direction)face.cullForDirection()) : null;
                    output.accept(new BaseModelQuad(quad, cullDirection));
                }
            }
            modelStack.pop();
            return;
        }
        for (ResourceLocation location : model.getParentModels()) {
            ModelInstance<?> dependency = context.getModel(location);
            if (dependency == null) continue;
            this.bakeQuads(context, dependency, modelStack, output);
        }
        modelStack.removeLast();
    }

    protected SpriteIdentifier resolveMaterial(ModelBakingContext context, Deque<ModelInstance<?>> modelStack, String key) {
        if (key.charAt(0) == '#') {
            key = key.substring(1);
        }
        ArrayList<String> encounteredKeys = new ArrayList<String>();
        encounteredKeys.add(key);
        String currentKey = key;
        while (true) {
            ModelInstance<?> model2;
            UnbakedModel vanillaModel;
            TextureSlots.SlotContents contents = null;
            Iterator<ModelInstance<?>> iterator = modelStack.iterator();
            while (iterator.hasNext() && ((vanillaModel = (model2 = iterator.next()).getAsVanillaModel()) == null || (contents = (TextureSlots.SlotContents)vanillaModel.getTextureSlots().values().get(currentKey)) == null)) {
            }
            if (contents == null) {
                String finalCurrentKey = currentKey;
                contents = this.findProperty(context, modelStack.getLast(), model -> (TextureSlots.SlotContents)model.getTextureSlots().values().get(finalCurrentKey));
            }
            if (contents == null) {
                return SpriteIdentifier.missing();
            }
            if (contents instanceof TextureSlots.Value) {
                return SpriteIdentifier.of(((TextureSlots.Value)contents).material());
            }
            currentKey = ((TextureSlots.Reference)contents).target();
            if (encounteredKeys.contains(currentKey)) {
                FusionClient.LOGGER.warn("Unable to resolve texture due to circular references {}->'{}' in '{}'!", new Object[]{encounteredKeys.stream().map(o -> "'" + o + "'").collect(Collectors.joining("->")), currentKey, context.getModelIdentifier()});
                return SpriteIdentifier.missing();
            }
            encounteredKeys.add(currentKey);
        }
    }

    protected List<BlockElement> generateItemModel(ModelBakingContext context, Deque<ModelInstance<?>> modelStack, ItemModelGenerator generator) {
        ArrayList<BlockElement> elements = new ArrayList<BlockElement>();
        for (int layer = 0; layer < ItemModelGenerator.LAYERS.size(); ++layer) {
            String layerName = (String)ItemModelGenerator.LAYERS.get(layer);
            SpriteIdentifier sprite = this.resolveMaterial(context, modelStack, layerName);
            if (SpriteIdentifier.missing().equals(sprite)) break;
            SpriteContents spriteContents = context.getTexture(sprite).contents();
            elements.addAll(generator.processFrames(layer, layerName, spriteContents));
        }
        return elements;
    }

    private static /* synthetic */ TextureSlots.SlotContents lambda$findParticleSprite$2(String finalCurrentKey, UnbakedModel m) {
        return (TextureSlots.SlotContents)m.getTextureSlots().values().get(finalCurrentKey);
    }
}

