/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.texture;

import com.supermartijn642.fusion.api.texture.data.BaseTextureData;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.block.state.BlockState;

public class QuadTintingHelper {
    private static final BlockColor[] TINT_FUNCTIONS = new BlockColor[]{(state, level, pos, tintIndex) -> {
        if (level == null || pos == null) {
            return GrassColor.getDefaultColor();
        }
        return BiomeColors.getAverageGrassColor((BlockAndTintGetter)level, (BlockPos)pos);
    }, (state, level, pos, tintIndex) -> {
        if (level == null || pos == null) {
            return -12012264;
        }
        return BiomeColors.getAverageFoliageColor((BlockAndTintGetter)level, (BlockPos)pos);
    }, (state, level, pos, tintIndex) -> {
        if (level == null || pos == null) {
            return -1;
        }
        return BiomeColors.getAverageWaterColor((BlockAndTintGetter)level, (BlockPos)pos);
    }};

    public static int getColor(BaseTextureData.QuadTinting tinting, BlockState state, BlockAndTintGetter level, BlockPos pos) {
        BlockColor tintFunction = TINT_FUNCTIONS[tinting.ordinal()];
        return tintFunction.getColor(state, level, pos, 0) | 0xFF000000;
    }

    static {
        if (TINT_FUNCTIONS.length != BaseTextureData.QuadTinting.values().length) {
            throw new AssertionError((Object)"Missing tinting functions!");
        }
    }
}

