/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.modifiers.item;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.api.model.modifier.item.ItemPredicate;
import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.model.modifiers.item.ItemModelModifierBakedModel;
import com.supermartijn642.fusion.model.modifiers.item.predicates.AndItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.ItemPredicateRegistry;
import com.supermartijn642.fusion.util.IdentifierUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1091;
import net.minecraft.class_1100;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_4309;
import net.minecraft.class_7923;

public class ItemModelModifierReloadListener {
    private static final Gson GSON = new GsonBuilder().setLenient().create();
    private static final String LOCATION = "fusion/model_modifiers/items";
    public static final ItemModelModifierReloadListener INSTANCE = new ItemModelModifierReloadListener();
    private final Map<class_1091, ItemModelPredicatesProperties> models = new HashMap<class_1091, ItemModelPredicatesProperties>();

    private ItemModelModifierReloadListener() {
    }

    public void registerPredicateModels(class_1088 bakery) {
        HashSet<class_2960> models = new HashSet<class_2960>();
        for (ItemModelPredicatesProperties properties : this.models.values()) {
            models.addAll(properties.dependencies());
        }
        for (class_2960 model : models) {
            class_1100 unbakedModel = bakery.method_4726(model);
            bakery.field_5376.put(model, unbakedModel);
            bakery.field_5394.put(model, unbakedModel);
            unbakedModel.method_45785(arg_0 -> ((class_1088)bakery).method_4726(arg_0));
        }
    }

    public void applyPredicateModels(class_1088 bakery) {
        Map bakedModels = bakery.method_4734();
        for (Map.Entry<class_1091, ItemModelPredicatesProperties> entry : this.models.entrySet()) {
            class_1091 target = entry.getKey();
            ItemModelPredicatesProperties properties = entry.getValue();
            class_1087 defaultModel = properties.defaultModel == null ? (class_1087)bakedModels.get(target) : (class_1087)bakedModels.get(properties.defaultModel);
            List<Pair<ItemPredicate, class_1087>> models = properties.models.stream().map(pair -> pair.mapRight(bakedModels::get)).toList();
            bakedModels.put(target, new ItemModelModifierBakedModel(defaultModel, models));
        }
    }

    public void reload(class_3300 resourceManager) {
        ItemPredicateRegistry.finalizeRegistration();
        this.models.clear();
        HashMap resources = new HashMap();
        class_4309.method_51148((class_3300)resourceManager, (String)LOCATION, (Gson)GSON, resources);
        for (Map.Entry entry : resources.entrySet()) {
            class_2960 location = (class_2960)entry.getKey();
            if (!((JsonElement)entry.getValue()).isJsonObject()) {
                throw new IllegalArgumentException("Item model predicates file '" + String.valueOf(location) + "' must contain a json object!");
            }
            JsonObject json = ((JsonElement)entry.getValue()).getAsJsonObject();
            try {
                this.parseResource(json);
            }
            catch (JsonParseException e) {
                FusionClient.LOGGER.error("Failed to parse item model predicates file '{}': {}", (Object)location, (Object)e.getMessage());
            }
        }
    }

    private void parseResource(JsonObject json) {
        if (!json.has("targets") || !json.get("targets").isJsonArray()) {
            throw new JsonParseException("Item model predicates file must have array property 'targets'!");
        }
        JsonArray targetsJson = json.getAsJsonArray("targets");
        HashSet<class_1091> targets = new HashSet<class_1091>();
        for (JsonElement element : targetsJson) {
            if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString()) {
                throw new JsonParseException("Array property 'targets' must only contain strings!");
            }
            if (!IdentifierUtil.isValidIdentifier(element.getAsString())) {
                throw new JsonParseException("Target must be a valid identifier, not '" + element.getAsString() + "'!!");
            }
            class_2960 identifier = new class_2960(element.getAsString());
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(identifier);
            if (item == null || item == class_1802.field_8162) {
                throw new JsonParseException("Could not find an item for target '" + String.valueOf(identifier) + "'!");
            }
            targets.add(new class_1091(identifier, "inventory"));
        }
        if (targets.isEmpty()) {
            return;
        }
        class_2960 defaultModel = null;
        if (json.has("default_model")) {
            if (!json.get("default_model").isJsonPrimitive() || !json.getAsJsonPrimitive("default_model").isString()) {
                throw new JsonParseException("Property 'default_model' must be a string!");
            }
            if (!IdentifierUtil.isValidIdentifier(json.get("default_model").getAsString())) {
                throw new JsonParseException("Default model must be a valid identifier, not '" + json.get("default_model").getAsString() + "'!");
            }
            defaultModel = new class_2960(json.get("default_model").getAsString());
        }
        if (!json.has("models") || !json.get("models").isJsonArray()) {
            throw new JsonParseException("Item model predicates file must have array property 'models'!");
        }
        JsonArray modelsJson = json.getAsJsonArray("models");
        ArrayList<Pair<ItemPredicate, class_2960>> models = new ArrayList<Pair<ItemPredicate, class_2960>>();
        for (JsonElement element : modelsJson) {
            if (!element.isJsonObject()) {
                throw new JsonParseException("Array property 'models' must only contain objects!");
            }
            models.add(this.parseModelEntry(element.getAsJsonObject()));
        }
        if (defaultModel == null && models.isEmpty()) {
            return;
        }
        ItemModelPredicatesProperties properties = new ItemModelPredicatesProperties(defaultModel, models);
        for (class_1091 target : targets) {
            this.models.put(target, properties);
        }
    }

    private Pair<ItemPredicate, class_2960> parseModelEntry(JsonObject json) {
        if (!(json.has("model") && json.get("model").isJsonPrimitive() && json.getAsJsonPrimitive("model").isString())) {
            throw new JsonParseException("Models entry must have string property 'model'!");
        }
        if (!IdentifierUtil.isValidIdentifier(json.get("model").getAsString())) {
            throw new JsonParseException("Model must be a valid identifier, not '" + json.get("model").getAsString() + "'!");
        }
        class_2960 model = new class_2960(json.get("model").getAsString());
        if (!json.has("conditions") || !json.get("conditions").isJsonArray()) {
            throw new JsonParseException("Models entry must have array property 'conditions'!");
        }
        JsonArray conditionsJson = json.getAsJsonArray("conditions");
        if (conditionsJson.isEmpty()) {
            throw new JsonParseException("Model entry property 'conditions' must not be empty!");
        }
        ArrayList<ItemPredicate> predicates = new ArrayList<ItemPredicate>();
        for (JsonElement element : conditionsJson) {
            if (!element.isJsonObject()) {
                throw new JsonParseException("Model entry property 'conditions' must only contain objects!");
            }
            predicates.add(ItemPredicateRegistry.deserializeItemPredicate(element.getAsJsonObject()));
        }
        ItemPredicate predicate = predicates.size() == 1 ? (ItemPredicate)predicates.getFirst() : new AndItemPredicate(predicates);
        return Pair.of(predicate, model);
    }

    private static class ItemModelPredicatesProperties {
        final class_2960 defaultModel;
        final List<Pair<ItemPredicate, class_2960>> models;

        private ItemModelPredicatesProperties(class_2960 defaultModel, List<Pair<ItemPredicate, class_2960>> models) {
            this.defaultModel = defaultModel;
            this.models = models;
        }

        Collection<class_2960> dependencies() {
            HashSet<class_2960> models = new HashSet<class_2960>(this.models.size() + 1);
            if (this.defaultModel != null) {
                models.add(this.defaultModel);
            }
            for (Pair<ItemPredicate, class_2960> entry : this.models) {
                models.add(entry.right());
            }
            return models;
        }
    }
}

