/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.base;

import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.api.texture.DefaultTextureTypes;
import com.supermartijn642.fusion.model.MutableQuad;
import com.supermartijn642.fusion.model.types.base.BaseModelQuad;
import com.supermartijn642.fusion.texture.types.continuous.ContinuousTextureSprite;
import com.supermartijn642.fusion.texture.types.continuous.ContinuousTextureType;
import com.supermartijn642.fusion.texture.types.random.RandomTextureSprite;
import com.supermartijn642.fusion.texture.types.random.RandomTextureType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import net.minecraft.class_765;
import net.minecraft.class_777;
import net.minecraft.class_806;
import net.minecraft.class_809;
import org.jetbrains.annotations.Nullable;

public class BaseBakedModel
implements class_1087 {
    private final Mesh blockMesh;
    private final Mesh itemMesh;
    private final List<class_1058> sprites;
    private final boolean hasSpecialQuads;
    private final boolean hasAmbientOcclusion;
    private final boolean isGui3d;
    private final boolean usesBlockLight;
    private final class_1058 particleIcon;
    private final class_809 transforms;
    private final class_806 overrides;

    public BaseBakedModel(List<BaseModelQuad> quads, boolean hasAmbientOcclusion, boolean isGui3d, boolean usesBlockLight, class_1058 particleIcon, class_809 transforms, class_806 overrides) {
        int block;
        int sky;
        int i;
        RenderMaterial material;
        this.hasAmbientOcclusion = hasAmbientOcclusion;
        this.isGui3d = isGui3d;
        this.usesBlockLight = usesBlockLight;
        this.particleIcon = particleIcon;
        this.transforms = transforms;
        this.overrides = overrides;
        MeshBuilder builder = RendererAccess.INSTANCE.getRenderer().meshBuilder();
        QuadEmitter emitter = builder.getEmitter();
        HashMap<class_1058, Integer> sprites = new HashMap<class_1058, Integer>();
        boolean hasSpecialQuads = false;
        for (BaseModelQuad quad : quads) {
            material = FusionClient.getRenderTypeMaterial(hasAmbientOcclusion, quad.renderType(), quad.emissive());
            emitter.fromVanilla(quad.bakedQuad(), material, quad.cullDirection());
            if (quad.lightEmission() != null) {
                for (i = 0; i < 4; ++i) {
                    sky = Math.max(quad.lightEmission(), class_765.method_24187((int)emitter.lightmap(i)));
                    block = Math.max(quad.lightEmission(), class_765.method_24186((int)emitter.lightmap(i)));
                    emitter.lightmap(i, class_765.method_23687((int)sky, (int)block));
                }
            }
            if (quad.textureType() == DefaultTextureTypes.RANDOM || quad.textureType() == DefaultTextureTypes.CONTINUOUS) {
                int type = quad.textureType() == DefaultTextureTypes.RANDOM ? 2 : 3;
                int spriteIndex = sprites.computeIfAbsent(quad.bakedQuad().method_35788(), o -> sprites.size());
                emitter.tag(type | spriteIndex << 4);
                hasSpecialQuads = true;
            }
            emitter.emit();
        }
        this.blockMesh = builder.build();
        this.sprites = sprites.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).toList();
        this.hasSpecialQuads = hasSpecialQuads;
        builder = RendererAccess.INSTANCE.getRenderer().meshBuilder();
        emitter = builder.getEmitter();
        for (BaseModelQuad quad : quads) {
            material = FusionClient.getRenderTypeMaterial(null, quad.renderType(), quad.emissive());
            emitter.fromVanilla(quad.bakedQuad(), material, quad.cullDirection());
            if (quad.lightEmission() != null) {
                for (i = 0; i < 4; ++i) {
                    sky = Math.max(quad.lightEmission(), class_765.method_24187((int)emitter.lightmap(i)));
                    block = Math.max(quad.lightEmission(), class_765.method_24186((int)emitter.lightmap(i)));
                    emitter.lightmap(i, class_765.method_23687((int)sky, (int)block));
                }
            }
            emitter.emit();
        }
        this.itemMesh = builder.build();
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public List<class_777> method_4707(@Nullable class_2680 state, @Nullable class_2350 direction, class_5819 random) {
        return List.of();
    }

    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        if (!this.hasSpecialQuads) {
            this.blockMesh.outputTo(context.getEmitter());
            return;
        }
        boolean[] culledFaces = new boolean[]{context.isFaceCulled(class_2350.field_11033), context.isFaceCulled(class_2350.field_11036), context.isFaceCulled(class_2350.field_11043), context.isFaceCulled(class_2350.field_11035), context.isFaceCulled(class_2350.field_11039), context.isFaceCulled(class_2350.field_11034)};
        MutableQuad mutableQuad = new MutableQuad();
        context.pushTransform(quad -> {
            if (quad.tag() != 0) {
                class_2350 cullFace = quad.cullFace();
                if (cullFace != null && culledFaces[cullFace.ordinal()]) {
                    return false;
                }
                int tag = quad.tag();
                int type = quad.tag() & 0xF;
                int spriteIndex = tag >> 4 & 0xFF;
                class_1058 sprite = this.sprites.get(spriteIndex);
                quad.tag((int)Math.floor((sprite.field_5269 + sprite.field_5270) / 2.0f * 65535.0f) | (int)Math.floor((sprite.field_5267 + sprite.field_5268) / 2.0f * 65535.0f) << 16);
                if (type == 2) {
                    mutableQuad.set(quad);
                    RandomTextureType.processQuad(mutableQuad, pos, quad.nominalFace(), randomSupplier, (RandomTextureSprite)sprite);
                    return true;
                }
                if (type == 3) {
                    mutableQuad.set(quad);
                    ContinuousTextureType.processQuad(mutableQuad, pos, quad.nominalFace(), (ContinuousTextureSprite)sprite);
                    return true;
                }
            }
            return true;
        });
        this.blockMesh.outputTo(context.getEmitter());
        context.popTransform();
    }

    public void emitItemQuads(class_1799 stack, Supplier<class_5819> randomSupplier, RenderContext context) {
        this.itemMesh.outputTo(context.getEmitter());
    }

    public boolean method_4708() {
        return this.hasAmbientOcclusion;
    }

    public boolean method_4712() {
        return this.isGui3d;
    }

    public boolean method_24304() {
        return this.usesBlockLight;
    }

    public boolean method_4713() {
        return false;
    }

    public class_1058 method_4711() {
        return this.particleIcon;
    }

    public class_809 method_4709() {
        return this.transforms;
    }

    public class_806 method_4710() {
        return this.overrides;
    }
}

