/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.connecting.predicates;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.predicate.ConnectionDirection;
import com.supermartijn642.fusion.api.predicate.ConnectionPredicate;
import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.api.util.Serializer;
import com.supermartijn642.fusion.util.IdentifierUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class MatchStateInFrontConnectionPredicate
implements ConnectionPredicate {
    public static final Serializer<MatchStateInFrontConnectionPredicate> SERIALIZER = new Serializer<MatchStateInFrontConnectionPredicate>(){

        @Override
        public MatchStateInFrontConnectionPredicate deserialize(JsonObject json) throws JsonParseException {
            if (!(json.has("block") && json.get("block").isJsonPrimitive() && json.getAsJsonPrimitive("block").isString())) {
                throw new JsonParseException("Match state predicate must have string property 'block'!");
            }
            if (!IdentifierUtil.isValidIdentifier(json.get("block").getAsString())) {
                throw new JsonParseException("Property 'block' must be a valid identifier!");
            }
            class_2960 identifier = new class_2960(json.get("block").getAsString());
            if (!class_7923.field_41175.method_10250(identifier)) {
                throw new JsonParseException("Unknown block '" + String.valueOf(identifier) + "'!");
            }
            class_2248 block = (class_2248)class_7923.field_41175.method_10223(identifier);
            ArrayList<Pair<class_2769<?>, Set<?>>> properties = new ArrayList();
            if (!json.has("properties") || !json.get("properties").isJsonObject()) {
                throw new JsonParseException("Match block predicate must have object property 'properties'!");
            }
            if (json.getAsJsonObject("properties").isEmpty()) {
                throw new JsonParseException("At least one property must be specified for match state predicate!");
            }
            for (Map.Entry entry : json.getAsJsonObject("properties").entrySet()) {
                class_2769 property = block.method_9595().method_11663((String)entry.getKey());
                if (property == null) {
                    throw new JsonParseException("Block '" + String.valueOf(identifier) + "' does not have a property named '" + (String)entry.getKey() + "'!");
                }
                ImmutableSet.Builder builder = ImmutableSet.builder();
                if (((JsonElement)entry.getValue()).isJsonPrimitive() && ((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                    Optional value = property.method_11900(((JsonElement)entry.getValue()).getAsString());
                    if (value.isEmpty()) {
                        throw new JsonParseException("Unknown value '" + ((JsonElement)entry.getValue()).getAsString() + "' for property '" + property.method_11899() + "' in block '" + String.valueOf(identifier) + "'!");
                    }
                    builder.add(value.get());
                } else if (((JsonElement)entry.getValue()).isJsonArray()) {
                    if (((JsonElement)entry.getValue()).getAsJsonArray().isEmpty()) {
                        throw new JsonParseException("Valid values for property '" + property.method_11899() + "' cannot be empty!");
                    }
                    for (JsonElement element : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                        if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString()) {
                            throw new JsonParseException("Property '" + (String)entry.getKey() + "' must be a string or an array of strings!");
                        }
                        Optional value = property.method_11900(element.getAsString());
                        if (value.isEmpty()) {
                            throw new JsonParseException("Unknown value '" + element.getAsString() + "' for property '" + property.method_11899() + "' in block '" + String.valueOf(identifier) + "'!");
                        }
                        builder.add(value.get());
                    }
                } else {
                    throw new JsonParseException("Property '" + (String)entry.getKey() + "' must be a string or an array of strings!");
                }
                properties.add(Pair.of(property, builder.build()));
            }
            properties = Arrays.asList((Pair[])properties.toArray(Pair[]::new));
            return new MatchStateInFrontConnectionPredicate(block, properties);
        }

        @Override
        public JsonObject serialize(MatchStateInFrontConnectionPredicate value) {
            JsonObject json = new JsonObject();
            json.addProperty("block", class_7923.field_41175.method_10221((Object)value.block).toString());
            JsonObject properties = new JsonObject();
            value.properties.stream().map(p -> p.mapRight(values -> {
                JsonArray array = new JsonArray(values.size());
                values.stream().map(v -> ((class_2769)p.left()).method_11901((Comparable)v)).sorted().forEach(arg_0 -> ((JsonArray)array).add(arg_0));
                return array;
            })).map(p -> p.mapLeft(class_2769::method_11899)).sorted(Comparator.comparing(Pair::left)).forEach(pair -> properties.add((String)pair.left(), (JsonElement)pair.right()));
            json.add("properties", (JsonElement)properties);
            return json;
        }
    };
    private final class_2248 block;
    private final List<Pair<class_2769<?>, Set<?>>> properties;
    private boolean compareStates = false;
    private Set<class_2680> states = null;

    public MatchStateInFrontConnectionPredicate(class_2248 block, List<Pair<class_2769<?>, Set<?>>> properties) {
        this.block = block;
        this.properties = properties;
        this.computeStates();
    }

    @SafeVarargs
    public MatchStateInFrontConnectionPredicate(class_2248 block, Pair<class_2769<?>, ?> ... propertyPair) {
        this.block = block;
        HashMap<class_2769, List> propertyMap = new HashMap<class_2769, List>();
        for (Pair<class_2769<?>, ?> pair : propertyPair) {
            class_2769<?> property = pair.left();
            if (!block.method_9595().method_11659().contains(property)) {
                throw new IllegalArgumentException("Property '" + property.method_11899() + "' is not a property of block '" + String.valueOf(class_7923.field_41175.method_10221((Object)block)) + "'!");
            }
            Object value = pair.right();
            if (!property.method_11898().contains(value)) {
                throw new IllegalArgumentException("Invalid value '" + String.valueOf(value) + "' for property '" + property.method_11899() + "'!");
            }
            propertyMap.computeIfAbsent(property, p -> new ArrayList()).add(value);
        }
        Pair[] properties = new Pair[propertyMap.size()];
        int index = 0;
        for (Map.Entry entry : propertyMap.entrySet()) {
            properties[index++] = Pair.of((class_2769)entry.getKey(), ImmutableSet.copyOf((Collection)((Collection)entry.getValue())));
        }
        this.properties = Arrays.asList(properties);
        this.computeStates();
    }

    private <T extends Comparable<T>> void computeStates() {
        HashSet unrestrictedProperties = new HashSet(this.block.method_9595().method_11659());
        int validStates = 1;
        for (Pair<class_2769<?>, Set<?>> pair : this.properties) {
            validStates *= pair.right().size();
            unrestrictedProperties.remove(pair.left());
        }
        for (class_2769 property : unrestrictedProperties) {
            validStates *= property.method_11898().size();
        }
        if (validStates > 64) {
            return;
        }
        Stream<Object> states = Stream.of((class_2680)this.block.method_9595().method_11664());
        for (Pair<class_2769<?>, Set<?>> pair : this.properties) {
            class_2769<?> property = pair.left();
            Set<?> values = pair.right();
            states = states.flatMap(state -> values.stream().map(value -> (class_2680)state.method_11657(property, (Comparable)value)));
        }
        for (class_2769 property : unrestrictedProperties) {
            states = states.flatMap(state -> property.method_30043().map(value -> (class_2680)state.method_11657(property, value.comp_71())));
        }
        this.compareStates = true;
        this.states = states.collect(Collectors.toUnmodifiableSet());
        if (this.states.size() != validStates) {
            throw new AssertionError((Object)("Got two different numbers of valid states: " + validStates + " and " + this.states.size() + "!"));
        }
    }

    @Override
    public boolean shouldConnect(class_2350 side, @Nullable class_2680 ownState, class_2680 otherState, class_2680 blockInFront, ConnectionDirection direction) {
        if (this.compareStates) {
            return this.states.contains(blockInFront);
        }
        if (blockInFront.method_26204() != this.block) {
            return false;
        }
        for (Pair<class_2769<?>, Set<?>> property : this.properties) {
            if (property.right().contains(blockInFront.method_11654(property.left()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Serializer<? extends ConnectionPredicate> getSerializer() {
        return SERIALIZER;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MatchStateInFrontConnectionPredicate)) {
            return false;
        }
        MatchStateInFrontConnectionPredicate that = (MatchStateInFrontConnectionPredicate)o;
        return this.block.equals(that.block) && this.properties.equals(that.properties);
    }

    public int hashCode() {
        int result = this.block.hashCode();
        result = 31 * result + this.properties.hashCode();
        return result;
    }
}

