/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.texture.types.continuous;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.texture.DefaultTextureTypes;
import com.supermartijn642.fusion.api.texture.SpriteCreationContext;
import com.supermartijn642.fusion.api.texture.SpritePreparationContext;
import com.supermartijn642.fusion.api.texture.TextureErrorException;
import com.supermartijn642.fusion.api.texture.TextureType;
import com.supermartijn642.fusion.api.texture.data.BaseTextureData;
import com.supermartijn642.fusion.api.texture.data.ContinuousTextureData;
import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.model.MutableQuad;
import com.supermartijn642.fusion.texture.types.continuous.ContinuousTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;

public class ContinuousTextureType
implements TextureType<ContinuousTextureData> {
    @Override
    public ContinuousTextureData deserialize(JsonObject json) throws JsonParseException {
        BaseTextureData base = (BaseTextureData)DefaultTextureTypes.BASE.deserialize(json);
        ContinuousTextureData.Builder builder = ContinuousTextureData.builder();
        builder.renderType(base.getRenderType());
        builder.emissive(base.isEmissive());
        builder.tinting(base.getTinting());
        if (json.has("rows")) {
            if (!json.get("rows").isJsonPrimitive() || !json.getAsJsonPrimitive("rows").isNumber()) {
                throw new JsonParseException("Property 'rows' must be a number!");
            }
            int rows = json.get("rows").getAsInt();
            if (rows <= 0 || rows > 10) {
                throw new JsonParseException("Property 'rows' must be greater than zero and less than 10!");
            }
            builder.rows(rows);
        }
        if (json.has("columns")) {
            if (!json.get("columns").isJsonPrimitive() || !json.getAsJsonPrimitive("columns").isNumber()) {
                throw new JsonParseException("Property 'columns' must be a number!");
            }
            int columns = json.get("columns").getAsInt();
            if (columns <= 0 || columns > 10) {
                throw new JsonParseException("Property 'columns' must be greater than zero and less than 10!");
            }
            builder.columns(columns);
        }
        return (ContinuousTextureData)builder.build();
    }

    @Override
    public JsonObject serialize(ContinuousTextureData data) {
        JsonObject json = DefaultTextureTypes.BASE.serialize(data);
        if (data.getRows() != 1) {
            json.addProperty("rows", (Number)data.getRows());
        }
        if (data.getColumns() != 1) {
            json.addProperty("columns", (Number)data.getColumns());
        }
        return json;
    }

    @Override
    public Pair<Integer, Integer> getFrameSize(SpritePreparationContext context, ContinuousTextureData data) {
        if (context.getAnimationMetadata() != null) {
            Pair<Integer, Integer> frameSize;
            AnimationMetadataSection animation = context.getAnimationMetadata();
            if (animation.frameWidth != -1 && animation.frameHeight != -1) {
                frameSize = Pair.of(animation.frameWidth, animation.frameHeight);
            } else if (animation.frameWidth != -1) {
                frameSize = Pair.of(animation.frameWidth, context.getTextureHeight());
            } else if (animation.frameHeight != -1) {
                frameSize = Pair.of(context.getTextureWidth(), animation.frameHeight);
            } else {
                int height = Math.min(context.getTextureWidth() * data.getRows() / data.getColumns(), context.getTextureHeight());
                frameSize = Pair.of(context.getTextureWidth(), height);
            }
            if (!Mth.isMultipleOf((int)context.getTextureWidth(), (int)frameSize.left()) || !Mth.isMultipleOf((int)context.getTextureHeight(), (int)frameSize.right())) {
                throw new TextureErrorException("Image size " + context.getTextureWidth() + "x" + context.getTextureHeight() + " is not a multiple of frame size " + frameSize.left() + "x" + frameSize.right() + "!");
            }
            return frameSize;
        }
        int width = context.getTextureWidth();
        int height = context.getTextureHeight();
        if (width * data.getRows() / data.getColumns() != height) {
            throw new TextureErrorException("Image aspect ratio does not match row/column aspect ratio!");
        }
        return Pair.of(width, height);
    }

    @Override
    public TextureAtlasSprite createSprite(SpriteCreationContext context, ContinuousTextureData data) {
        TextureAtlasSprite sprite = context.createOriginalSprite();
        sprite.u1 = sprite.u0 + (sprite.u1 - sprite.u0) / (float)data.getColumns();
        sprite.v1 = sprite.v0 + (sprite.v1 - sprite.v0) / (float)data.getRows();
        return new ContinuousTextureSprite(sprite, data);
    }

    public static void processQuad(MutableQuad quad, BlockPos pos, Direction side, ContinuousTextureSprite sprite) {
        int y;
        int x;
        if (side == null) {
            return;
        }
        ContinuousTextureData data = sprite.data();
        Direction.Axis axis = side.getAxis();
        int n = x = axis == Direction.Axis.X ? pos.getZ() : pos.getX();
        int n2 = axis == Direction.Axis.X ? pos.getY() : (y = axis == Direction.Axis.Y ? pos.getZ() : pos.getY());
        if (side == Direction.NORTH || side == Direction.EAST) {
            x = -x - 1;
        }
        x = x < 0 ? (x % data.getColumns() + data.getColumns()) % data.getColumns() : x % data.getColumns();
        int n3 = y = y < 0 ? (y % data.getRows() + data.getRows()) % data.getRows() : y % data.getRows();
        if (x > 0 || y > 0) {
            float width = sprite.getU1() - sprite.getU0();
            float height = sprite.getV1() - sprite.getV0();
            for (int i = 0; i < 4; ++i) {
                quad.uv(i, quad.u(i) + (float)x * width, quad.v(i) + (float)y * height);
            }
        }
    }
}

