/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.modifiers.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.supermartijn642.fusion.model.types.base.CustomRenderTypeBakedModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;

public class BlockModelModifierBakedModel
implements BakedModel,
CustomRenderTypeBakedModel {
    private static final ModelProperty<IModelData[]> DATA_PROPERTY = new ModelProperty();
    private final BakedModel original;
    private final List<BakedModel> models;
    private final boolean hasNonSimpleModels;
    private final List<BakedModel> nonSimpleModels;
    private final List<BakedQuad> quads;
    private final List<BakedQuad>[] culledQuads = new List[6];
    private final Set<RenderType> customBlockRenderTypes;
    private final boolean hasLayeredModels;

    public BlockModelModifierBakedModel(BakedModel original, List<BakedModel> models) {
        this.original = original;
        this.models = new ArrayList<BakedModel>(models.size() + 1);
        this.models.add(original);
        this.models.addAll(models);
        ArrayList<BakedModel> nonSimpleModels = new ArrayList<BakedModel>();
        ArrayList quads = new ArrayList();
        List[] culledQuads = (List[])IntStream.range(0, 6).mapToObj(i -> new ArrayList()).toArray(List[]::new);
        HashSet<RenderType> customBlockRenderTypes = new HashSet<RenderType>();
        boolean hasLayeredModels = false;
        Random random = new Random();
        for (BakedModel model : this.models) {
            if (!model.getClass().equals(SimpleBakedModel.class)) {
                nonSimpleModels.add(model);
                if (model instanceof CustomRenderTypeBakedModel) {
                    customBlockRenderTypes.addAll(((CustomRenderTypeBakedModel)model).getBlockRenderTypes());
                }
                if (!model.isLayered()) continue;
                hasLayeredModels = true;
                continue;
            }
            quads.addAll(model.m_6840_(null, null, random));
            for (Direction side : Direction.values()) {
                culledQuads[side.ordinal()].addAll(model.m_6840_(null, side, random));
            }
        }
        this.hasNonSimpleModels = !nonSimpleModels.isEmpty();
        this.nonSimpleModels = nonSimpleModels.isEmpty() ? null : List.copyOf(nonSimpleModels);
        this.quads = List.copyOf(quads);
        for (Direction side : Direction.values()) {
            this.culledQuads[side.ordinal()] = List.copyOf(culledQuads[side.ordinal()]);
        }
        this.customBlockRenderTypes = Set.copyOf(customBlockRenderTypes);
        this.hasLayeredModels = hasLayeredModels;
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random random, @Nonnull IModelData data) {
        if (!this.hasNonSimpleModels) {
            return side == null ? this.quads : this.culledQuads[side.ordinal()];
        }
        IModelData[] arr = (IModelData[])data.getData(DATA_PROPERTY);
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(side == null ? this.quads : this.culledQuads[side.ordinal()]);
        for (int i = 0; i < this.nonSimpleModels.size(); ++i) {
            quads.addAll(this.nonSimpleModels.get(i).getQuads(state, side, random, (IModelData)(arr == null || arr[i] == null ? EmptyModelData.INSTANCE : arr[i])));
        }
        return quads;
    }

    @Nonnull
    public List<BakedQuad> m_6840_(@Nullable BlockState state, @Nullable Direction side, Random random) {
        if (!this.hasNonSimpleModels) {
            return side == null ? this.quads : this.culledQuads[side.ordinal()];
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(side == null ? this.quads : this.culledQuads[side.ordinal()]);
        for (BakedModel model : this.nonSimpleModels) {
            quads.addAll(model.m_6840_(state, side, random));
        }
        return quads;
    }

    @Override
    public Collection<RenderType> getBlockRenderTypes() {
        return this.customBlockRenderTypes;
    }

    public boolean isLayered() {
        return this.hasLayeredModels;
    }

    public List<Pair<BakedModel, RenderType>> getLayerModels(ItemStack stack, boolean fabulous) {
        ArrayList<Pair<BakedModel, RenderType>> layers = new ArrayList<Pair<BakedModel, RenderType>>(this.models.size());
        for (BakedModel model : this.models) {
            layers.addAll(model.getLayerModels(stack, fabulous));
        }
        return layers;
    }

    public IModelData getModelData(BlockAndTintGetter level, BlockPos pos, BlockState state, IModelData data) {
        if (!this.hasNonSimpleModels) {
            return data;
        }
        IModelData[] arr = new IModelData[this.nonSimpleModels.size()];
        for (int i = 0; i < this.nonSimpleModels.size(); ++i) {
            arr[i] = this.nonSimpleModels.get(i).getModelData(level, pos, state, data);
        }
        return new ModelDataMap.Builder().withInitial(DATA_PROPERTY, (Object)arr).build();
    }

    public ItemTransforms m_7442_() {
        return this.original.m_7442_();
    }

    public boolean m_7541_() {
        return this.original.m_7541_();
    }

    public boolean m_7539_() {
        return this.original.m_7539_();
    }

    public boolean m_7547_() {
        return this.original.m_7547_();
    }

    public boolean m_7521_() {
        return this.original.m_7521_();
    }

    public TextureAtlasSprite m_6160_() {
        return this.original.m_6160_();
    }

    public ItemOverrides m_7343_() {
        return this.original.m_7343_();
    }

    public boolean isAmbientOcclusion(BlockState state) {
        return this.original.isAmbientOcclusion(state);
    }

    public boolean doesHandlePerspectives() {
        return this.original.doesHandlePerspectives();
    }

    public BakedModel handlePerspective(ItemTransforms.TransformType transformType, PoseStack poseStack) {
        return this.original.handlePerspective(transformType, poseStack);
    }

    public TextureAtlasSprite getParticleIcon(@Nonnull IModelData data) {
        return this.original.getParticleIcon(data);
    }
}

