/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.api.model.modifier.item;

import com.supermartijn642.fusion.api.model.modifier.item.ItemPredicate;
import com.supermartijn642.fusion.api.util.Either;
import com.supermartijn642.fusion.model.modifiers.item.predicates.AndItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.CountItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.DurabilityItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.EnchantmentItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.NotItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.OrItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.PotionItemPredicate;
import java.util.Arrays;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.enchantment.Enchantment;

public class DefaultItemPredicates {
    public static ItemPredicate and(ItemPredicate ... predicates) {
        return new AndItemPredicate(Arrays.asList(predicates));
    }

    public static ItemPredicate or(ItemPredicate ... predicates) {
        return new OrItemPredicate(Arrays.asList(predicates));
    }

    public static ItemPredicate not(ItemPredicate predicate) {
        return new NotItemPredicate(predicate);
    }

    public static ItemPredicate count(int count) {
        return DefaultItemPredicates.count(count, count);
    }

    public static ItemPredicate count(int min, int max) {
        return new CountItemPredicate(Either.left(min), Either.left(max));
    }

    public static ItemPredicate count(int min, float maxPercentage) {
        return new CountItemPredicate(Either.left(min), Either.right(Float.valueOf(maxPercentage)));
    }

    public static ItemPredicate count(float minPercentage, int max) {
        return new CountItemPredicate(Either.right(Float.valueOf(minPercentage)), Either.left(max));
    }

    public static ItemPredicate count(float minPercentage, float maxPercentage) {
        return new CountItemPredicate(Either.right(Float.valueOf(minPercentage)), Either.right(Float.valueOf(maxPercentage)));
    }

    public static ItemPredicate durability(int min, int max) {
        return new DurabilityItemPredicate(Either.left(min), Either.left(max));
    }

    public static ItemPredicate durability(int min, float maxPercentage) {
        return new DurabilityItemPredicate(Either.left(min), Either.right(Float.valueOf(maxPercentage)));
    }

    public static ItemPredicate durability(float minPercentage, int max) {
        return new DurabilityItemPredicate(Either.right(Float.valueOf(minPercentage)), Either.left(max));
    }

    public static ItemPredicate durability(float minPercentage, float maxPercentage) {
        return new DurabilityItemPredicate(Either.right(Float.valueOf(minPercentage)), Either.right(Float.valueOf(maxPercentage)));
    }

    public static ItemPredicate enchantment(Enchantment enchantment) {
        return DefaultItemPredicates.enchantment(enchantment, 1, 255);
    }

    public static ItemPredicate enchantment(Enchantment enchantment, int level) {
        return DefaultItemPredicates.enchantment(enchantment, level, level);
    }

    public static ItemPredicate enchantment(Enchantment enchantment, int minLevel, int maxLevel) {
        return new EnchantmentItemPredicate(enchantment, minLevel, maxLevel);
    }

    public static ItemPredicate potion(Potion potion) {
        return DefaultItemPredicates.potion((Holder<Potion>)BuiltInRegistries.POTION.wrapAsHolder((Object)potion));
    }

    public static ItemPredicate potion(Holder<Potion> potion) {
        return new PotionItemPredicate(potion);
    }
}

