/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.entity.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.supermartijn642.fusion.entity.model.DummyModelPart;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ModelTransformer {
    private static final ModelPart.Vertex[] DUMMY_VERTICES = new ModelPart.Vertex[]{new ModelPart.Vertex(0.0f, 0.0f, 0.0f, 0.0f, 0.0f), new ModelPart.Vertex(0.0f, 0.0f, 0.0f, 0.0f, 0.0f), new ModelPart.Vertex(0.0f, 0.0f, 0.0f, 0.0f, 0.0f), new ModelPart.Vertex(0.0f, 0.0f, 0.0f, 0.0f, 0.0f)};

    public static ModelPart flipX(ModelPart model) {
        return ModelTransformer.transform(model, part -> {
            part.x *= -1.0f;
            part.yRot *= -1.0f;
            part.zRot *= -1.0f;
            PartPose pose = part.initialPose;
            part.initialPose = pose = PartPose.offsetAndRotation((float)(-pose.x()), (float)pose.y(), (float)pose.z(), (float)pose.xRot(), (float)(-pose.yRot()), (float)(-pose.zRot()));
        }, cube -> {
            float maxX = cube.maxX;
            cube.maxX = -cube.minX;
            cube.minX = -maxX;
        }, polygon -> polygon.normal().x *= -1.0f, vertex -> vertex.pos().x *= -1.0f);
    }

    public static ModelPart flipY(ModelPart model) {
        return ModelTransformer.transform(model, part -> {
            part.y *= -1.0f;
            part.xRot *= -1.0f;
            part.zRot *= -1.0f;
            PartPose pose = part.initialPose;
            part.initialPose = pose = PartPose.offsetAndRotation((float)pose.x(), (float)(-pose.y()), (float)pose.z(), (float)(-pose.xRot()), (float)pose.yRot(), (float)(-pose.zRot()));
        }, cube -> {
            float maxY = cube.maxY;
            cube.maxY = -cube.minY;
            cube.minY = -maxY;
        }, polygon -> polygon.normal().y *= -1.0f, vertex -> vertex.pos().y *= -1.0f);
    }

    public static ModelPart flipZ(ModelPart model) {
        return ModelTransformer.transform(model, part -> {
            part.z *= -1.0f;
            part.xRot *= -1.0f;
            part.yRot *= -1.0f;
            PartPose pose = part.initialPose;
            part.initialPose = pose = PartPose.offsetAndRotation((float)pose.x(), (float)pose.y(), (float)(-pose.z()), (float)(-pose.xRot()), (float)(-pose.yRot()), (float)pose.zRot());
        }, cube -> {
            float maxZ = cube.maxZ;
            cube.maxZ = -cube.minZ;
            cube.minZ = -maxZ;
        }, polygon -> polygon.normal().z *= -1.0f, vertex -> vertex.pos().z *= -1.0f);
    }

    public static ModelPart translateX(ModelPart model, float translation) {
        ModelPart copy = ModelTransformer.transform(model, part -> {}, cube -> {}, polygon -> {}, vertex -> {});
        copy.z += (translation *= 16.0f);
        PartPose pose = copy.initialPose;
        copy.initialPose = pose = PartPose.offsetAndRotation((float)pose.x(), (float)pose.y(), (float)(pose.z() + translation), (float)pose.xRot(), (float)pose.yRot(), (float)pose.zRot());
        return copy;
    }

    public static ModelPart translateY(ModelPart model, float translation) {
        ModelPart copy = ModelTransformer.transform(model, part -> {}, cube -> {}, polygon -> {}, vertex -> {});
        copy.y += (translation *= 16.0f);
        PartPose pose = copy.initialPose;
        copy.initialPose = pose = PartPose.offsetAndRotation((float)pose.x(), (float)(pose.y() + translation), (float)pose.z(), (float)pose.xRot(), (float)pose.yRot(), (float)pose.zRot());
        return copy;
    }

    public static ModelPart translateZ(ModelPart model, float translation) {
        ModelPart copy = ModelTransformer.transform(model, part -> {}, cube -> {}, polygon -> {}, vertex -> {});
        copy.x += (translation *= 16.0f);
        PartPose pose = copy.initialPose;
        copy.initialPose = pose = PartPose.offsetAndRotation((float)(pose.x() + translation), (float)pose.y(), (float)pose.z(), (float)pose.xRot(), (float)pose.yRot(), (float)pose.zRot());
        return copy;
    }

    private static ModelPart transform(ModelPart part, Consumer<ModelPart> partTransform, Consumer<ModelPart.Cube> cubeTransform, Consumer<ModelPart.Polygon> polygonTransform, Consumer<ModelPart.Vertex> vertexTransform) {
        DummyModelPart copy;
        if (part instanceof DummyModelPart) {
            copy = new DummyModelPart(ModelTransformer.transform(((DummyModelPart)part).getDummyChild(), partTransform, cubeTransform, polygonTransform, vertexTransform));
        } else {
            ImmutableList.Builder cubes = ImmutableList.builderWithExpectedSize((int)part.cubes.size());
            for (ModelPart.Cube cube : part.cubes) {
                cubes.add((Object)ModelTransformer.transform(cube, cubeTransform, polygonTransform, vertexTransform));
            }
            ImmutableMap.Builder children = ImmutableMap.builderWithExpectedSize((int)part.children.size());
            for (Map.Entry entry : part.children.entrySet()) {
                children.put((Object)((String)entry.getKey()), (Object)ModelTransformer.transform((ModelPart)entry.getValue(), partTransform, cubeTransform, polygonTransform, vertexTransform));
            }
            copy = new ModelPart((List)cubes.build(), (Map)children.build());
        }
        copy.x = part.x;
        copy.y = part.y;
        copy.z = part.z;
        copy.xRot = part.xRot;
        copy.yRot = part.yRot;
        copy.zRot = part.zRot;
        copy.xScale = part.xScale;
        copy.yScale = part.yScale;
        copy.zScale = part.zScale;
        copy.visible = part.visible;
        copy.skipDraw = part.skipDraw;
        copy.initialPose = part.initialPose;
        partTransform.accept(copy);
        return copy;
    }

    private static ModelPart.Cube transform(ModelPart.Cube cube, Consumer<ModelPart.Cube> cubeTransform, Consumer<ModelPart.Polygon> polygonTransform, Consumer<ModelPart.Vertex> vertexTransform) {
        ModelPart.Cube copy = new ModelPart.Cube(0, 0, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, false, 0.0f, 0.0f, Set.of());
        copy.polygons = (ModelPart.Polygon[])Arrays.stream(cube.polygons).map(p -> ModelTransformer.transform(p, polygonTransform, vertexTransform)).toArray(ModelPart.Polygon[]::new);
        copy.minX = cube.minX;
        copy.minY = cube.minY;
        copy.minZ = cube.minZ;
        copy.maxX = cube.maxX;
        copy.maxY = cube.maxY;
        copy.maxZ = cube.maxZ;
        return copy;
    }

    private static ModelPart.Polygon transform(ModelPart.Polygon polygon, Consumer<ModelPart.Polygon> polygonTransform, Consumer<ModelPart.Vertex> vertexTransform) {
        return new ModelPart.Polygon((ModelPart.Vertex[])Arrays.stream(polygon.vertices()).map(v -> ModelTransformer.transform(v, vertexTransform)).toArray(ModelPart.Vertex[]::new), polygon.normal());
    }

    private static ModelPart.Vertex transform(ModelPart.Vertex vertex, Consumer<ModelPart.Vertex> vertexTransform) {
        ModelPart.Vertex copy = new ModelPart.Vertex(new Vector3f((Vector3fc)vertex.pos()), vertex.u(), vertex.v());
        vertexTransform.accept(copy);
        return copy;
    }
}

