/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion;

import com.supermartijn642.fusion.Fusion;
import com.supermartijn642.fusion.api.model.DefaultModelTypes;
import com.supermartijn642.fusion.api.model.FusionModelTypeRegistry;
import com.supermartijn642.fusion.api.predicate.FusionPredicateRegistry;
import com.supermartijn642.fusion.api.texture.DefaultTextureTypes;
import com.supermartijn642.fusion.api.texture.FusionTextureTypeRegistry;
import com.supermartijn642.fusion.api.texture.data.BaseTextureData;
import com.supermartijn642.fusion.model.modifiers.item.predicates.AndItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.CountItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.DurabilityItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.EnchantmentItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.ItemPredicateRegistry;
import com.supermartijn642.fusion.model.modifiers.item.predicates.NotItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.OrItemPredicate;
import com.supermartijn642.fusion.model.modifiers.item.predicates.PotionItemPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.AndConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.IsDirectionConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.IsFaceVisibleConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.IsSameBlockConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.IsSameStateConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.MatchBlockConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.MatchBlockInFrontConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.MatchStateConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.MatchStateInFrontConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.NotConnectionPredicate;
import com.supermartijn642.fusion.model.types.connecting.predicates.OrConnectionPredicate;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FusionClient {
    public static final Logger LOGGER = LogManager.getLogger((String)"fusion");
    private static String fusionVersion;

    public static void init() {
        FusionTextureTypeRegistry.registerTextureType(new ResourceLocation("fusion", "vanilla"), DefaultTextureTypes.VANILLA);
        FusionTextureTypeRegistry.registerTextureType(new ResourceLocation("fusion", "base"), DefaultTextureTypes.BASE);
        FusionTextureTypeRegistry.registerTextureType(new ResourceLocation("fusion", "connecting"), DefaultTextureTypes.CONNECTING);
        FusionTextureTypeRegistry.registerTextureType(new ResourceLocation("fusion", "scrolling"), DefaultTextureTypes.SCROLLING);
        FusionTextureTypeRegistry.registerTextureType(new ResourceLocation("fusion", "random"), DefaultTextureTypes.RANDOM);
        FusionTextureTypeRegistry.registerTextureType(new ResourceLocation("fusion", "continuous"), DefaultTextureTypes.CONTINUOUS);
        FusionModelTypeRegistry.registerModelType(new ResourceLocation("fusion", "unknown"), DefaultModelTypes.UNKNOWN);
        FusionModelTypeRegistry.registerModelType(new ResourceLocation("fusion", "vanilla"), DefaultModelTypes.VANILLA);
        FusionModelTypeRegistry.registerModelType(new ResourceLocation("fusion", "base"), DefaultModelTypes.BASE);
        FusionModelTypeRegistry.registerModelType(new ResourceLocation("fusion", "connecting"), DefaultModelTypes.CONNECTING);
        FusionPredicateRegistry.registerConnectionPredicate(new ResourceLocation("fusion", "and"), AndConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(new ResourceLocation("fusion", "or"), OrConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(new ResourceLocation("fusion", "not"), NotConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(new ResourceLocation("fusion", "is_direction"), IsDirectionConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(new ResourceLocation("fusion", "is_face_visible"), IsFaceVisibleConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(new ResourceLocation("fusion", "is_same_block"), IsSameBlockConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(new ResourceLocation("fusion", "is_same_state"), IsSameStateConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(new ResourceLocation("fusion", "match_block"), MatchBlockConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(new ResourceLocation("fusion", "match_block_in_front"), MatchBlockInFrontConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(new ResourceLocation("fusion", "match_state"), MatchStateConnectionPredicate.SERIALIZER);
        FusionPredicateRegistry.registerConnectionPredicate(new ResourceLocation("fusion", "match_state_in_front"), MatchStateInFrontConnectionPredicate.SERIALIZER);
        ItemPredicateRegistry.registerItemPredicate(new ResourceLocation("fusion", "and"), AndItemPredicate.SERIALIZER);
        ItemPredicateRegistry.registerItemPredicate(new ResourceLocation("fusion", "or"), OrItemPredicate.SERIALIZER);
        ItemPredicateRegistry.registerItemPredicate(new ResourceLocation("fusion", "not"), NotItemPredicate.SERIALIZER);
        ItemPredicateRegistry.registerItemPredicate(new ResourceLocation("fusion", "count"), CountItemPredicate.SERIALIZER);
        ItemPredicateRegistry.registerItemPredicate(new ResourceLocation("fusion", "durability"), DurabilityItemPredicate.SERIALIZER);
        ItemPredicateRegistry.registerItemPredicate(new ResourceLocation("fusion", "enchantment"), EnchantmentItemPredicate.SERIALIZER);
        ItemPredicateRegistry.registerItemPredicate(new ResourceLocation("fusion", "potion"), PotionItemPredicate.SERIALIZER);
    }

    public static BlockRenderLayer getRenderTypeMaterial(BaseTextureData.RenderType renderType) {
        BlockRenderLayer material;
        if (renderType == null) {
            return null;
        }
        switch (renderType) {
            case OPAQUE: {
                material = BlockRenderLayer.SOLID;
                break;
            }
            case CUTOUT: {
                material = BlockRenderLayer.CUTOUT;
                break;
            }
            case TRANSLUCENT: {
                material = BlockRenderLayer.TRANSLUCENT;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return material;
    }

    public static String getFusionVersion() {
        if (fusionVersion == null) {
            String version = Fusion.class.getDeclaredAnnotation(Mod.class).version();
            if (!version.matches("\\d+\\.\\d+\\.\\d+")) {
                version = version.substring(0, version.length() - version.replaceFirst("\\d+\\.\\d+\\.\\d+\\D", "").length() - 1);
            }
            fusionVersion = version;
        }
        return fusionVersion;
    }
}

