/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.api.provider;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.ResourceGenerator;
import com.supermartijn642.core.generator.ResourceType;
import com.supermartijn642.fusion.api.texture.FusionTextureTypeRegistry;
import com.supermartijn642.fusion.api.texture.TextureType;
import com.supermartijn642.fusion.api.util.Pair;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;

public abstract class FusionTextureMetadataProvider
extends ResourceGenerator {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
    private final Map<ResourceLocation, Pair<TextureType<Object>, Object>> metadata = new HashMap<ResourceLocation, Pair<TextureType<Object>, Object>>();

    public FusionTextureMetadataProvider(String modid, ResourceCache cache) {
        super(modid, cache);
    }

    public void save() {
        for (Map.Entry<ResourceLocation, Pair<TextureType<Object>, Object>> entry : this.metadata.entrySet()) {
            ResourceLocation location = entry.getKey();
            Pair<TextureType<Object>, Object> metadata = entry.getValue();
            String extension = location.func_110623_a().endsWith(".mcmeta") ? "" : (location.func_110623_a().lastIndexOf(46) > location.func_110623_a().lastIndexOf(47) ? ".mcmeta" : ".png.mcmeta");
            JsonObject json = new JsonObject();
            json.add("fusion", (JsonElement)FusionTextureTypeRegistry.serializeTextureData(metadata.left(), metadata.right()));
            this.cache.saveResource(ResourceType.ASSET, GSON.toJson((JsonElement)json).getBytes(StandardCharsets.UTF_8), location.func_110624_b(), "textures", location.func_110623_a(), extension);
        }
    }

    public abstract void generate();

    public final <T> void addTextureMetadata(ResourceLocation location, TextureType<T> textureType, T data) {
        Pair<TextureType<T>, T> previousValue = this.metadata.put(location, Pair.of(textureType, data));
        if (previousValue != null) {
            throw new RuntimeException("Duplicate texture metadata for '" + location + "'!");
        }
    }

    public String getName() {
        return "Fusion Texture Metadata Provider: " + this.modName;
    }
}

