/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin;

import com.supermartijn642.fusion.api.texture.data.BaseTextureData;
import com.supermartijn642.fusion.model.types.connecting.ConnectingBakedModel;
import com.supermartijn642.fusion.model.types.connecting.SurroundingBlockCache;
import com.supermartijn642.fusion.texture.QuadTintingHelper;
import com.supermartijn642.fusion.texture.types.base.BaseTextureSprite;
import java.util.BitSet;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockModelRenderer.class}, priority=900)
public class BlockModelRendererMixin {
    @Inject(method={"renderModelSmooth(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/client/renderer/block/model/IBakedModel;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/client/renderer/BufferBuilder;ZJ)Z"}, at={@At(value="HEAD")})
    private void renderModelSmoothHead(IBlockAccess level, IBakedModel model, IBlockState state, BlockPos pos, BufferBuilder buffer, boolean checkSides, long random, CallbackInfoReturnable<Boolean> ci) {
        ConnectingBakedModel.BLOCK_CACHE.set(new SurroundingBlockCache(level, pos, state));
    }

    @Inject(method={"renderModelSmooth(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/client/renderer/block/model/IBakedModel;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/client/renderer/BufferBuilder;ZJ)Z"}, at={@At(value="RETURN")})
    private void renderModelSmoothTail(IBlockAccess level, IBakedModel model, IBlockState state, BlockPos pos, BufferBuilder buffer, boolean checkSides, long random, CallbackInfoReturnable<Boolean> ci) {
        ConnectingBakedModel.BLOCK_CACHE.remove();
    }

    @Inject(method={"renderModelFlat(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/client/renderer/block/model/IBakedModel;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/client/renderer/BufferBuilder;ZJ)Z"}, at={@At(value="HEAD")})
    private void renderModelFlatHead(IBlockAccess level, IBakedModel model, IBlockState state, BlockPos pos, BufferBuilder buffer, boolean checkSides, long random, CallbackInfoReturnable<Boolean> ci) {
        ConnectingBakedModel.BLOCK_CACHE.set(new SurroundingBlockCache(level, pos, state));
    }

    @Inject(method={"renderModelFlat(Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/client/renderer/block/model/IBakedModel;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/client/renderer/BufferBuilder;ZJ)Z"}, at={@At(value="RETURN")})
    private void renderModelFlatTail(IBlockAccess level, IBakedModel model, IBlockState state, BlockPos pos, BufferBuilder buffer, boolean checkSides, long random, CallbackInfoReturnable<Boolean> ci) {
        ConnectingBakedModel.BLOCK_CACHE.remove();
    }

    @ModifyVariable(method={"renderQuadsSmooth"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/BufferBuilder;putPosition(DDD)V", shift=At.Shift.BEFORE), ordinal=0)
    private BakedQuad tintQuadAO(BakedQuad quad, IBlockAccess level, IBlockState state, BlockPos pos, BufferBuilder vertexConsumer, List<BakedQuad> quads, float[] arr, BitSet bitSet, BlockModelRenderer.AmbientOcclusionFace occlusion) {
        BaseTextureData.QuadTinting tinting;
        TextureAtlasSprite sprite;
        if (quad.field_178213_b == 39216 && (sprite = quad.func_187508_a()) instanceof BaseTextureSprite && (tinting = ((BaseTextureSprite)sprite).data().getTinting()) != null) {
            int color = QuadTintingHelper.getColor(tinting, state, level, pos);
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            vertexConsumer.func_178978_a(occlusion.field_178206_b[0] * red, occlusion.field_178206_b[0] * green, occlusion.field_178206_b[0] * blue, 4);
            vertexConsumer.func_178978_a(occlusion.field_178206_b[1] * red, occlusion.field_178206_b[1] * green, occlusion.field_178206_b[1] * blue, 3);
            vertexConsumer.func_178978_a(occlusion.field_178206_b[2] * red, occlusion.field_178206_b[2] * green, occlusion.field_178206_b[2] * blue, 2);
            vertexConsumer.func_178978_a(occlusion.field_178206_b[3] * red, occlusion.field_178206_b[3] * green, occlusion.field_178206_b[3] * blue, 1);
        }
        return quad;
    }

    @ModifyVariable(method={"renderQuadsFlat"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/BufferBuilder;putPosition(DDD)V", shift=At.Shift.BEFORE), ordinal=0)
    private BakedQuad tintQuadFlat(BakedQuad quad, IBlockAccess level, IBlockState state, BlockPos pos, int lightmap, boolean recalculateLight, BufferBuilder vertexConsumer) {
        BaseTextureData.QuadTinting tinting;
        TextureAtlasSprite sprite;
        if (quad.field_178213_b == 39216 && (sprite = quad.func_187508_a()) instanceof BaseTextureSprite && (tinting = ((BaseTextureSprite)sprite).data().getTinting()) != null) {
            int color = QuadTintingHelper.getColor(tinting, state, level, pos);
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            vertexConsumer.func_178978_a(red, green, blue, 4);
            vertexConsumer.func_178978_a(red, green, blue, 3);
            vertexConsumer.func_178978_a(red, green, blue, 2);
            vertexConsumer.func_178978_a(red, green, blue, 1);
        }
        return quad;
    }
}

